    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>">
    <input type="hidden" id="operation" name="operation" value="<?= (!empty($operation)) ? encode_form_val($operation) :"" ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= (!empty($selectedhostconfig)) ? encode_form_val($selectedhostconfig) : "" ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($ip_address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="token" value="<?= encode_form_val($token) ?>">
    <input type="hidden" name="no_ssl_verify" value="<?= intval($no_ssl_verify) ?>">
    <input type="hidden" name="os" value="<?= encode_form_val($os) ?>">
    <input type="hidden" name="job_id" value="<?= intval($job_id) ?>">

<?php
    if (!empty($hosts)) {
        foreach ($hosts as $host) {
?>
    <input type="hidden" name="hosts[]" value="<?= encode_form_val($host) ?>">
<?php
        }
    }

    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

<?php
    # TODO: Test multi-host
    if (!empty($hosts)) {
?>
        <!--                            -->
        <!-- Multiple Hosts Information -->
        <!--                            -->
        <h2><?= _("Host Information") ?></h2>
        <p><?= _('Adding the following service checks to the below hosts') ?></p>

        <div class="row mb-3 mt-4">
            <div class="col-sm">
                <label class="form-check-label bold"><?= _('Hostname') ?></label>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-sm-6">
<?php
        foreach ($hosts as $host) {
?>
                <?= encode_form_val($host) ?><br>
<?php
        }
?>
            </div>
        </div>
<?php
    } else {
?>
        <!--                            -->
        <!-- Host Information           -->
        <!--                            -->
        <h2 class="mt-4 mb-2"><?= _("Host Information") ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _("Address") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _("Host Name") ?> <?= xi6_info_tooltip(_("The hostname you'd like to have associated with this host.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("Port") ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="" id="" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="" class="form-label"><?= _("System") ?> </label>
                <div><?= $icon ?></div>
            </div>
        </div>
<?php
    }
?>
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->

        <!--                            -->
        <!-- System Metrics             -->
        <!--                            -->
        <h2 class="mt-4"><?= _("System Metrics") ?></h2>
        <p><?= _("Specify the metrics you'd like to monitor with the NCPA Agent") ?>.</p>

<?php
    # Linux Server Additions to standard NCPA
    # START
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" id="ping" name="services[ping][monitor]" <?= is_checked(grab_array_var($services['ping'], "monitor"), "on") ?>>
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_('Monitors the server with an ICMP ping. Useful for watching network latency and general uptime.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" name="services[totalprocs][monitor]" id="totalprocs" <?= is_checked(grab_array_var($services['totalprocs'], "monitor"), "on") ?>>
                        <label for="totalprocs" class="form-check-label bold"><?= _('Total Processes') ?> <?= xi6_info_tooltip(_('Monitors the total number of processes running on the server.')) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" id="services[totalprocs][warning]" name="services[totalprocs][warning]" value="<?= encode_form_val($services['totalprocs']['warning']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_totalprocs_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[totalprocs][critical]" name="services[totalprocs][critical]" value="<?= encode_form_val($services['totalprocs']['critical']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_totalprocs_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
<?php
    if (!empty($totalprocs_data)) {
?>
                            <div class="col-sm-4 mt-0 ps-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text"><i class="material-symbols-outlined md-18 md-400" aria-hidden="true">groups</i></span>
                                    <input type="text" id="totalprocs_data" value="<?= $totalprocs_data ?>" class="form-control form-control-sm">
                                    <label for="totalprocs_data" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current Process Count.')) ?></label>
                                </div>
                            </div>
<?php
    }
?>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    # PLACEHOLDER FOR NEW Linux Server Additions to NCPA
    # START
/*
    $RHEL = ($os == "rhel" || $os == "fedora" || $os == "centos" || $os == "oracle");
    if ($RHEL) {
?>
            <td>
                <input type="checkbox" class="checkbox" id="yum" name="services[yum]" <?= is_checked(grab_array_var($services['yum'], "monitor"), "on") ?>>
            </td>
            <td colspan=2>
                <label for="yum" class="select-cf-option"><?= _('Yum Update Status') ?></label><br>
                <?= _("Monitors the server to ensure it's up to date with the latest RPM packages") ?>.
            </td>
        </tr>
<?php
    }

    $DEB = ($os == "debian" || $os == "ubuntu");
    if ($DEB) {
?>
            <td>
                <input type="checkbox" class="checkbox" id="apt" name="services[apt]" <?= is_checked(grab_array_var($services['apt'], "monitor"), "on") ?>>
            </td>
            <td colspan=2>
                <label for="apt" class="select-cf-option"><?= _('APT Update Status') ?></label><br>
                <?= _("Monitors the server to ensure it's up to date with the latest DEB packages") ?>.
            </td>
        </tr>
<?php
    }

    $SUSE = ($os == "suse" || $os == "opensuse");
?>
            <td class="vt">
                <input type="checkbox" class="checkbox" id="load" name="services[load]" <?= is_checked(grab_array_var($services['load'], "monitor"), "on") ?>>
            </td>
            <td colspan=2>
                <label for="load" class="select-cf-option"><?= _('Load') ?></label><br>
                <?= _('Monitors the load on the server (1,5,15 minute values)') ?>.
                <div class="pad-t5">
                    <label><img src="<?= theme_image('error.png') ?>" class="tt-bind" title="<?= _('Warning Threshold') ?>"></label> <input type="text" size="7" name="services[load][warning]" value="<?= $services["load"]["warning"] ?>" class="textfield form-control condensed"> &nbsp; <label><img src="<?= theme_image('critical_small.png') ?>" class="tt-bind" title="<?= _('Critical Threshold') ?>"></label> <input type="text" size="7" name="services[load][critical]" value="<?= $services["load"]["critical"] ?>" class="textfield form-control condensed">
                </div>
            </td>
        </tr>
            <td class="vt">
                <input type="checkbox" class="checkbox" id="opf" name="services[openfiles]" <?= is_checked(grab_array_var($services['openfiles'], "monitor"), "on") ?>>
            </td>
            <td colspan=2>
                <label for="opf" class="select-cf-option"><?= _('Open Files') ?></label><br>
                <?= _('Monitors the number of open files on the server') ?>.
                <div class="pad-t5">
                    <label><img src="<?= theme_image('error.png') ?>" class="tt-bind" title="<?= _('Warning Threshold') ?>"></label> <input type="text" size="2" name="services[openfiles][warning]" value="<?= $services["openfiles"]["warning"] ?>" class="textfield form-control condensed"> &nbsp; <label><img src="<?= theme_image('critical_small.png') ?>" class="tt-bind" title="<?= _('Critical Threshold') ?>"></label> <input type="text" size="2" name="services[openfiles][critical]" value="<?= $services["openfiles"]["critical"] ?>" class="textfield form-control condensed">
                </div>
            </td>
        </tr>
<?php
*/
    # END
    # PLACEHOLDER FOR NEW Linux Server Additions to NCPA
    # END
    # Linux Server Additions to standard NCPA
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="cpum" class="form-check-input" name="services[cpu_usage][monitor]"  <?= is_checked(grab_array_var($services['cpu_usage'], "monitor"), "on") ?>>
                        <label for="cpum" class="form-check-label bold"><?= _('CPU Usage') ?> <?= xi6_info_tooltip(_('Check the CPU usage of the system.')) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" id="services[cpu_usage][warning]" name="services[cpu_usage][warning]" value="<?= encode_form_val($services['cpu_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_cpu_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[cpu_usage][critical]" name="services[cpu_usage][critical]" value="<?= encode_form_val($services['cpu_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="services_cpu_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
<?php
    if (!empty($cpu_data)) {
?>
                            <div class="col-sm-4 mt-0 ps-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text form-check-label bold"><?= _('CPU') ?></span>
                                    <input type="text" id="currentCPU" value="<?= $cpu_data[0][0] ?>" class="form-control form-control-sm">
                                    <span class="input-group-text rounded-end">%</span>
                                    <label for="currentCPU" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current CPU Usage.')) ?></label>
                                </div>
                            </div>
<?php
    }
?>
                        </div>
                        <div class="row g-0 p-0">
                            <div class="col-sm-12 mt-2 pe-1">
                                <input type="checkbox" class="form-check-input" name="services[cpu_usage][average]" id="services[cpu_usage][average]" <?= is_checked($services['cpu_usage']['average'], 1) ?>>
                                <label for="services[cpu_usage][average]" class="form-check-label bold"><?= _('Show average CPU usage instead of per cpu core') ?></label>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" name="services[users][monitor]" id="ucount" <?= is_checked(grab_array_var($services['users'], "monitor"), "on") ?>>
                        <label for="ucount" class="form-check-label bold"><?= _('User Count') ?> <?= xi6_info_tooltip(_('Check the number of users currently logged into the system.')) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="row g-0 p-0">
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" id="services[users][warning]" name="services[users][warning]" value="<?= encode_form_val($services['users']['warning']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_users_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0 pe-1">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" id="services[users][critical]" name="services[users][critical]" value="<?= encode_form_val($services['users']['critical']) ?>" class="form-control form-control-sm monitor">
                                    <i id="services_users_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
<?php
    if (!empty($user_data)) {
?>
                            <div class="col-sm-4 mt-0 ps-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text"><i class="material-symbols-outlined md-18 md-400" aria-hidden="true">groups</i></span>
                                    <input type="text" id="currentUsers" value="<?= $user_data[0] ?>" class="form-control form-control-sm">
                                    <label for="currentUsers" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current User Count.')) ?></label>
                                </div>
                            </div>
<?php
    }
?>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <!--                            -->
        <!-- Memory Metrics             -->
        <!--                            -->
        <h2 class="mt-4 mb-2"><?= _('Memory Metrics') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-8">
                <fieldset class="row g-2 mt-0 mb-1 wz-fieldset">
                    <div class="form-check col-sm-9 mt-0 pt-0 ps-0">
                        <label for="default_mem_units" class="form-check-label bold select-cf-option"><?= _('Default units for memory metric ouput') ?></label>
                        <div class="input-group position-relative col-sm-8">
                            <select class="form-select form-select-sm form-control-sm monitor rounded" id="default_mem_units" name="default_mem_units">
                                <option value="b" <?= is_selected($default_mem_units, 'b') ?>>b</option>
                                <option value="B" <?= is_selected($default_mem_units, 'B') ?>>B</option>
                                <option value="k" <?= is_selected($default_mem_units, 'k') ?>>k</option>
                                <option value="Ki" <?= is_selected($default_mem_units, 'Ki') ?>>Ki</option>
                                <option value="G" <?= is_selected($default_mem_units, 'G') ?>>G</option>
                                <option value="Gi" <?= is_selected($default_mem_units, 'Gi') ?>>Gi</option>
                                <option value="T" <?= is_selected($default_mem_units, 'T') ?>>T</option>
                                <option value="Ti" <?= is_selected($default_mem_units, 'Ti') ?>>Ti</option>
                            </select>
                            <div class="invalid-feedback">
                                Please select the default units of measure.
                            </div>
                            <i id="default_mem_units_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="mainm" class="form-check-input" name="services[memory_usage][monitor]"  <?= is_checked(grab_array_var($services['memory_usage'], 'monitor'), 'on') ?> >
                        <label for="mainm" class="form-check-label bold"><?= _('Main Memory Usage') ?> <?= xi6_info_tooltip(_("Monitor memory usage as percentage of memory used.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="services[memory_usage][warning]" name="services[memory_usage][warning]" value="<?= encode_form_val($services['memory_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_memory_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[memory_usage][critical]" name="services[memory_usage][critical]" value="<?= encode_form_val($services['memory_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_memory_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
    if (!empty($mem_data)) {
?>
                    <div class="col-sm-3 mt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <input type="text" id="currentMem" value="<?= $mem_data[0] ?>" class="form-control form-control-sm">
                            <span class="input-group-text rounded-end">%</span>
                            <label for="currentMem" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current Memory Usage.')) ?></label>
                        </div>
                    </div>
<?php
    }
?>              </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="swapm" class="form-check-input" name="services[swap_usage][monitor]"  <?= is_checked(grab_array_var($services['swap_usage'], 'monitor'), 'on') ?>>
                        <label for="swapm" class="form-check-label bold"><?= _('Swap Usage') ?> <?= xi6_info_tooltip(_("Monitor the percentage of allocated swap used.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="services[swap_usage][warning]" name="services[swap_usage][warning]" value="<?= encode_form_val($services['swap_usage']['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_swap_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="services[swap_usage][critical]" name="services[swap_usage][critical]" value="<?= encode_form_val($services['swap_usage']['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="services_swap_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
    if (!empty($swap_data)) {
?>
                    <div class="col-sm-3 mt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <input type="text" id="currentSwap" value="<?= floatval($swap_data[0]) ?>" class="form-control form-control-sm">
                            <span class="input-group-text rounded-end">%</span>
                            <label for="currentSwap" class="form-check-label bold mt-1 ps-1"><?= xi6_info_tooltip(_('Current Swap Usage.')) ?></label>
                        </div>
                    </div>
<?php
    }

    $curr_usage = '';

    if (empty($hosts)) {
?>
                    <div class="col-sm">
                        <div class="input-group input-group-sm">
                            <label class="form-check-label bold"><? _('Current Usage.') ?></label>
                        </div>
                    </div>
<?php
    }
?>
                </fieldset>
            </div>
        </div>

        <!--                            -->
        <!-- Disk Metrics               -->
        <!--                            -->
        <h2 class="mt-4"><?= _("Disk Metrics") ?></h2>
        <p><?= _("Specify the disks the the warning and critical percentages for disk capacity") ?>.</p>

<?php
    if (!empty($hosts)) {
?>
    <p><b><?= _('Disk checks specified will be applied to all hosts. If the disk name does not exist it will show CRITICAL') ?></b></p>

<?php
    }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-3 mt-0">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Disk/Mount') ?></label>
                    </div>
<?php
    if (empty($hosts)) {
?>
                    <div class="col-sm-3 mt-0">
                        <label class="form-check-label bold"><?= _('Current Usage') ?></label>
                    </div>
<?php
    }
?>
                    <div class="col-sm-3 mt-0">
                        <label class="form-check-label bold"><?= _('Thresholds') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    $disabled = ' readonly';

    if (!empty($hosts)) {
        $disabled = '';
    }

    $id = 0;

    foreach ($services['disk'] as $id => $metrics) {
        $title = !empty($metrics['title']) ? $metrics['title'] : $metrics['name'];
        $titleout = str_replace('|', '\\', $title);

        if (array_key_exists('total', $root['disk']['logical'][$title])) {
            $disk_total = $root['disk']['logical'][$title]['total'][0].' '.$root['disk']['logical'][$title]['total'][1].' '._('Total');
        }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-0">
                        <div class="input-group input-group-sm">
                            <input type="checkbox" id="d<?= $id ?>" class="form-check-input mt-2 me-2" name="services[disk][<?= $id ?>][monitor]" <?= is_checked(grab_array_var($services['disk'][$id], 'monitor'), 'on') ?>>
                            <input type="hidden" name="services[disk][<?= $id ?>][title]" value="<?= encode_form_val($title) ?>">
                            <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[disk][<?= $id ?>][name]" id="services[disk][<?= $id ?>][name]" value="<?= encode_form_val($titleout) ?>" <?= $disabled ?>>
                            <input type="hidden" name="services[disk][<?= $id ?>][name]" value="<?= encode_form_val($titleout) ?>">
                        </div>
                    </div>
<?php
        if (array_key_exists('total', $root['disk']['logical'][$title])) {
?>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <input type="text" name="services[disk][<?= $id ?>][warning]" id="services[disk][<?= $id ?>][warning]" value="<?= floatval($root['disk']['logical'][$title]['used_percent'][0]) ?>" class="form-control form-control-sm monitor" readonly>
                            <span class="input-group-text rounded-end">%</span>
                            <span class="me-2 mt-1 ps-1"><?= xi6_info_tooltip($disk_total) ?></span>
                            <i id="services_disk_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
<?php
        }
?>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" name="services[disk][<?= $id ?>][warning]" id="services[disk][<?= $id ?>][warning]" value="<?= encode_form_val($services['disk'][$id]['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_disk_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" name="services[disk][<?= $id ?>][critical]" id="services[disk][<?= $id ?>][critical]" value="<?= encode_form_val($services['disk'][$id]['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="services_disk_<?= $id ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
        $id++;
    }
?>

<?php
    if (!empty($hosts)) {
?>
        <p><a id="add-disk"><?= _("Add Disk Check") ?></a></p>
<?php
    }
?>
        <!--                            -->
        <!-- Network Interface Metrics  -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Network Interface Metrics') ?></h2>
        <p><?= _("Specify bandwidth limits for your network interfaces. Note that these measurements are per second, not a counter.") ?></p>
<?php
    if (!empty($hosts)) {
?>
        <p><b><?= _('Interface checks specified will be applied to all hosts. If the interface name does not exist it will show CRITICAL') ?></b></p>
<?php
    }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-3 mt-0">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Interface Name') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <label class="form-check-label bold"><?= _('Thresholds') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="interfaces-list">
<?php
    $disabled = ' readonly';

    if (!empty($hosts)) {
        $disabled = '';
    }

    $id = 0;
    $hidden = false;

    foreach ($services['interface'] as $id => $metrics) {
        $hide = '';
        $title = $metrics['name'];

        if (!is_checked(grab_array_var($services['interface'][$id], 'monitor'), 'on') && empty($hosts)) {
            $hide = 'hidden-interface visually-hidden';
        }
?>
            <div class="row interface <?= $hide ?>">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" id="ni<?= $id ?>" class="form-check-input mt-2 me-2" name="services[interface][<?= $id ?>][monitor]" <?= is_checked(grab_array_var($services['interface'][$id], 'monitor'), 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[interface][<?= $id ?>][name]" id="services[interface][<?= $id ?>][name]" value="<?= encode_form_val(str_replace("|", "/", $title)) ?>"<?= $disabled ?>>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" name="services[interface][<?= $id ?>][warning]" id="services[interface][<?= $id ?>][warning]" value="<?= encode_form_val($services['interface'][$id]['warning']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text rounded-end">MB/s</span>
                                <i id="services_interface_<?= $id ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" name="services[interface][<?= $id ?>][critical]" id="services[interface][<?= $id ?>][critical]" value="<?= encode_form_val($services['interface'][$id]['critical']) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text rounded-end">MB/s</span>
                                <i id="services_interface_<?= $id ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        $id++;
    }
?>
        </div> <!-- interfaces-list -->

<?php
    if (empty($hosts)) {
?>
        <p><a class="btn btn-link show-hidden-interfaces"><?= _("Show all interfaces") ?></a></p>
<?php
    } else {
?>
        <p><a id="add-interface"><?= _("Add Interface Check") ?></a></p>
<?php
    }
?>
        <!--                            -->
        <!-- Services                   -->
        <!--                            -->
        <h2 class="mt-4"><?= _("Services") ?></h2>
        <p><?= _("Specify which services should be running or stopped.") ?> <?= xi6_info_tooltip(_("Depending on the selected state, you will recieve an OK when the process is in the selected state and a CRITICAL if the process is not in the state selected.")) ?></p>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2">
                    <div class="col-sm-4 mt-0">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Service Description') ?></label>
                    </div>
                    <div class="col-sm-4 mt-0">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Service Name') ?></label>
                    </div>
                    <div class="col-sm-4 mt-0 ps-4">
                        <label class="form-check-label bold"><?= _('Expected Status') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="services-list">
<?php
    foreach ($services['services'] as $i => $metrics) {
?>
            <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" name="services[services][<?= $i ?>][monitor]" id="services[services][<?= $i ?>][monitor]" class="form-check-input mt-2 me-2" <?= is_checked($metrics['monitor'], 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1" name="services[services][<?= $i ?>][desc]" id="services[services][<?= $i ?>][desc]" value="<?= encode_form_val($metrics['desc']) ?>">
                            </div>
                        </div>
                        <div class="form-check col-sm-4 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm ps-1" name="services[services][<?= $i ?>][name]" id="services[services][<?= $i ?>][name]" value="<?= encode_form_val($metrics['name']) ?>">
<?php
        if (empty($hosts)) {
?>
                                <div class="input-group-text">
                                    <span style="cursor: pointer;" class="service-selector" data-id="<?= $i ?>">
                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select services from currently running services list") ?>">list_alt</i>
                                    </span>
                                </div>
<?php
        }
?>
                            </div>
                        </div>
                        <div class="form-check col-sm-auto ms-4 mt-0 pt-1">
                            <input type="radio" value="running" name="services[services][<?= $i ?>][state]" id="services[services][<?= $i ?>][state]" class="form-check-input" <?= is_checked($metrics['state'], 'running') ?>>
                            <label class="form-check-label"><?= _("Running") ?></label>
                        </div>
                        <div class="form-check col-sm-auto ms-3 mt-0 pt-1">
                            <input type="radio" value="stopped" name="services[services][<?= $i ?>][state]" id="services[services][<?= $i ?>][state]" class="form-check-input" <?= is_checked($metrics['state'], 'stopped') ?>>
                            <label class="form-check-label"><?= _("Stopped") ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- services-list -->

<?php
    // Create a list of services for the JS
    $service_list = '';
    ksort($root['services']);

    foreach ($root['services'] as $service => $status) {
        $service_list .= '<option value="'.$service.'" data-status="'.$status.'">'.$service.' ('.$status.')</option>';
    }

    // Create a list of processes for the JS
    $processes_list = '';
    ksort($root['processes']);

    foreach ($root['processes'] as $process => $amount) {
        $processes_list .= '<option value="'.$process.'" data-amount="'.$amount.'">'.$process.' ('.$amount.' '._('running').')</option>';
    }

    // Create a list of plugins for the JS
    $plugin_list = '';

    if (!empty($root['plugins'])) {
        $plugin_list .= '<select id="selected-plugin" class="form-control">';

        foreach ($root['plugins'] as $plugin) {
            $plugin_list .= '<option value="' . $plugin . '">' . $plugin . '</option>';
        }

        $plugin_list .= '</select>';
    } else {
        $plugin_list .= '<div class="well">'._('No plugins found on the agent system').'</div>';
    }
?>
        <!--                            -->
        <!-- Processes                  -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Processes') ?></h2>
        <p><?= _("Specify which processes should be running and how many of them there should be.") ?></p>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2">
                    <div class="col-sm-4">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Process Description') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Process Name') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Thresholds (Process count)') ?> <?= xi6_info_tooltip(_('If a value should be warning or critical when it is 0, you can use the threshold 1: which will trigger a warning or critical when the value is outside 1 to ∞.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="process-list">
<?php
    foreach ($services['process'] as $i => $metrics) {
?>
            <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2 deselect" name="services[process][<?= $i ?>][monitor]" id="services[process][<?= $i ?>][monitor]" <?= is_checked($metrics['monitor'], 'on') ?>>
                                <input type="text" class="form-control form-control-sm rounded-end ps-1" name="services[process][<?= $i ?>][desc]" id="services[process][<?= $i ?>][desc]" value="<?= encode_form_val($metrics['desc']) ?>">
                                <i id="services_process_<?= $i ?>_desc_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm monitor" name="services[process][<?= $i ?>][name]" id="services[process][<?= $i ?>][name]" value="<?= encode_form_val($metrics['name']) ?>">
<?php
        if (empty($hosts)) {
?>
                                <div class="input-group-text rounded-end">
                                    <span class="process-selector" data-id="<?= $i ?>">
                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select process from currently running process list") ?>">list_alt</i>
                                    </span>
                                </div>
<?php
        }
?>
                                <i id="services_process_<?= $i ?>_display_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[process][<?= $i ?>][warning]" id="services[process][<?= $i ?>][warning]" value="<?= encode_form_val($metrics['warning']) ?>">
                                <i id="services_process_<?= $i ?>_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" class="form-control form-control-sm rounded-end monitor" name="services[process][<?= $i ?>][critical]" id="services[process][<?= $i ?>][critical]" value="<?= encode_form_val($metrics['critical']) ?>">
                                <i id="services_process_<?= $i ?>_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- process-list -->

        <!--                            -->
        <!-- Plugins                    -->
        <!--                            -->
        <h2 class="mt-4"><?= _('Plugins') ?></h2>
        <p><?= _("If you have provided plugins on the client that you would like NCPA to run, specify them and the arguments to be passed here.") ?></p>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2">
                    <div class="col-sm-4">
                        <label class="form-label bold mb-0 ms-3 ps-1"><?= _('Service Description') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Plugin Name') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Plugin Arguments') ?> <?= xi6_info_tooltip(_("Write out all your arguments as they would be passed via the command line. Example: -w 10 -c 20 --search='error'")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div id="plugin-list">
<?php
    foreach ($services['plugins'] as $i => $metrics) {
?>
            <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[plugins][<?= $i ?>][monitor]" id="services[plugins][<?= $i ?>][monitor]" <?= is_checked($metrics['monitor'], 'on') ?>>
                                <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[plugins][<?= $i ?>][desc]" id="services[plugins][<?= $i ?>][desc]" value="<?= encode_form_val($metrics['desc']) ?>">
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm monitor" name="services[plugins][<?= $i ?>][name]" id="services[plugins][<?= $i ?>][name]" value="<?= encode_form_val($metrics['name']) ?>">
<?php
        if (empty($hosts)) {
?>
                                <div class="input-group-text rounded-end">
                                    <span class="plugin-selector" data-id="<?= $i ?>">
                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select a plugin from the list") ?>">list_alt</i>
                                    </span>
                                </div>
<?php
        }
?>
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm rounded monitor" name="services[plugins][<?= $i ?>][args]" id="services[plugins][<?= $i ?>][args]" value="<?= encode_form_val($metrics['args']) ?>">
                                <i id="services_plugins_<?= $i ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- plugin-list -->

    </div> <!-- container -->

    <script type="text/javascript">
        var processnum = <?= isset($services['process']) ? (count($services['process']) - 1) : 0 ?>;
        var servicenum = <?= isset($services['services']) ? (count($services['services']) - 1) : 0 ?>;
        var pluginnum = <?= isset($services['plugins']) ? (count($services['plugins']) - 1) : 0 ?>;
        var counternum = <?= isset($services['counters']) ? (count($services['counters']) - 1) : 0 ?>;
        var inum = <?= isset($services['interface']) ? (count($services['interface']) - 1) : 0 ?>;
        var dnum = <?= isset($services['disk']) ? (count($services['disk']) - 1) : 0 ?>;

        var IF_SHOW = 0;

        $(document).ready(function() {

            // Network Interface && empty($hosts)
            $(".show-hidden-interfaces").click(function() {
                if (!IF_SHOW) {
                    IF_SHOW = 1;

                    $(this).html("<?= _('Hide unselected interfaces') ?>");
                    $(".interface").removeClass("visually-hidden");

                } else {
                    IF_SHOW = 0;

                    $(this).html("<?= _('Show all interfaces') ?>");

                    $(".interface").each(function() {
                        if (!$(this).find("input[type=checkbox]").is(":checked")) {
                            $(this).addClass("visually-hidden");
                        }
                    });
                }
            });

            // Only used with multi-hosts
            $("#add-disk").click(function() {
                dnum++;

                row = "".concat(
'        <div class="row">',
'            <div class="col-sm-8">',
'                <fieldset class="row g-2 mb-1 wz-fieldset">',
'                    <div class="form-check col-sm-3 mt-0 pt-0">',
'                        <div class="input-group input-group-sm">',
'                            <input type="checkbox" id="d'+dnum+'" class="form-check-input mt-2 me-2" name="services[disk]['+dnum+'][monitor]">',
'                            <input type="hidden" name="services[disk]['+dnum+'][title]" value="">',
'                            <input type="text" class="form-control form-control-sm ps-1 rounded" name="services[disk]['+dnum+'][name]" id="services[disk]['+dnum+'][name]" value="" <?= $disabled ?>>',
'                            <input type="hidden" name="services[disk]['+dnum+'][name]" value="">',
'                        </div>',
'                    </div>');
<?php
        if (array_key_exists($title, $root['disk']['logical']) && is_array($root['disk']['logical'][$title]) && array_key_exists('total', $root['disk']['logical'][$title])) {
?>
                row = row.concat(
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <input type="text" name="services[disk]['+dnum+'][warning]" id="services[disk]['+dnum+'][warning]" value="" class="form-control form-control-sm monitor" readonly>',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <span class="me-2"><?= xi6_info_tooltip(encode_form_val($disk_total)) ?></span>',
'                            <i id="services_disk_'+dnum+'_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>');
<?php
        }
?>
                row = row.concat(
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <span class="input-group-text">',
'                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>',
'                            </span>',
'                            <input type="text" name="services[disk]['+dnum+'][warning]" id="services[disk]['+dnum+'][warning]" value="" class="form-control form-control-sm monitor">',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <i id="services_disk_'+dnum+'_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>',
'                    <div class="col-sm-3 mt-0">',
'                        <div class="input-group input-group-sm">',
'                            <span class="input-group-text">',
'                                <i title="<?=_('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 tt-bind">error</i>',
'                            </span>',
'                            <input type="text" name="services[disk]['+dnum+'][critical]" id="services[disk]['+dnum+'][critical]" value="" class="form-control form-control-sm monitor">',
'                            <span class="input-group-text rounded-end">%</span>',
'                            <i id="services_disk_'+dnum+'_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                        </div>',
'                    </div>',
'                </fieldset>',
'            </div>',
'        </div>');

                $("#disk-list").append(row);
            });

            // Only used with multi-hosts
            $("#add-interface").click(function() {
                inum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" name="services[services]['+inum+'][monitor]" id="services[services]['+inum+'][monitor]" class="form-check-input mt-2 me-2">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+inum+'][desc]" id="services[services]['+inum+'][desc]" value="">',
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+inum+'][name]" id="services[services]['+inum+'][name]" value="">');
<?php
        if (empty($hosts)) {
?>
                row = row.concat(
'                                <div class="input-group-text">',
'                                    <span style="cursor: pointer;" class="service-selector" data-id="'+inum+'">',
'                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select services from currently running services list") ?>">list_alt</i>',
'                                    </span>',
'                                </div>');
<?php
        }
?>
                row = row.concat(
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-4 mt-0 pt-1">',
'                            <input type="radio" value="running" name="services[services]['+inum+'][state]" id="services[services]['+inum+'][state]" class="form-check-input" checked>',
'                            <label class="form-check-label"><?= _("Running") ?></label>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-3 mt-0 pt-1">',
'                            <input type="radio" value="stopped" name="services[services]['+inum+'][state]" id="services[services]['+inum+'][state]" class="form-check-input">',
'                            <label class="form-check-label"><?= _("Stopped") ?></label>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#interfaces-list").append(row);
            });

            $("#add-new-process").click(function() {
                addNewProcess();
            })
            function addNewProcess() {
                processnum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" class="form-check-input mt-2 me-2 deselect" name="services[process]['+processnum+'][monitor]" id="services[process]['+processnum+'][monitor]">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[process]['+processnum+'][desc]" id="services[process]['+processnum+'][desc]" value="">',
'                                <i id="services_process_'+processnum+'_desc_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-4 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[process]['+processnum+'][name]" id="services[process]['+processnum+'][name]" value="">');
<?php
        if (empty($hosts)) {
?>
                row = row.concat(
'                                <div class="input-group-text">',
'                                    <span class="process-selector" data-id="'+processnum+'">',
'                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select process from currently running process list") ?>">list_alt</i>',
'                                    </span>',
'                                </div>');
<?php
        }
?>
                row = row.concat(
'                                <i id="services_process_'+processnum+'_display_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[process]['+processnum+'][warning]" id="services[process]['+processnum+'][warning]" value="">',
'                                <i id="services_process_'+processnum+'_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 tt-bind">error</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[process]['+processnum+'][critical]" id="services[process]['+processnum+'][critical]" value="">',
'                                <i id="services_process_'+processnum+'_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#process-list").append(row);
            };

            $("#add-new-service").click(function() {
                addNewService();
            })
            function addNewService() {
                servicenum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" name="services[services]['+servicenum+'][monitor]" id="services[services]['+servicenum+'][monitor]" class="form-check-input mt-2 me-2">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+servicenum+'][desc]" id="services[services]['+servicenum+'][desc]" value="">',
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[services]['+servicenum+'][name]" id="services[services]['+servicenum+'][name]" value="">');
<?php
        if (empty($hosts)) {
?>
                row = row.concat(
'                                <div class="input-group-text">',
'                                    <span style="cursor: pointer;" class="service-selector" data-id="'+servicenum+'">',
'                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select services from currently running services list") ?>">list_alt</i>',
'                                    </span>',
'                                </div>');
<?php
        }
?>
                row = row.concat(
'                            </div>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-4 mt-0 pt-1">',
'                            <input type="radio" value="running" name="services[services]['+servicenum+'][state]" id="services[services]['+servicenum+'][state]" class="form-check-input" checked>',
'                            <label class="form-check-label"><?= _("Running") ?></label>',
'                        </div>',
'                        <div class="form-check col-sm-auto ms-3 mt-0 pt-1">',
'                            <input type="radio" value="stopped" name="services[services]['+servicenum+'][state]" id="services[services]['+servicenum+'][state]" class="form-check-input">',
'                            <label class="form-check-label"><?= _("Stopped") ?></label>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#services-list").append(row);
            };

            $("#add-new-counter").click(function() {
                addNewCounter();
            })
            function addNewCounter() {
                counternum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-3 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[counters]['+counternum+'][monitor]" id="services[counters]['+counternum+'][monitor]">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[counters]['+counternum+'][desc]" id="services[counters]['+counternum+'][desc]" value="">',
'                                <i id="services_counters_'+counternum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-4 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][name]" id="services[counters]['+counternum+'][name]" value="">',
'                                <i id="services_counters_'+counternum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-1 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][sleep]" id="services[counters]['+counternum+'][sleep]" value="">',
'                                <i id="services_counters_'+counternum+'_sleep_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][warning]" id="services[counters]['+counternum+'][warning]" value="">',
'                                <i id="services_counters_'+counternum+'_warning_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-2 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <span class="input-group-text">',
'                                    <i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 tt-bind">error</i>',
'                                </span>',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[counters]['+counternum+'][critical]" id="services[counters]['+counternum+'][critical]" value="">',
'                                <i id="services_counters_'+counternum+'_critical_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#counter-list").append(row);

            };

            $("#add-new-plugin").click(function() {
                addNewPlugin();
            })
            function addNewPlugin() {
            pluginnum++;

                row = "".concat(
'            <div class="row">',
'                <div class="col-sm-10">',
'                    <fieldset class="row g-2 mb-1 wz-fieldset">',
'                        <div class="form-check col-sm-4 mt-0 pt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[plugins]['+pluginnum+'][monitor]" id="services[plugins]['+pluginnum+'][monitor]">',
'                                <input type="text" class="form-control form-control-sm ps-1" name="services[plugins]['+pluginnum+'][desc]" id="services[plugins]['+pluginnum+'][desc]" value="">',
'                                <i id="services_plugins_'+pluginnum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-4 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[plugins]['+pluginnum+'][name]" id="services[plugins]['+pluginnum+'][name]" value="">');
<?php
        if (empty($hosts)) {
?>
                row = row.concat(
'                                <div class="input-group-text">',
'                                    <span class="plugin-selector" data-id="'+pluginnum+'">',
'                                        <i class="material-symbols-outlined md-16 md-400 md-action md-middle tt-bind" title="<?= _("Select a plugin from the list") ?>">list_alt</i>',
'                                    </span>',
'                                </div>');
<?php
        }
?>
                row = row.concat(
'                                <i id="services_plugins_'+pluginnum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                        <div class="col-sm-4 mt-0">',
'                            <div class="input-group input-group-sm">',
'                                <input type="text" class="form-control form-control-sm monitor" name="services[plugins]['+pluginnum+'][args]" id="services[plugins]['+pluginnum+'][args]" value="">',
'                                <i id="services_plugins_'+pluginnum+'_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>',
'                            </div>',
'                        </div>',
'                    </fieldset>',
'                </div>',
'            </div>');

                $("#plugin-list").append(row);
            };

            $("#process-list").on("click", ".process-selector", function() {
                var process_id = $(this).data("id");
                var content = '<div><h2><?= _("Processes showing on the NCPA Client") ?></h2><p>'+"<?= _("Select a process and the amount of the process currently running is next to the process name.") ?>"+'</p><div><select id="selected-process" class="form-control"><?= $processes_list ?></select></div><div style="margin-top: 6px;"><button data-processid="'+process_id+'" class="btn btn-sm btn-primary" id="add-selected-process">'+"<?= _("Select this Process") ?>"+'</button></div></div>';

                $("#child_popup_container").width(450);
                $("#child_popup_layer").width(480);
                $("#child_popup_layer").css("position", "fixed");
                set_child_popup_content(content);
                display_child_popup();
            });

            $("#services-list").on("click", ".service-selector", function() {
                var service_id = $(this).data("id");
                var content = '<div><h2><?= _("Services Available on the NCPA Client") ?></h2><p>'+"<?= _("Select a service that is either running or stopped from the NCPA client host to atuomatically fill in the service name and the expected state.") ?>"+'</p><div><select id="selected-service" class="form-control"><?= $service_list ?></select></div><div style="margin-top: 6px;"><button data-serviceid="'+service_id+'" class="btn btn-sm btn-primary" id="add-selected-service">'+"<?= _("Select this Service") ?>"+'</button></div></div>';

                $("#child_popup_container").width(450);
                $("#child_popup_layer").width(480);
                $("#child_popup_layer").css("position", "fixed");
                set_child_popup_content(content);
                display_child_popup();
            });

            $("#plugin-list").on("click", ".plugin-selector", function() {
                var plugin_id = $(this).data("id");
                var content = '<div><h2>'+"<?= _("Plugins Available on the NCPA Client") ?>"+'</h2><p>'+"<?= _("Select a plugin to use from the list of available plugins.") ?>"+'</p><div><?= $plugin_list ?></div><div style="margin-top: 6px;"><button data-pluginid="'+plugin_id+'" class="btn btn-sm btn-primary" id="add-selected-plugin">'+"<?= _("Select this Plugin") ?>"+'</button></div></div>';

                $("#child_popup_container").width(450);
                $("#child_popup_layer").width(480);
                $("#child_popup_layer").css("position", "fixed");
                set_child_popup_content(content);
                display_child_popup();
            });

            $("#child_popup_container").on("click", "#add-selected-service", function() {
                var service_id = $(this).data("serviceid");
                var selected_service = $("#selected-service option:selected").val();
                var selected_state = $("#selected-service option:selected").data("status");

                $('input[name="services[services]['+service_id+'][desc]"]').val(selected_service + " Service Status");
                $('input[name="services[services]['+service_id+'][name]"]').val(selected_service);
                $('input[name="services[services]['+service_id+'][monitor]"]').prop("checked", true);
                $('input[name="services[services]['+service_id+'][state]"][value="'+selected_state+'"]').prop("checked", true);
                close_child_popup();
                addNewService();
            });

            $("#child_popup_container").on("click", "#add-selected-process", function() {
                var process_id = $(this).data("processid");
                var selected_process = $("#selected-process option:selected").val();
                var selected_amount = $("#selected-process option:selected").data("amount");
                var warning = Math.ceil(selected_amount*1.5);
                var critical = Math.ceil(selected_amount*2);

                if (critical <= warning) {
                    critical++;
                }

                $('input[name="services[process]['+process_id+'][name]"]').val(selected_process);
                $('input[name="services[process]['+process_id+'][desc]"]').val(selected_process.replace(".exe", ""));
                $('input[name="services[process]['+process_id+'][warning]"]').val(warning);
                $('input[name="services[process]['+process_id+'][critical]"]').val(critical);
                $('input[name="services[process]['+process_id+'][monitor]"]').prop("checked", true);
                close_child_popup();
                addNewProcess();
            });

            $("#child_popup_container").on("click", "#add-selected-plugin", function() {
                var plugin_id = $(this).data("pluginid");
                var selected_plugin = $("#selected-plugin option:selected").val();

                $('input[name="services[plugins]['+plugin_id+'][desc]"]').val("Plugin "+selected_plugin);
                $('input[name="services[plugins]['+plugin_id+'][name]"]').val(selected_plugin);
                $('input[name="services[plugins]['+plugin_id+'][monitor]"]').prop("checked", true);
                $('input[name="services[plugins]['+plugin_id+'][args]"]').focus();
                close_child_popup();
                addNewPlugin();
            });

        });
    </script>

    <script src="../includes/configwizards/ncpa/ncpa.inc.js"></script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
