    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Server Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Server Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this server or device')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Common Server Ports') ?></h2>
        <p><?= _('Specify which ports you would like to monitor on the server or device') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ftp" class="form-check-input" name="services[common][ftp]"  <?= is_checked($services['common']['ftp'], "on") ?> >
                        <label for="ftp" class="form-check-label bold"><?= _('FTP') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="http" class="form-check-input" name="services[common][http]"  <?= is_checked($services['common']['http'], "on") ?> >
                        <label for="http" class="form-check-label bold"><?= _('HTTP') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="imap" class="form-check-input" name="services[common][imap]"  <?= is_checked($services['common']['imap'], "on") ?> >
                        <label for="imap" class="form-check-label bold"><?= _('IMAP') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="pop" class="form-check-input" name="services[common][pop]"  <?= is_checked($services['common']['pop'], "on") ?> >
                        <label for="pop" class="form-check-label bold"><?= _('POP') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="smtp" class="form-check-input" name="services[common][smtp]"  <?= is_checked($services['common']['smtp'], "on") ?> >
                        <label for="smtp" class="form-check-label bold"><?= _('SMTP') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ssh" class="form-check-input" name="services[common][ssh]"  <?= is_checked($services['common']['ssh'], "on") ?> >
                        <label for="ssh" class="form-check-label bold"><?= _('SSH') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Custom Server Ports') ?></h2>
        <p><?= _('Specify any custom TCP/UDP ports you would like to monitor on the server or device') ?></p>

        <div class="adddeleterow">
             <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end col-sm-1">
                            <div class="input-group input-group-sm">
                                <label class="form-check-label bold"><?= _('Port #') ?></label>
                            </div>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold"><?= _('Port Type') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('Port/Application Name') ?> <?= xi6_info_tooltip(_('Provide a name for this monitoring service.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('Send String') ?> <?= xi6_info_tooltip(_('"Specify the data string to send to the port to test its response. This is typically a protocol-specific query or command.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold text-center"><?= _('Expect String') ?> <?= xi6_info_tooltip(_('"Enter the response string expected from the port when the send string is transmitted. This will verify the service is functioning correctly.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($services["custom"]); $x++) {
?>
            <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-1 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" name="services[custom][<?= $x ?>][port]" id="custom_port_[<?= $x ?>]" value="<?= encode_form_val($services['custom'][$x]['port']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="custom_port_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <select name="services[custom][<?= $x ?>][type]" id="custom_type_[<?= $x ?>]" class="form-control form-control-sm form-select form-select-sm">
                                <option value="tcp" <?= is_selected($services["custom"][$x]["type"], "tcp") ?>><?= _('TCP') ?></option>
                                <option value="udp" <?= is_selected($services["custom"][$x]["type"], "udp") ?>><?= _('UDP') ?></option>
                            </select>
                            <i id="custom_type_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <input type="text" name="services[custom][<?= $x ?>][name]" id="custom_name_[<?= $x ?>]" value="<?= encode_form_val($services['custom'][$x]['name']) ?>" class="form-control form-control-sm">
                            <i id="custom_name_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <input type="text" name="services[custom][<?= $x ?>][send]" id="custom_send[<?= $x ?>]" value="<?= encode_form_val($services['custom'][$x]['send']) ?>" class="form-control form-control-sm">
                            <i id="custom_send_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm mt-0">
                            <input type="text" name="services[custom][<?= $x ?>][expect]" id="custom_expect_[<?= $x ?>]" value="<?= encode_form_val($services['custom'][$x]['expect']) ?>" class="form-control form-control-sm">
                            <i id="custom_expect_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- adddeleterow -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
