    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2><?= _('Nagiostats') ?></h2>
        <p><?= _('Nagiostats is a binary included with Nagios that is used to monitor internal performance. This wizard allows users to select from a list of options to analyze local Nagios server performance, and produce graphs and reports over time. Not all checks are relevant for every install, so select checks based on your monitoring environment. See the Nagios Core Documentation on ') ?><a href="http://nagios.sourceforge.net/docs/3_0/tuning.html" title="<?= _('Performance Tuning') ?>" target="_blank"><?= _('Tuning Nagios Performance') ?></a>.</p>
        <div class="alert alert-secondary">
            <strong><?= _('Important Notes') ?>:<br></strong>
            <ul class="list-group list-group-sm list-group-numbered">
                <li class="list-group-item">
                    <?= _('Selecting 1min checks will create a check that runs every 1min, 15min checks run every 15min') ?>.
                </li>
                <li class="list-group-item text-danger">
                    <?= _('Enter all warning and critical thresholds as integers') ?>.
                </li>
                <li class="list-group-item">
                    <?= _('All warning and critical thresholds are optional') ?>.
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1">
                    <div class="col-sm-4">
                        <input id="selectAll" class="form-check-input" type="checkbox">&nbsp<label class="form-check-label" id="selectAllLabel" for="selectAll"><?= _('Check All Services') ?></label>
                    </div>
                    <div class="col-sm">
                        <input id="selectNtf" class="form-check-input" type="checkbox">&nbsp<label class="form-check-label" id="selectNtfLabel" for="selectNtf"><?= _('Check All Notifications') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1">
                    <div class="form-check col-sm-4">
                        <label class="form-check-label bold"><?= _('Check Name') ?></label>
                    </div>
                    <div class="col-sm-2 text-center">
                        <label class="form-check-label bold"><?= _('Notifications') ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-check-label bold"><?= _('Warning') ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-check-label bold"><?= _('Critical') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc deselect" id="ahc1" name="svc[ahc1]" <?= @val("ahc1", "svc") ?>>
                        <i id="svc_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="ahc1" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 1min
                        </label>
                        <i id="svc_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[ahc1]" name="ntf[ahc1]" <?= @val("ahc1", "ntf") ?>>
                        <i id="ntf_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[ahc1]" name="warn[ahc1]" value="<?= @val("ahc1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[ahc1]" name="crit[ahc1]" value="<?= @val("ahc1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="ahc5" name="svc[ahc5]" <?= @val("ahc5", "svc") ?>>
                        <i id="svc_ahc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="ahc5" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 5min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[ahc5]" name="ntf[ahc5]" <?= @val("ahc5", "ntf") ?>>
                        <i id="ntf_ahc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[ahc5]" name="warn[ahc5]" value="<?= @val("ahc5", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_ahc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[ahc5]" name="crit[ahc5]" value="<?= @val("ahc5", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_ahc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="ahc15" name="svc[ahc15]" <?= @val("ahc15", "svc") ?>>
                        <i id="svc_ahc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="ahc15" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 15min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[ahc15]" name="ntf[ahc15]" <?= @val("ahc15", "ntf") ?>>
                        <i id="ntf_ahc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[ahc15]" name="warn[ahc15]" value="<?= @val("ahc15", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_ahc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[ahc15]" name="crit[ahc15]" value="<?= @val("ahc15", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_ahc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="asc1" name="svc[asc1]" <?= @val("asc1", "svc") ?>>
                        <i id="warn_asc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="asc1" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 1min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[asc1]" name="ntf[asc1]" <?= @val("asc1", "ntf") ?>>
                        <i id="warn_asc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[asc1]" name="warn[asc1]" value="<?= @val("asc1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_asc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[asc1]" name="crit[asc1]" value="<?= @val("asc1", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_asc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="asc5" name="svc[asc5]" <?= @val("asc5", "svc") ?>>
                        <i id="warn_asc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="asc5" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 5min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[asc5]" name="ntf[asc5]" <?= @val("asc5", "ntf") ?>>
                        <i id="warn_asc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[asc5]" name="warn[asc5]" value="<?= @val("asc5", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_asc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[asc5]" name="crit[asc5]" value="<?= @val("asc5", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_asc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="asc15" name="svc[asc15]" <?= @val("asc15", "svc") ?>>
                        <i id="warn_asc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="asc15" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/activechecks.html" title="Active Checks Explained" target="_blank"><?= _('Active') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 15min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[asc15]" name="ntf[asc15]" <?= @val("asc15", "ntf") ?>>
                        <i id="warn_asc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[asc15]" name="warn[asc15]" value="<?= @val("asc15", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_asc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[asc15]" name="crit[asc15]" value="<?= @val("asc15", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_asc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="phc1" name="svc[phc1]" <?= @val("phc1", "svc") ?>>
                        <i id="warn_phc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="phc1" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 1min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[phc1]" name="ntf[phc1]" <?= @val("phc1", "ntf") ?>>
                        <i id="warn_phc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[phc1]" name="warn[phc1]" value="<?= @val("phc1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_phc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[phc1]" name="crit[phc1]" value="<?= @val("phc1", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_phc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="phc5" name="svc[phc5]" <?= @val("phc5", "svc") ?>>
                        <i id="warn_phc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="phc5" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 5min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[phc5]" name="ntf[phc5]" <?= @val("phc5", "ntf") ?>>
                        <i id="warn_phc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[phc5]" name="warn[phc5]" value="<?= @val("phc5", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_phc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[phc5]" name="crit[phc5]" value="<?= @val("phc5", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_phc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="phc15" name="svc[phc15]" <?= @val("phc15", "svc") ?>>
                        <i id="warn_phc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="phc15" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/hostchecks.html" target="_blank" title="Host Checks Explained"><?= _('Host Checks') ?></a> 15min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[phc15]" name="ntf[phc15]" <?= @val("phc15", "ntf") ?>>
                        <i id="warn_phc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[phc15]" name="warn[phc15]" value="<?= @val("phc15", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_phc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[phc15]" name="crit[phc15]" value="<?= @val("phc15", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_phc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="psc1" name="svc[psc1]" <?= @val("psc1", "svc") ?>>
                        <i id="warn_psc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="psc1" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 1min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[psc1]" name="ntf[psc1]" <?= @val("psc1", "ntf") ?>>
                        <i id="warn_psc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[psc1]" name="warn[psc1]" value="<?= @val("psc1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_psc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[psc1]" name="crit[psc1]" value="<?= @val("psc1", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_psc1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="psc5" name="svc[psc5]" <?= @val("psc5", "svc") ?>>
                        <i id="warn_psc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="psc5" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 5min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[psc5]" name="ntf[psc5]" <?= @val("psc5", "ntf") ?>>
                        <i id="warn_psc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[psc5]" name="warn[psc5]" value="<?= @val("psc5", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_psc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[psc5]" name="crit[psc5]" value="<?= @val("psc5", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_psc5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="psc15" name="svc[psc15]" <?= @val("psc15", "svc") ?>>
                        <i id="warn_psc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="psc15" class="form-check-label bold">
                            <a href="http://nagios.sourceforge.net/docs/3_0/passivechecks.html" title="Passive Checks Explained" target="_blank"><?= _('Passive') ?></a>
                            <a href="http://nagios.sourceforge.net/docs/3_0/servicechecks.html" title="Service Checks Explained" target="_blank"><?= _('Service Checks') ?></a> 15min
                        </label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[psc15]" name="ntf[psc15]" <?= @val("psc15", "ntf") ?>>
                        <i id="warn_psc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[psc15]" name="warn[psc15]" value="<?= @val("psc15", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_psc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[psc15]" name="crit[psc15]" value="<?= @val("psc15", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_psc15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="hxt" name="svc[hxt]" <?= @val("hxt", "svc") ?>>
                        <i id="warn_hxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="hxt" class="form-check-label bold"><?= _('Average Host') ?> <a href="javascript:void(0)" title="<?= $execTime ?>"><?= _('Execution Time') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[hxt]" name="ntf[hxt]" <?= @val("hxt", "ntf") ?>>
                        <i id="warn_hxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[hxt]" name="warn[hxt]" value="<?= @val("hxt", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_hxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[hxt]" name="crit[hxt]" value="<?= @val("hxt", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_hxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="sxt" name="svc[sxt]" <?= @val("sxt", "svc") ?>>
                        <i id="warn_sxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="sxt" class="form-check-label bold"><?= _('Average Service') ?> <a href="javascript:void(0)" title="<?= $execTime ?>"><?= _('Execution Time') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[sxt]" name="ntf[sxt]" <?= @val("sxt", "ntf") ?>>
                        <i id="warn_sxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[sxt]" name="warn[sxt]" value="<?= @val("sxt", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_sxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[sxt]" name="crit[sxt]" value="<?= @val("sxt", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_sxt_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="ahlat" name="svc[ahlat]" <?= @val("ahlat", "svc") ?>>
                        <i id="warn_ahlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="ahlat" class="form-check-label bold"><?= _('Average Active Host') ?> <a href="javascript:void(0)" title="<?= $latency ?>"><?= _('Latency') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[ahlat]" name="ntf[ahlat]" <?= @val("ahlat", "ntf") ?>>
                        <i id="warn_ahlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[ahlat]" name="warn[ahlat]" value="<?= @val("ahlat", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_ahlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[ahlat]" name="crit[ahlat]" value="<?= @val("ahlat", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_ahlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="aslat" name="svc[aslat]" <?= @val("aslat", "svc") ?>>
                        <i id="warn_aslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="aslat" class="form-check-label bold"><?= _('Average Active Service') ?> <a href="javascript:void(0)" title="<?= $latency ?>"><?= _('Latency') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[aslat]" name="ntf[aslat]" <?= @val("aslat", "ntf") ?>>
                        <i id="warn_aslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[aslat]" name="warn[aslat]" value="<?= @val("aslat", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_aslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[aslat]" name="crit[aslat]" value="<?= @val("aslat", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_aslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="phlat" name="svc[phlat]" <?= @val("phlat", "svc") ?>>
                        <i id="warn_phlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="phlat" class="form-check-label bold"><?= _('Average Passive Host') ?> <a href="javascript:void(0)" title="<?= $latency ?>"><?= _('Latency') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[phlat]" name="ntf[phlat]" <?= @val("phlat", "ntf") ?>>
                        <i id="warn_phlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[phlat]" name="warn[phlat]" value="<?= @val("phlat", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_phlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[phlat]" name="crit[phlat]" value="<?= @val("phlat", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_phlat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="pslat" name="svc[pslat]" <?= @val("pslat", "svc") ?>>
                        <i id="warn_pslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="pslat" class="form-check-label bold"><?= _('Average Passive Service') ?> <a href="javascript:void(0)" title="<?= $latency ?>"><?= _('Latency') ?></a></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[pslat]" name="ntf[pslat]" <?= @val("pslat", "ntf") ?>>
                        <i id="warn_pslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[pslat]" name="warn[pslat]" value="<?= @val("pslat", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="warn_pslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[pslat]" name="crit[pslat]" value="<?= @val("pslat", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <span class="input-group-text">s</span>
                            <i id="crit_pslat_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="eco1" name="svc[eco1]" <?= @val("eco1", "svc") ?>>
                        <i id="warn_eco1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="eco1" class="form-check-label bold"><a href="http://nagios.sourceforge.net/docs/3_0/configmain.html#external_command_buffer_slots" title="External Commands Explained" target="_blank"><?= _('External Commands') ?></a> <?= _('Used') ?> 1min</label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[eco1]" name="ntf[eco1]" <?= @val("eco1", "ntf") ?>>
                        <i id="warn_eco1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[eco1]" name="warn[eco1]" value="<?= @val("eco1", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_eco1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[eco1]" name="crit[eco1]" value="<?= @val("eco1", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_eco1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="eco5" name="svc[eco5]" <?= @val("eco5", "svc") ?>>
                        <i id="svc_eco5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="eco5" class="form-check-label bold"><a href="http://nagios.sourceforge.net/docs/3_0/configmain.html#external_command_buffer_slots" title="External Commands Explained" target="_blank"><?= _('External Commands') ?></a> <?= _('Used') ?> 5min</label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[eco5]" name="ntf[eco5]" <?= @val("eco5", "ntf") ?>>
                        <i id="ntf_eco5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[eco5]" name="warn[eco5]" value="<?= @val("eco5", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_eco5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[eco5]" name="crit[eco5]" value="<?= @val("eco5", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_eco5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="eco15" name="svc[eco15]" <?= @val("eco15", "svc") ?>>
                        <i id="svc_eco15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="eco15" class="form-check-label bold"><a href="http://nagios.sourceforge.net/docs/3_0/configmain.html#external_command_buffer_slots" title="External Commands Explained" target="_blank"><?= _('External Commands') ?></a> <?= _('Used') ?> 15min</label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[eco15]" name="ntf[eco15]" <?= @val("eco15", "ntf") ?>>
                        <i id="ntf_eco15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[eco15]" name="warn[eco15]" value="<?= @val("eco15", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_eco15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[eco15]" name="crit[eco15]" value="<?= @val("eco15", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_eco15_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="hprob" name="svc[hprob]" <?= @val("hprob", "svc") ?>>
                        <i id="svc_hprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="hprob" class="form-check-label bold"><?= _('Total Host Problems') ?></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[hprob]" name="ntf[hprob]" <?= @val("hprob", "ntf") ?>>
                        <i id="ntf_hprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[hprob]" name="warn[hprob]" value="<?= @val("hprob", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_hprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[hprob]" name="crit[hprob]" value="<?= @val("hprob", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_hprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input rounded svc" id="sprob" name="svc[sprob]" <?= @val("sprob", "svc") ?>>
                        <i id="svc_sprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        <label for="sprob" class="form-check-label bold"><?= _('Total Service Problems') ?></label>
                    </div>
                    <div class="form-check col-sm-2 mt-0 pt-1 d-flex align-items-center flex-column">
                        <input type="checkbox" class="form-check-input rounded ntf" id="ntf[sprob]" name="ntf[sprob]" <?= @val("sprob", "ntf") ?>>
                        <i id="ntf_sprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="warn[sprob]" name="warn[sprob]" value="<?= @val("sprob", "warn") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="warn_sprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="crit[sprob]" name="crit[sprob]" value="<?= @val("sprob", "crit") ?>" class="form-control form-control-sm rounded monitor">
                            <i id="crit_sprob_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            $("#nagiostatInfo").hide();

            var allChecked = false;
            $("#selectAll").click(function () {
                if (allChecked==false) {
                    $('#selectAllLabel').html(_('Uncheck All Services'));
                    $(".svc:checkbox").each(function (){
                        this.checked = "checked";
                    });
                    allChecked=true;

                } else {
                    $('#selectAllLabel').html(_('Check All Services'));
                    $(".svc:checkbox").each(function () {
                        this.checked = "";
                    });
                    allChecked = false;
                }
            });

            var ntfChecked = false;
            $("#selectNtf").click(function () {
                if (ntfChecked==false) {
                    $('#selectNtfLabel').html(_('Uncheck All Notifications'));
                    $(".ntf:checkbox").each(function (){
                        this.checked = "checked";
                    });
                    ntfChecked=true;

                } else {
                    $('#selectNtfLabel').html(_('Check All Nofitications'));
                    $(".ntf:checkbox").each(function () {
                        this.checked = "";
                    });
                    ntfChecked=false;
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
