
function searchInstances( searchString ) {
    $(".instance-wrapper").fadeOut(175);
    
    $(".instance-wrapper").each(function() {
        service_id = $(this).data("service-id");
        ip_address = $(this).data("ip-address");
        region = $(this).data("region");
        
        service_id_result = service_id.indexOf(searchString);
        ip_address_result = ip_address.indexOf(searchString);
        region_result = region.indexOf(searchString);

        if (service_id_result >= 0 || ip_address_result >= 0 || region_result >= 0) {
            $(this).fadeIn(175);
        }

    });
}

var extchart;

$(document).ready(function() {

    $("#instance-search").focus();

    var search;

    // Instance Search
    $("#instance-search").on("keyup", function() {
        clearTimeout(search);
        searchString = $(this).val().toLowerCase();
        search = setTimeout('searchInstances(searchString)', 400);
    });

    $('#enable_custom_host').click(function () {
        if (this.checked) {
            $('#custom_host_name').attr('disabled', false);
        }
        else {
            $('#custom_host_name').attr('disabled', true);
        }
    });


    // Only for use in the onclick below
    var all_other_chevrons = $('.grid .flex-center .config-chevron');

    $("#toggle-all-chevron").parent().parent().on("click", function() {
        if ( $(this).hasClass("expanded") ) {

            $(this).removeClass("expanded");
            $('#toggle-all-chevron').css( { 'transform' : 'rotate(0deg)' });
            all_other_chevrons.each(function() {

                if ($(this).parent().parent().hasClass('expanded')) {
                    $(this).click();
                }
            });
        }
        else {

            $(this).addClass('expanded');
            $('#toggle-all-chevron').css( { 'transform' : 'rotate(180deg)' });
            all_other_chevrons.each(function() {

                if (!$(this).parent().parent().hasClass('expanded')) {
                    $(this).click();
                }
            });
        }
    });

    // Make a best effort to determine the actual height of all the rows we want to show in the table.
    // This will probably break if we ever specify padding/gap in non-pixel units.
    function get_expanded_metrics_grid_height(instanceId, with_graph) {
        let row_height = $('.metrics-grid[data-service-id="' + instanceId + '"] .grid-width-3').first().height();
        // console.log(["row height", row_height]);

        let gap_size = $('.metrics-grid[data-service-id="' + instanceId + '"] .metrics-grid-table').css('gap');
        gap_size = parseInt(gap_size); // "40px" => 40; hopefully the gap isn't ever in rem :)
        if (isNaN(gap_size)) {
            gap_size = 0;
        }
        // console.log(["gap size", gap_size]);

        let padding_size = $('.metrics-grid[data-service-id="' + instanceId + '"] .metrics-grid-table').css('padding-top');
        padding_size = parseInt(padding_size);
        if (isNaN(padding_size)) {
            padding_size = 0;
        }
        // console.log(["padding size", padding_size]);

        let expand_to = 3 * row_height + 2 * gap_size + 2 * padding_size;
        // console.log(["expand to", expand_to]);
        if (with_graph) {
            // Add the space for the graph and gap for the graph's row
            expand_to += gap_size;
            expand_to += $('#highcharts-target-' + instanceId).parent().height();
            // console.log(['bigger', expand_to]);
        }

        return expand_to;
    }

    $(".config-chevron").parent().parent().on("click", function() {
        
        var instanceId = $(this).data("service-id");

        if ( $(this).hasClass("expanded") ) {
            $(this).removeClass("expanded");
            $(this).children().children('.config-chevron').css({ "transform" : "rotate(0deg)" });
            $('.metrics-grid[data-service-id="' + instanceId + '"]').animate({height: "0px"}, 145);
        } else {
            $(this).addClass("expanded");
            $(this).children().children('.config-chevron').css({ "transform" : "rotate(180deg)" });
            // Expand to include 3 rows plus their gaps

            const has_graph = $(this).children().children('.config-chevron').hasClass('bigger');
            const expand_to = get_expanded_metrics_grid_height(instanceId, has_graph);

            $('.metrics-grid[data-service-id="' + instanceId + '"]').animate({height: expand_to}, 145, 'swing', function() {
                // Occasionally, the div doesn't render on the first expansion. This forces a re-render.
                $(this).hide().show(0);
            })
        }

    });

    $('.render-graph').click(function() {

        instanceId = $(this).data('service-id');

        host = $(this).data('host');
        service = $(this).data('service-description');
        track = $(this).data('perfdata-name');

        target = {};
        target[host] = {
            service: service,
            track: track,
            uid: instanceId
        };

        inputs_from_here = $(this).parent().siblings('.flex-v-align').children('div');

        validation_errors = inputs_from_here.children('span.validation-error-text');
        inputs_from_here.children('input').removeClass('validation-error');
        validation_errors.html('');

        method = inputs_from_here.children('select[name*=method]').val();
        period = inputs_from_here.children('input[name*=lookahead]').val();
        if (typeof period === "undefined" || isNaN(parseInt(period))) {
            period = '1';
            inputs_from_here.children('input[name*=lookahead]').val(period);
        }
        period = parseInt(period);

        dataoptions = {}
        dataoptions[host] = {
            method: method,
            period: period
        }

        timeframe_warning = parseFloat(inputs_from_here.children('input[name*=timeframe_warning]').val());
        if (typeof timeframe_warning === "undefined") {
            timeframe_warning = 0;
            inputs_from_here.children('input[name*=timeframe_warning]').val(timeframe_warning);
        }

        timeframe_critical = parseFloat(inputs_from_here.children('input[name*=timeframe_critical]').val());
        if (typeof timeframe_critical === "undefined") {
            timeframe_critical = 0;
            inputs_from_here.children('input[name*=timeframe_critical]').val(timeframe_critical);
        }

        var timeframe_message;
        if (timeframe_warning && period < timeframe_warning / 7.0) {
            timeframe_message = $('#bad-timeframe-lookahead-msg').html();
            inputs_from_here.children('input[name*=timeframe_warning]').addClass('validation-error');
            inputs_from_here.children('input[name*=lookahead]').addClass('validation-error');
            validation_errors.append(timeframe_message);
            return;
        }
        else if (timeframe_critical && period < timeframe_critical / 7.0) {
            timeframe_message = $('#bad-timeframe-lookahead-msg').html();
            inputs_from_here.children('input[name*=timeframe_critical]').addClass('validation-error');
            inputs_from_here.children('input[name*=lookahead]').addClass('validation-error');
            validation_errors.append(timeframe_message);
            return;
        }

        period = period + ' weeks';

        use = []
        inputs_from_here.children('select[name*=threshold]').each(function() {
            use.push($(this).val());
        });
        custom_value_input = inputs_from_here.children('input[name*=custom_value]');
        custom_value = custom_value_input.val();

        if (use.indexOf('custom') >= 0 && isNaN(parseFloat(custom_value))) {
            custom_value_msg = $('#bad-custom-value-msg').html();
            custom_value_input.addClass('validation-error');
            validation_errors.append(custom_value_msg);
            return;
        }

        // This is defined in /includes/components/capacityplanning/includes/capacityreport.js.php
        query = get_extrapolation_query(host, service, track, instanceId);
        target_url = base_url + '/includes/components/capacityplanning/cp-extrap.php';
        $.post(target_url, query, function(data) {
            if (typeof custom_value === 'undefined') {
                custom_value = '';
            }
            if (custom_value !== '') {
                data.custom_value = parseFloat(custom_value);
            }

            data.timeframe_warning = timeframe_warning;
            data.timeframe_critical = timeframe_critical;
            data.selected_thresholds = use;

            const expand_to = get_expanded_metrics_grid_height(instanceId, true);

            $('.metrics-grid[data-service-id="' + instanceId + '"]').animate({height: expand_to}, 145);
            $('.config-chevron[data-service-id="' + instanceId + '"]').addClass('bigger');

            configwizard_make_highcharts(data, host, service, track, instanceId, 1080, 500);
        }, 'json');

    });

    $('.click-me').click();
});


/* Highcharts stuff below this line */

// Retrieved from http://jsfiddle.net/48awM/30/ 12-20-18
// and modified to do some other stuff
function capacity_planning_draggablePlotLine(axis, plotLineId, series) {
    var clickX, clickY;

    if (typeof series === 'undefined') {
        series = false;
    }

    var getPlotLine = function () {
        for (var i = 0; i < axis.plotLinesAndBands.length; i++) {
            if (axis.plotLinesAndBands[i].id === plotLineId) {
                return axis.plotLinesAndBands[i];
            }
        }
    };

    var getSeries = function() {
        if (!series) {
            return false;
        }
        for (var i = 0; i < axis.series.length; i++) {
            if (axis.series[i].name === plotLineId) {
                return axis.series[i];
            }
        }
    }
    
    var getValue = function() {
        var plotLine = getPlotLine();
        var translation = axis.horiz ? plotLine.svgElem.translateX : plotLine.svgElem.translateY;
        var new_value = axis.toValue(translation) - axis.toValue(0) + plotLine.options.value;
        new_value = Math.max(axis.min, Math.min(axis.max, new_value));
        return new_value;
    };

    // Pretend these say const!
    var minWidth = getPlotLine().options.width;
    var maxWidth = minWidth * 2;

    var increase_width = function () {
        getPlotLine().svgElem
            .attr('stroke-width', maxWidth)
            .on('mouseout', decrease_width);
    }

    var decrease_width = function () {
        getPlotLine().svgElem
            .attr('stroke-width', minWidth)
            .on('mouseover', increase_width);
    }

    var drag_start = function (e) {
        $(document).bind({
            'mousemove.line': drag_step,
            'mouseup.line': drag_stop
        });

        var plotLine = getPlotLine();
        clickX = e.pageX - plotLine.svgElem.translateX;
        clickY = e.pageY - plotLine.svgElem.translateY;
        if (plotLine.options.onDragStart) {
            plotLine.options.onDragStart(getValue());
        }
    };

    var drag_step = function (e) {
        var plotLine = getPlotLine();
        // var series = getSeries();
        var new_translation = axis.horiz ? e.pageX - clickX : e.pageY - clickY;
        var new_value = axis.toValue(new_translation) - axis.toValue(0) + plotLine.options.value;
        new_value = Math.max(axis.min, Math.min(axis.max, new_value));
        new_translation = axis.toPixels(new_value + axis.toValue(0) - plotLine.options.value);
        plotLine.svgElem.translate(
            axis.horiz ? new_translation : 0,
            axis.horiz ? 0 : new_translation);

        if (plotLine.options.onDragChange) {
            plotLine.options.onDragChange(new_value);
        }

    };

    // This function runs at first render as well as on event, with slightly different behavior
    var drag_stop = function (first_time) {

        if (typeof first_time === "undefined" || first_time !== true) {
            first_time = false;
        }

        $(document).unbind('.line');

        var plotLine = getPlotLine();
        var series = getSeries();
        var plotLineOptions = plotLine.options;
        //Remove + Re-insert plot line
        //Otherwise it gets messed up when chart is resized
        if (plotLine.svgElem.hasOwnProperty('translateX')) {
            plotLineOptions.value = getValue()
            axis.removePlotLine(plotLineOptions.id);
            axis.addPlotLine(plotLineOptions);

            if (plotLineOptions.onDragFinish) {
                plotLineOptions.onDragFinish(plotLineOptions.value);
            }
        }

        seriesOpts = series.options;
        if (series) {
            series.setData([plotLineOptions.value]);
        }

        getPlotLine().svgElem
            .css({'cursor': 'pointer'})
            .translate(0, 0)
            .on('mousedown', drag_start);

        if (first_time) {
            getPlotLine().svgElem.on('mouseover', increase_width);
        }
        else {
            getPlotLine().svgElem.on('mouseout', decrease_width);
        }

    };
    drag_stop(true);
};

// This is quite fragile, so I'm keeping it in its own function.
function custom_value_selector(uid) {
    // first part should always refer to the selector for renderTo
    return $('#highcharts-target-' + uid).parent().siblings('.flex-v-align').children().children('input[name*=custom_value]');
}

function timeframe_warning_selector(uid) {
    return $('#highcharts-target-' + uid).parent().siblings('.flex-v-align').children().children('input[name*=timeframe_warning]');
}

function timeframe_critical_selector(uid) {
    return $('#highcharts-target-' + uid).parent().siblings('.flex-v-align').children().children('input[name*=timeframe_critical]');
}

function curry_time_to_days_left(fillselector) {
    return function(milliseconds_from_epoch) {
        var val = (milliseconds_from_epoch - Date.now())/86400000;
        fillselector.val(val);
    }
}

function configwizard_make_highcharts_constant_line(name, color, level, draggable, fillselector, fill_fn) {

    if (typeof draggable === "undefined") {
        draggable = false;
    }

    retobj = {
        label: {
            text: name
        },
        id: name,
        color: color,
        width: 3,
        value: level,
    };

    if (draggable) {
        retobj.draggable = true;
        if (typeof fill_fn === "undefined") {
            fill_fn = function(new_value) {
                fillselector.val(new_value);
            }
        }
        else {
            // Return a function similar to the one above
            fill_fn = fill_fn(fillselector);
        }
        retobj.onDragStart = fill_fn;
        retobj.onDragChange = fill_fn;
        retobj.onDragFinish = fill_fn;
    }

    return retobj;
}

function configwizard_make_highcharts_fake_series(name, color, level, start, visible, plotLineOptions) {
    return {
        id: name,
        name: name,
        color: color,
        type: 'line',
        marker: {
            enabled: false
        },
        pointStart: start,
        visible: visible,
        data: [level],
        events: {
            legendItemClick: function(e) {
                if (this.visible) {
                    this.chart.yAxis[0].removePlotLine(name);
                }
                else {
                    this.chart.yAxis[0].addPlotLine(plotLineOptions);
                    if (plotLineOptions.hasOwnProperty('draggable') && plotLineOptions.draggable) {
                        capacity_planning_draggablePlotLine(this.chart.yAxis[0], plotLineOptions.id, this);
                    }
                }
            }
        }
    };
}

function configwizard_make_highcharts(data, host, service, track, uid, width, height) {
    console.log([data, host, service, track, uid, width, height]);
    var title = host + ' - ' + service + ': ' + track;

    var hideoptions = (get_url_parameter('hideoptions') == '1');
    var tracking = !hideoptions;

    var series_data = data.highcharts;

    // Add warning and critical level lines if not hiding options, and we
    // have first and last timepoints and critical or warning level values.
    var start = data.t_start * 1000;
    var step = data.t_step * 1000;
    var stop = data.t_stop * 1000;
    plotLines_yAxis = [];

    var displayCustom = false;
    var displayWarning = false;
    var displayCritical = false;
    if (typeof data.selected_thresholds !== 'undefined') {
        if (data.selected_thresholds.indexOf("custom") >= 0) {
            displayCustom = true;
        }
        if (data.selected_thresholds.indexOf("warning") >= 0) {
            displayWarning = true;
        }
        if (data.selected_thresholds.indexOf("critical") >= 0) {
            displayCritical = true;
        }
    }

    if (start && step && stop) {
        if (typeof data.warn_level !== "undefined") {

            plotLineOptions = configwizard_make_highcharts_constant_line(
                'Warning', '#dd0', data.warn_level, false
            );

            if (displayWarning) {
                plotLines_yAxis.push(plotLineOptions);
            }

            fakeSeriesOptions = configwizard_make_highcharts_fake_series(
                'Warning', '#dd0', data.warn_level, start, displayWarning, plotLineOptions
            );
            series_data.push(fakeSeriesOptions);
        }
        if (typeof data.crit_level !== "undefined") {

            plotLineOptions = configwizard_make_highcharts_constant_line(
                'Critical', '#d00', data.crit_level, false
            );

            if (displayCritical) {
                plotLines_yAxis.push(plotLineOptions);
            }

            fakeSeriesOptions = configwizard_make_highcharts_fake_series(
                'Critical', '#d00', data.crit_level, start, displayCritical, plotLineOptions
            );
            series_data.push(fakeSeriesOptions);
        }
        if (typeof data.custom_value !== "undefined") {

            plotLineOptions = configwizard_make_highcharts_constant_line(
                'Custom Value', '#4D89F9', data.custom_value, true, custom_value_selector(uid)
            );

            if (displayCustom) {
                plotLines_yAxis.push(plotLineOptions);
            }

            fakeSeriesOptions = configwizard_make_highcharts_fake_series(
                'Custom Value', '#4D89F9', data.custom_value, start, displayCustom, plotLineOptions
            );
            series_data.push(fakeSeriesOptions);
        }
    }

    plotLines_xAxis = [];
    if (!isNaN(data.timeframe_warning)) {
        plotLineOptions = configwizard_make_highcharts_constant_line(
            'timeframe_warning', '#dd0', Date.now() + (data.timeframe_warning * 86400000), true, timeframe_warning_selector(uid), curry_time_to_days_left
        );
        plotLines_xAxis.push(plotLineOptions);
    }
    if (!isNaN(data.timeframe_critical)) {
        plotLineOptions = configwizard_make_highcharts_constant_line(
            'timeframe_critical', '#d00', Date.now() + (data.timeframe_critical * 86400000), true, timeframe_critical_selector(uid), curry_time_to_days_left
        );
        plotLines_xAxis.push(plotLineOptions);
    }

    Highcharts.setOptions({
        global: {
            useUTC: false
        }
    });

    var yAxis = {
        title: {
            text: track
        },
        min: 0,
        startOnTick: true,
        endOnTick: true,
        gridLineWidth: 1,
        gridLineColor: '#EEE',
        plotLines: plotLines_yAxis
    };
    if (data.unit) {
        yAxis.title.text += ' (' + data.unit + ')';
    }
    if (data.dmax == 0 && data.emax == 0) {
        // Fix the y-axcis labels and limits for all zero data.
        // @todo: We should check min values too to support negative values.
        yAxis.max = 1;
        yAxis.allowDecimals = false;
        yAxis.showFirstLabel = true;
        yAxis.showLastLabel = false;
    }

    if (data.dmin < 0 || data.emin < 0) {
        yAxis.min = 1.1 * Math.min(data.dmin, data.emin);
    }

    var xAxis = {
        type: 'datetime',
        maxZoom: 300000,
        title: {
            text: null
        },
        gridLineWidth: 1,
        gridLineColor: '#DFDFDF',
        gridLineDashStyle: 'dot',
        lineColor: '#EEE',
        tickColor: '#EEE',
        plotLines: plotLines_xAxis
    };

    // Create a nice looking filename
    var filename = title.replace(/ /g, "_");

    var chart = new Highcharts.Chart({
        exporting: {
            url: window.location.protocol + '//' + window.location.hostname + '/nagiosxi/includes/components/highcharts/exporting-server/index.php',
            filename: filename,
            chartOptions: { chart: { spacing: [25, 25, 25, 20], marginRight: 30 } }
        },
        chart: {
            renderTo: 'highcharts-target-' + uid,
            //zoomType: 'x',
            height: height,
            width: width,
            animation: false,
            ignoreHiddenSeries: true,
            spacingRight: 25,
            spacingTop: 20,
            marginTop: 65,
            marginLeft: 75,
            plotBorderWidth: 1,
            plotBorderColor: '#EEE',
            resetZoomButton: {
                position: {
                    x: -29,
                    y: -50
                },
            }
        },
        credits: {
            enabled: false
        },
        title: {
            text: title,
            style: {
                fontWeight: 'bold',
                "font-family": "'verdana', 'serif'",
                "font-size": 15
            }
        },
        navigation: {
            buttonOptions: {
                y: -4,
            }
        },
        xAxis: xAxis,
        yAxis: yAxis,
        tooltip: {
            enabled: tracking,
            crosshairs: true,
            shared: true,
            shadow: false,
            shape: 'callout',
            valueDecimals: 3,
            borderRadius: 0,
            valueSuffix: data.unit ? ' ' + data.unit : '',
            xDateFormat: '%Y-%m-%d %H:%M'
        },
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                fillOpacity: 0.5,
                animation: false,
                shadow: false,
                enableMouseTracking: tracking
            },
            area: {
                lineWidth: 1,
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 4
                        }
                    }
                },
                shadow: false,
                states: {
                    hover: {
                        lineWidth: 1.5
                    }
                }
            },
            arearange: {

            },
            line: {
                lineWidth: 1.5,
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 4
                        }
                    }
                },
                shadow: false,
                states: {
                    hover: {
                        lineWidth: 2
                    }
                }
            }

        },
        noData: {
            style: {
                color: "#AAAAAA",
                fontWeight: "normal"
            }
        },
        series: series_data
    }, function (chart) {

        // Register plotline events (line drag, expansion-on-hover
        for (i in chart.axes) {
            curAxis = chart.axes[i];
            for (j in curAxis.plotLinesAndBands) {
                curPlotLine = curAxis.plotLinesAndBands[j]
                if (curPlotLine.options.draggable) {
                    /* If the axis is vertical (line is horizontal), plotlines get added/removed dynamically */
                    if (curAxis.horiz) {
                        capacity_planning_draggablePlotLine(curAxis, curPlotLine.id)
                    }
                    else {
                        capacity_planning_draggablePlotLine(curAxis, curPlotLine.id, chart.series);
                    }
                }
            }
        }

        extchart = chart;
    });

    if (data.error) {
        Highcharts.setOptions({
            lang: { noData: '<?php echo _("No data available"); ?>' }
        });
    }
}

