<input type="hidden" id="host_or_service" name="host_or_service" value="<?= encode_form_val($host_or_service) ?>" />
<input type="hidden" id="host_name" name="host_name" value="<?= encode_form_val($host_name) ?>" />
<input type="hidden" id="host_address" name="host_address" value="<?= encode_form_val($host_address) ?>" />
<input type="hidden" id="service_description" name="service_description" value="<?= encode_form_val($service_description) ?>" />
<input type="hidden" id="service_host" name="service_host" value="<?= encode_form_val($service_host) ?>" />
<input type="hidden" id="check_command" name="check_command" value="<?= encode_form_val($check_command) ?>" />

<div class="container m-0 g-0">
    <h2 class="mb-2"><?= _("Construct Your Command") ?></h2>
    <div id="configForm">
        <?= wizard_input_text('command_name', _('Command Name'), $command_name, _("Example") . ": check_example", 'Please enter a Command Name') ?>
        <?= wizard_input_text('command_line', _('Command Line'), $command_line, _("Example") . ': $USER1$/check_example -H $HOSTADDRESS$ -P $ARG1$ $ARG2$', 'Please enter a Command Line') ?>
<?php
        $plugin_options = [];
        $plugins = scandir($cfg['component_info']['nagioscore']['plugin_dir']); 
        foreach ($plugins as $plug) {
            if ($plug == '.' || $plug =='..') { continue; } 
            $escaped_plugin = encode_form_val($plug);
            $plugin_options[$escaped_plugin] = $escaped_plugin;
        }
        echo wizard_select('plugin', _('Available Plugins'), $plugin_options, $plugin, _("Selecting a plugin will also show documenation for that plugin."));
?>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="pluginhelp" class="form-label"><?php echo _("Plugin Help"); ?></label>
                <div id="pluginhelp"></div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        get_plugin_help('<?= grab_array_var($_SESSION, 'token') ?>', false)
    })

    $('#plugin').on('change', () => get_plugin_help('<?= grab_array_var($_SESSION, 'token') ?>', true))

    function get_plugin_help(token, command)
    {
        var input_plugin = $('#plugin').val();
        if (input_plugin == 'null') {
            $('#pluginhelp').html("<pre><?= _("No plugin selected.")?></pre>");
        } else {
            $('#pluginhelp').load('<?php echo get_component_url_base('ccm') ?>/command_test.php?&cmd=help&mode=help&plugin='+input_plugin+'&token='+token);
            if (command) {
                $('#command_line').val(`$USER1$/${input_plugin}`)
            }
        }
    }
</script>

<script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
