    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="password" value="<?= encode_form_val($password) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('MongoDB Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this MongoDB Database')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label"><?= _('Username') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('MongoDB Server Metrics') ?></h2>
        <p><?= _('Specify the metrics you would like to monitor on the MongoDB Server') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="cc" class="form-check-input" name="services[check_connection]"  <?= is_checked(grab_array_var($services, "check_connection"), "on") ?> >
                        <label for="cc" class="form-check-label bold"><?= _('Check Connection') ?> <?= xi6_info_tooltip(_("Monitor the connection to host.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[check_connection_warning]" name="serviceargs[check_connection_warning]" value="<?= encode_form_val($serviceargs['check_connection_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">sec</span>
                            <i id="serviceargs_check_connection_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[check_connection_critical]" name="serviceargs[check_connection_critical]" value="<?= encode_form_val($serviceargs['check_connection_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">sec</span>
                            <i id="serviceargs_check_connection_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="fc" class="form-check-input" name="services[free_connections]"  <?= is_checked(grab_array_var($services, "free_connections"), "on") ?> >
                        <label for="fc" class="form-check-label bold"><?= _('Free Connections') ?> <?= xi6_info_tooltip(_("Monitor the percent of free connections available.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[free_connections_warning]" name="serviceargs[free_connections_warning]" value="<?= encode_form_val($serviceargs['free_connections_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_free_connections_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[free_connections_critical]" name="serviceargs[free_connections_critical]" value="<?= encode_form_val($serviceargs['free_connections_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_free_connections_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="mu" class="form-check-input" name="services[memory_usage]"  <?= is_checked(grab_array_var($services, "memory_usage"), "on") ?> >
                        <label for="mu" class="form-check-label bold"><?= _('Memory Usage') ?> <?= xi6_info_tooltip(_("Monitor the MongoDB server&apos;s memory usage.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[memory_usage_warning]" name="serviceargs[memory_usage_warning]" value="<?= encode_form_val($serviceargs['memory_usage_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">GB</span>
                            <i id="serviceargs_memory_usage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[memory_usage_critical]" name="serviceargs[memory_usage_critical]" value="<?= encode_form_val($serviceargs['memory_usage_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">GB</span>
                            <i id="serviceargs_memory_usage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="mmu" class="form-check-input" name="services[mapped_memory]"  <?= is_checked(grab_array_var($services, "mapped_memory"), "on") ?> >
                        <label for="mmu" class="form-check-label bold"><?= _('Mapped Memory Usage') ?> <?= xi6_info_tooltip(_("Monitor the mapped memory usage of the MongoDB server.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[mapped_memory_warning]" name="serviceargs[mapped_memory_warning]" value="<?= encode_form_val($serviceargs['mapped_memory_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">GB</span>
                            <i id="serviceargs_mapped_memory_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[mapped_memory_critical]" name="serviceargs[mapped_memory_critical]" value="<?= encode_form_val($serviceargs['mapped_memory_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">GB</span>
                            <i id="serviceargs_mapped_memory_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ltp" class="form-check-input" name="services[lock_time]"  <?= is_checked(grab_array_var($services, "lock_time"), "on") ?> >
                        <label for="ltp" class="form-check-label bold"><?= _('Lock Time Percent') ?> <?= xi6_info_tooltip(_("Monitor the percent of time the MongoDB server is locked.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[lock_time_warning]" name="serviceargs[lock_time_warning]" value="<?= encode_form_val($serviceargs['lock_time_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_lock_time_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[lock_time_critical]" name="serviceargs[lock_time_critical]" value="<?= encode_form_val($serviceargs['lock_time_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_lock_time_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="aft" class="form-check-input" name="services[flush_average]"  <?= is_checked(grab_array_var($services, "flush_average"), "on") ?> >
                        <label for="aft" class="form-check-label bold"><?= _('Average Flush Time') ?> <?= xi6_info_tooltip(_("Monitor the average time it takes to preform a flush.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[flush_average_warning]" name="serviceargs[flush_average_warning]" value="<?= encode_form_val($serviceargs['flush_average_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">ms</span>
                            <i id="serviceargs_flush_average_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[flush_average_critical]" name="serviceargs[flush_average_critical]" value="<?= encode_form_val($serviceargs['flush_average_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">ms</span>
                            <i id="serviceargs_flush_average_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="lft" class="form-check-input" name="services[last_flush]"  <?= is_checked(grab_array_var($services, "last_flush"), "on") ?> >
                        <label for="lft" class="form-check-label bold"><?= _('Last Flush Time') ?> <?= xi6_info_tooltip(_("Monitor the time since the last flush.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[last_flush_warning]" name="serviceargs[last_flush_warning]" value="<?= encode_form_val($serviceargs['last_flush_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">ms</span>
                            <i id="serviceargs_last_flush_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[last_flush_critical]" name="serviceargs[last_flush_critical]" value="<?= encode_form_val($serviceargs['last_flush_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">ms</span>
                            <i id="serviceargs_last_flush_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="imr" class="form-check-input" name="services[index_miss_ratio]"  <?= is_checked(grab_array_var($services, "index_miss_ratio"), "on") ?> >
                        <label for="imr" class="form-check-label bold"><?= _('Index Miss Ratio') ?> <?= xi6_info_tooltip(_("Monitor ratio of index hits to misses.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[index_miss_ratio_warning]" name="serviceargs[index_miss_ratio_warning]" value="<?= encode_form_val($serviceargs['index_miss_ratio_warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_index_miss_ratio_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[index_miss_ratio_critical]" name="serviceargs[index_miss_ratio_critical]" value="<?= encode_form_val($serviceargs['index_miss_ratio_critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_index_miss_ratio_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="nd" class="form-check-input" name="services[num_dbs]"  <?= is_checked(grab_array_var($services, "num_dbs"), "on") ?> >
                        <label for="nd" class="form-check-label bold"><?= _('Number of Databases') ?> <?= xi6_info_tooltip(_("Monitor the number of databases.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[num_dbs_warning]" name="serviceargs[num_dbs_warning]" value="<?= encode_form_val($serviceargs['num_dbs_warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_dbs_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[num_dbs_critical]" name="serviceargs[num_dbs_critical]" value="<?= encode_form_val($serviceargs['num_dbs_critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_dbs_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="nc" class="form-check-input" name="services[num_collections]"  <?= is_checked(grab_array_var($services, "num_collections"), "on") ?> >
                        <label for="nc" class="form-check-label bold"><?= _('Number of Collections') ?> <?= xi6_info_tooltip(_("Monitor the number of collections.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[num_collections_warning]" name="serviceargs[num_collections_warning]" value="<?= encode_form_val($serviceargs['num_collections_warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_collections_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[num_collections_critical]" name="serviceargs[num_collections_critical]" value="<?= encode_form_val($serviceargs['num_collections_critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_collections_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="qps" class="form-check-input" name="services[num_queries]"  <?= is_checked(grab_array_var($services, "num_queries"), "on") ?> >
                        <label for="qps" class="form-check-label bold"><?= _('Queries Per Second') ?> <?= xi6_info_tooltip(_("Monitor the amount of queries per second.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[num_queries_warning]" name="serviceargs[num_queries_warning]" value="<?= encode_form_val($serviceargs['num_queries_warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_queries_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[num_queries_critical]" name="serviceargs[num_queries_critical]" value="<?= encode_form_val($serviceargs['num_queries_critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_num_queries_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('MongoDB Server Replication Metrics') ?></h2>
        <p><?= _('These options require you to be using MongoDBs replication features.If replication is not set up you will recieve errors') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="rep" class="form-check-input" name="services[rep_state]"  <?= is_checked(grab_array_var($services, "rep_state"), "on") ?> >
                        <label for="rep" class="form-check-label bold"><?= _('Replication State') ?> <?= xi6_info_tooltip(_("Monitor the replication state.This check does not require any arguments for warning/critical.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="rlag" class="form-check-input" name="services[rep_lag]"  <?= is_checked(grab_array_var($services, "rep_lag"), "on") ?> >
                        <label for="rlag" class="form-check-label bold"><?= _('Replication Lag') ?> <?= xi6_info_tooltip(_("Monitor replication lag of the server.This check may show apparent lag of < 10 sec even if there is not lag.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[rep_lag_warning]" name="serviceargs[rep_lag_warning]" value="<?= encode_form_val($serviceargs['rep_lag_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">sec</span>
                            <i id="serviceargs_rep_lag_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[rep_lag_critical]" name="serviceargs[rep_lag_critical]" value="<?= encode_form_val($serviceargs['rep_lag_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">sec</span>
                            <i id="serviceargs_rep_lag_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="rlagp" class="form-check-input" name="services[rep_lag_percent]"  <?= is_checked(grab_array_var($services, "rep_lag_percent"), "on") ?> >
                        <label for="rlagp" class="form-check-label bold"><?= _('Replication Lag Percent') ?> <?= xi6_info_tooltip(_("Monitor the percent of replication lag on the server.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[rep_lag_percent_warning]" name="serviceargs[rep_lag_percent_warning]" value="<?= encode_form_val($serviceargs['rep_lag_percent_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_rep_lag_percent_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[rep_lag_percent_critical]" name="serviceargs[rep_lag_percent_critical]" value="<?= encode_form_val($serviceargs['rep_lag_percent_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_rep_lag_percent_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
