<?php
/**
 * MagpieRSS Fetcher - PHP 8+ compatible
 * Drop-in replacement for the original rss_fetch.inc
 */

require_once(dirname(__FILE__) . '/rss_parse.inc');

if (!defined('MAGPI_USER_AGENT')) {
    define('MAGPI_USER_AGENT', 'MagpieRSS/0.9 (PHP ' . PHP_VERSION . ')');
}

function fetch_rss($url) {
    $content = magpie_fetch_url($url);
    if ($content === false) {
        return new MagpieRSS('', 'UTF-8'); // will set error
    }

    // Attempt to detect encoding from XML declaration
    if (preg_match('/<\?xml.*encoding=["\'](.*?)["\'].*\?>/i', $content, $matches)) {
        $encoding = strtoupper(trim($matches[1]));
    } else {
        $encoding = 'UTF-8';
    }

    $rss = new MagpieRSS($content, $encoding);

    if (!empty($rss->ERROR)) {
        trigger_error("MagpieRSS Parse Error: {$rss->ERROR}", E_USER_WARNING);
    }

    return $rss;
}

function magpie_fetch_url($url) {
    $data = false;

    // First try fopen if allowed
    if (ini_get('allow_url_fopen')) {
        $context = stream_context_create([
            'http' => [
                'method' => 'GET',
                'header' => "User-Agent: " . MAGPI_USER_AGENT . "\r\n",
                'timeout' => 10
            ]
        ]);
        $data = @file_get_contents($url, false, $context);
    }

    // If that fails, try cURL
    if ($data === false && function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_USERAGENT => MAGPI_USER_AGENT,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true
        ]);
        $data = curl_exec($ch);
        curl_close($ch);
    }

    return $data;
}
