    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2><?= _('SLA Report Settings') ?></h2>
            <p><?= _('Select the settings for the SLA report to run. Remember, every time you run the check it will use these settings') ?></p>

            <div class="row mb-2">
                    <div class="col-sm-auto">
                        <label for="reportperiodDropdown" class="form-label form-item-required"><?= _("Report Period") ?> </label>
                        <div class="input-group position-relative">
                            <select name="reportperiod" id="reportperiodDropdown" class="form-select monitor rounded" placeholder="<?= _("Select Report Period")?> " required>
                                <option value="" disabled selected hidden>Choose a Report Period...</option>
                                <option value="24h"<?= ($reportperiod == '24h' ? ' selected="selected"' : '') ?>><?= _("Last 24 Hours") ?></option>
                                <option value="7d"<?= ($reportperiod == '7d' ? ' selected="selected"' : '') ?>><?= _("Last 7 Days") ?></option>
                                <option value="1M"<?= ($reportperiod == '1M' ? ' selected="selected"' : '') ?>><?= _("Last Month") ?></option>
                                <option value="custom"<?= ($reportperiod == 'custom' ? ' selected="selected"' : '') ?>><?= _("Custom") ?></option>
                            </select>
                            <div class="invalid-feedback">
                                Please enter the Report Period
                            </div>
                            <i id="reportperiodDropdown_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-auto custom-timeperiod <?= ($reportperiod != 'custom' ? ' visually-hidden' : '') ?>">
                        <label for="custom_reportperiod" class="form-label form-item-required"><?= _("Duration") ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="custom_reportperiod" id="custom_reportperiod" value="<?= $custom_reportperiod ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Duration") ?>" required>
                            <div class="invalid-feedback">
                                Please enter the Duration
                            </div>
                            <i id="custom_reportperiod_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-auto custom-timeperiod <?= ($reportperiod != 'custom' ? ' visually-hidden' : '') ?>">
                        <label for="custom_reportperiod_unit" class="form-label form-item-required"><?= _("Unit of Time") ?> </label>
                        <div class="input-group position-relative">
                            <select name="custom_reportperiod_unit" id="custom_reportperiod_unit" class="form-select monitor rounded" required>
                                <option value="" disabled selected hidden>Choose a Unit of Time...</option>
                                <option value="m"<?= ($custom_reportperiod_unit == 'm' ? ' selected="selected"' : '') ?>><?= _("Minutes")  ?></option>
                                <option value="h"<?= ($custom_reportperiod_unit == 'h' ? ' selected="selected"' : '') ?>><?= _("Hours")  ?></option>
                                <option value="d"<?= ($custom_reportperiod_unit == 'd' ? ' selected="selected"' : '') ?>><?= _("Days")  ?></option>
                                <option value="M"<?= ($custom_reportperiod_unit == 'M' ? ' selected="selected"' : '') ?>><?= _("Months")  ?></option>
                            </select>
                            <div class="invalid-feedback">
                                Please enter the Unit of Time
                            </div>
                            <i id="custom_reportperiod_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _('SLA Report Advanced Settings') ?></h2>
            <p><?= _('These are settings used to manipulate the way SLA data is reported and received. These settings will apply to all services in the wizard') ?>.</p>

            <div class="row mb-2">
                <div class="col-sm-auto">
                    <label for="advanced[assumestateretention]" class="form-label form-item-required"><?= _("Assume State Retention") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[assumestateretention]" id="advanced[assumestateretention]" class="form-select monitor rounded" placeholder="<?= _("Select Assume States During Program Downtime") ?> " required>
                            <option value="yes"<?= (isset($advanced['assumestateretention']) && $advanced["assumestateretention"] == "yes" ? ' selected="selected"' : '') ?>><?= _("Yes") ?> </option>
                            <option value="no"<?= (isset($advanced['assumestateretention']) && $advanced["assumestateretention"] == "no" ? ' selected="selected"' : '') ?>><?= _("No") ?> </option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Assume States During Program Downtime
                        </div>
                        <i id="advanced_assumestateretention_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
                <div class="col-sm-auto">
                    <label for="advanced[assumestatesduringdowntime]" class="form-label form-item-required"><?= _("Assume States During Program Downtime") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[assumestatesduringdowntime]" id="advanced[assumestatesduringdowntime]" class="form-select monitor rounded" placeholder="<?= _("Select Assume States During Program Downtime") ?> " required>
                            <option value="yes"<?= (isset($advanced['assumestatesduringdowntime']) && $advanced["assumestatesduringdowntime"] == "yes" ? ' selected="selected"' : '') ?>><?= _("Yes") ?> </option>
                            <option value="no"<?= (isset($advanced['assumestatesduringdowntime']) && $advanced["assumestatesduringdowntime"] == "no" ? ' selected="selected"' : '') ?>><?= _("No") ?> </option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Assume States During Program Downtime
                        </div>
                        <i id="advanced_assumestatesduringdowntime_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
                <div class="col-sm-auto">
                    <label for="advanced[assumeinitialstates]" class="form-label form-item-required"><?= _("Assume Initial States") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[assumeinitialstates]" id="advanced[assumeinitialstates]" class="form-select monitor rounded" placeholder="<?= _("Select Assume State Retention") ?> " required>
                            <option value="yes"<?= (isset($advanced['assumeinitialstates']) && $advanced["assumeinitialstates"] == "yes" ? ' selected="selected"' : '') ?>><?= _("Yes") ?></option>
                            <option value="no"<?= (isset($advanced['assumeinitialstates']) && $advanced["assumeinitialstates"] == "no" ? ' selected="selected"' : '') ?>><?=  _("No") ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Assume State Retention
                        </div>
                        <i id="advanced_assumeinitialstates_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-auto">
                    <label for="" class="form-label form-item-required"><?= _("Include Soft States") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[includesoftstates]" id="advanced[includesoftstates]" class="form-select monitor rounded" placeholder="<?= _("Select Include Soft States") ?> " required>
                            <option value="no"<?= (isset($advanced['includesoftstates']) && $advanced["includesoftstates"] == "no" ? ' selected="selected"' : '') ?>><?= _("No") ?> </option>
                            <option value="yes"<?= (isset($advanced['includesoftstates']) && $advanced["includesoftstates"] == "yes" ? ' selected="selected"' : '') ?>><?= _("Yes") ?> </option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Include Soft States
                        </div>
                        <i id="advanced_includesoftstates_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-auto">
                    <label for="" class="form-label form-item-required"><?= _("First Assumed Host State") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[assumedhoststate]" id="advanced[assumedhoststate]" class="form-select monitor rounded" placeholder="<?= _("Select First Assumed Host State") ?> " required>
                            <option value="0"<?= (isset($advanced['assumedhoststate']) && $advanced["assumedhoststate"] == 0 ? ' selected="selected"' : '') ?>><?= _("Unspecified") ?> </option>
                            <option value="-1"<?= (isset($advanced['assumedhoststate']) && $advanced["assumedhoststate"] == -1 ? ' selected="selected"' : '') ?>><?= _("Current State") ?> </option>
                            <option value="3"<?= (isset($advanced['assumedhoststate']) && $advanced["assumedhoststate"] == 3 ? ' selected="selected"' : '') ?>><?= _("Host Up") ?> </option>
                            <option value="4"<?= (isset($advanced['assumedhoststate']) && $advanced["assumedhoststate"] == 4 ? ' selected="selected"' : '') ?>><?= _("Host Down") ?> </option>
                            <option value="5"<?= (isset($advanced['assumedhoststate']) && $advanced["assumedhoststate"] == 5 ? ' selected="selected"' : '') ?>><?= _("Host Unreachable") ?> </option>
                        </select>
                        <div class="invalid-feedback">
                            Please select First Assumed Host State
                        </div>
                        <i id="advanced_assumedhoststate_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-auto">
                    <label for="" class="form-label form-item-required"><?= _("First Assumed Service State") ?></label>
                    <div class="input-group position-relative">
                        <select name="advanced[assumedservicestate]" id="advanced[assumedservicestate]" class="form-select monitor rounded" placeholder="<?= _("Select First Assumed Service State") ?> " required>
                            <option value="0"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == 0 ? ' selected="selected"' : '') ?>><?= _("Unspecified") ?> </option>
                            <option value="-1"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == -1 ? ' selected="selected"' : '') ?>><?= _("Current State") ?> </option>
                            <option value="6"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == 6 ? ' selected="selected"' : '') ?>><?= _("Service Ok") ?> </option>
                            <option value="7"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == 7 ? ' selected="selected"' : '') ?>><?= _("Service Warning") ?> </option>
                            <option value="8"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == 8 ? ' selected="selected"' : '') ?>><?= _("Service Unknown") ?> </option>
                            <option value="9"<?= (isset($advanced['assumedservicestate']) && $advanced["assumedservicestate"] == 9 ? ' selected="selected"' : '') ?>><?= _("Service Critical") ?> </option>
                        </select>
                        <div class="invalid-feedback">
                            Please select First Assumed Service State
                        </div>
                        <i id="advanced_assumedservicestate_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            if ($("#reportperiodDropdown").val() == "custom") {
                $(".custom-timeperiod").removeClass('visually-hidden');
                $("#custom_reportperiod").attr('required', true);
                $("#custom_reportperiod_unit").attr('required', true);
            } else {
                $(".custom-timeperiod").addClass('visually-hidden');
                $("#custom_reportperiod").removeAttr('required');
                $("#custom_reportperiod_unit").removeAttr('required');
            }

            $("#reportperiodDropdown").change(function() {
                if ($(this).val() == "custom") {
                    $(".custom-timeperiod").removeClass('visually-hidden');
                    $("#custom_reportperiod").attr('required', true);
                    $("#custom_reportperiod_unit").attr('required', true);
                } else {
                    $(".custom-timeperiod").addClass('visually-hidden');
                    $("#custom_reportperiod").removeAttr('required');
                    $("#custom_reportperiod_unit").removeAttr('required');
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
