    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="hostname" value="<?= encode_form_val($hostname) ?>" />
    <input type="hidden" name="username" value="<?= $username ?>" />
    <input type="hidden" name="reportperiod" value="<?= $reportperiod ?>" />
    <input type="hidden" name="custom_reportperiod" value="<?= $custom_reportperiod ?>" />
    <input type="hidden" name="custom_reportperiod_unit" value="<?= $custom_reportperiod_unit ?>" />
    <input type="hidden" name="advanced" value="<?= base64_encode(json_encode($advanced)) ?>" />
    <input type="hidden" name="warning" value="<?= $warning ?>" />
    <input type="hidden" name="critical" value="<?= $critical ?>" />
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2><?= _('Connection Settings') ?></h2>
        <p><?= _('The settings used to connect to the Nagios XI server and the hostname of the server') ?></p>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Hostname') ?> <?= xi6_info_tooltip(_("The name of the host that the services will be applied to.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Hostname") ?>">
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="displayreportperiod" class="form-label"><?= _("Report Period") ?> <?= xi6_info_tooltip(_("How long to look back for the SLA. Also serves as default check interval.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="displayreportperiod" id="displayreportperiod" value="<?= $displayreportperiod ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Report Period") ?>" disabled="on">
                    <i id="displayreportperiod_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Check SLA Setup') ?></h2>
        <div class="alert alert-info w-75 mb-2">
            <?= _("Warning and Critical support all the thresholds shown in the") ?> <a target="_blank" href="https://nagios-plugins.org/doc/guidelines.html#THRESHOLDFORMAT"><?= _("Nagios Plugins guidelines") ?></a>.<br><br><?= _("Normally a threshold is met when a value reaches a certain number, because we are going down from 100%, we need to do the opposite. This wizard automatically places a '@' in front of the warning and critical values to reverse them.") ?>
        </div>

        <!-- SLA Setup Tabs -->
        <div class="col-sm-10 border-block mt-4">
            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item"><a class="nav-link active" id="pills-host-tab" data-bs-toggle="pill" data-bs-target="#pills-host" type="button" role="tab" aria-controls="pills-host" aria-selected="true">Host</a></li>
                <li class="nav-item"><a class="nav-link" id="pills-service-tab" data-bs-toggle="pill" data-bs-target="#pills-service" type="button" role="tab" aria-controls="pills-service" aria-selected="false">Service</a></li>
                <li class="nav-item"><a class="nav-link" id="pills-hostgroup-tab" data-bs-toggle="pill" data-bs-target="#pills-hostgroup" type="button" role="tab" aria-controls="pills-hostgroup" aria-selected="false">Hostgroup</a></li>
                <li class="nav-item"><a class="nav-link" id="pills-servicegroup-tab" data-bs-toggle="pill" data-bs-target="#pills-servicegroup" type="button" role="tab" aria-controls="pills-servicegroup" aria-selected="false">Servicegroup</a></li>
            </ul>

            <div class="tab-content" id="pills-tabContent">

                <div id="pills-host" class="tab-pane fade show active" role="tabpanel" aria-labelledby="pills-host-tab">

                    <div id="host" class="position-relative adddeleterow">
                        <fieldset class="row g-2 mb-1">
                            <div class="d-flex align-items-end form-check col-sm-3">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold form-item-required"><?= _('Target Host') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-3 text-center">
                                <label class="form-check-label bold"><?= _('Warning') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-3">
                                <label class="form-check-label bold text-center"><?= _('Critical') ?></label>
                            </div>
                        </fieldset>
<?php
    for ($x = 0; $x < count($serviceargs['host']); $x++) {

        // Set values
        $host = encode_form_val(array_key_exists('host', $serviceargs['host'][$x]) ? $serviceargs['host'][$x]['host'] : '');
        $warning = encode_form_val($serviceargs['host'][$x]['warning']);
        $critical = encode_form_val($serviceargs['host'][$x]['critical']);
?>
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[host][<?= $x ?>]" class="form-check-input rounded mt-2 me-2" name="services[host][<?= $x ?>]" <?= (isset($services['host'][$x]) ? is_checked($services['host'][$x], 1) : '') ?>>
<?php
        $args = array('brevity' => 1, 'orderby' => 'host_name:a');
        $oxml = get_xml_host_objects($args);
?>
                                    <select name="serviceargs[host][<?= $x ?>][host]" id="serviceargs[host][<?= $x ?>][host]" class="form-control form-select form-select-sm rounded hostList monitor">
                                        <option value="" selected disabled><?= _("Choose a Host...") ?></option>
<?php
        if ($oxml) {
            foreach ($oxml->host as $hostobject) {
                if (isset($hostobject->host_name)) {
                    $name = strval($hostobject->host_name);
                }
?>
                                        <option value="<?= $name ?>" <?= is_selected($host, $name) ?>><?= $name ?></option>
<?php
            }
        }
?>
                                    </select>
                                    <div class="invalid-feedback">
                                        Please select a host.
                                    </div>
                                    <i id="serviceargs_host_<?= $x ?>_host_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[host][<?= $x ?>][warning]" name="serviceargs[host][<?= $x ?>][warning]" value="<?= $warning ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_host_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[host][<?= $x ?>][critical]" name="serviceargs[host][<?= $x ?>][critical]" value="<?= $critical ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_host_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
<?php
    }
?>
                    </div> <!-- host adddeleterow -->
                </div> <!-- Closes #host-tab -->

                <div id="pills-service" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-service-tab">

                    <div id="service" class="position-relative adddeleterow">
                        <fieldset class="row g-2 mb-1">
                            <div class="d-flex align-items-end form-check col-sm-3">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold form-item-required"><?= _('Target Host') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-3">
                                <label class="form-check-label bold form-item-required"><?= _('Target Service') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-3 text-center">
                                <label class="form-check-label bold"><?= _('Warning') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-3">
                                <label class="form-check-label bold text-center"><?= _('Critical') ?></label>
                            </div>
                        </fieldset>
<?php
    for ($x = 0; $x < count($serviceargs['service']); $x++) {

        // Set values
        $host = encode_form_val(array_key_exists('host', $serviceargs['service'][$x]) ? $serviceargs['service'][$x]['host'] : '');
        $service = encode_form_val(array_key_exists('service', $serviceargs['service'][$x]) ? $serviceargs['service'][$x]['service'] : '');
        $warning = encode_form_val($serviceargs['service'][$x]['warning']);
        $critical = encode_form_val($serviceargs['service'][$x]['critical']);
?>
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[service][<?= $x ?>]" class="form-check-input rounded mt-2 me-2" name="services[service][<?= $x ?>]" <?= (isset($services['service'][$x]) ?is_checked($services['service'][$x], 1) : '') ?>>
<?php
        $args = array('brevity' => 1, 'orderby' => 'host_name:a');
        $oxml = get_xml_host_objects($args);
?>
                                    <select name="serviceargs[service][<?= $x ?>][host]" id="serviceargs[service][<?= $x ?>][host]" class="form-control form-select form-select-sm rounded hostSList monitor">
                                        <option value="" selected disabled><?= _("Choose a Host...") ?></option>
<?php
        if ($oxml) {
            foreach ($oxml->host as $hostobject) {
                if (isset($hostobject->host_name)) {
                    $hname = strval($hostobject->host_name);
                }
?>
                                        <option value="<?= $hname ?>" <?= is_selected($host, $hname) ?>><?= $hname ?></option>
<?php
            }
        }
?>
                                    </select>
                                    <div class="invalid-feedback">
                                        Please select a Host.
                                    </div>
                                    <i id="serviceargs_host_<?= $x ?>_host_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
<?php
        $args = array('brevity' => 1, 'host_name' => $host, 'orderby' => 'service_description:a');
        $oxml = get_xml_service_objects($args);
?>
                                    <select name="serviceargs[service][<?= $x ?>][service]" id="serviceargs[service][<?= $x ?>][service]" class="form-control form-select form-select-sm rounded serviceList monitor">
                                        <option value="" selected disabled><?= _("Choose a Service...") ?></option>
<?php
        if ($oxml) {
            foreach ($oxml->service as $serviceobject) {
                if (isset($serviceobject->service_description)) {
                    $sname = strval($serviceobject->service_description);
                }

                $sname = strval(isset($serviceobject->service_description));
?>
                                        <option value="<?= $sname ?>" <?= is_selected($service, $sname) ?>><?= $sname ?></option>
<?php
            }
        }
?>
                                    </select>
                                    <div class="invalid-feedback">
                                        Please select a Service.
                                    </div>
                                    <i id="serviceargs_service_<?= $x ?>_service_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[service][<?= $x ?>][warning]" name="serviceargs[service][<?= $x ?>][warning]" value="<?= $warning ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_service_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[service][<?= $x ?>][critical]" name="serviceargs[service][<?= $x ?>][critical]" value="<?= $critical ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_service_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
<?php
    }
?>
                    </div> <!-- service adddeleterow -->
                </div> <!-- Closes #service-tab -->

                <div id="pills-hostgroup" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-hostgroup-tab">

                    <div id="hostgroup" class="position-relative adddeleterow">
                        <fieldset class="row g-2 mb-1">
                            <div class="d-flex align-items-end form-check col-sm-4">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold form-item-required"><?= _('Target Hostgroup') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-2 text-center">
                                <label class="form-check-label bold"><?= _('Warning') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-2">
                                <label class="form-check-label bold text-center"><?= _('Critical') ?></label>
                            </div>
                        </fieldset>
<?php
    for ($x = 0; $x < count($serviceargs['hostgroup']); $x++) {

        // Set values
        $hostgroup = encode_form_val(array_key_exists('hostgroup', $serviceargs['hostgroup'][$x]) ? $serviceargs['hostgroup'][$x]['hostgroup'] : '');
        $warning = encode_form_val($serviceargs['hostgroup'][$x]['warning']);
        $critical = encode_form_val($serviceargs['hostgroup'][$x]['critical']);
?>
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[hostgroup][<?= $x ?>]" class="form-check-input rounded mt-2 me-2" name="services[hostgroup][<?= $x ?>]" <?= (isset($services['hostgroup'][$x]) ?is_checked($services['hostgroup'][$x], 1) : '') ?>>
<?php
                    $args = array('orderby' => 'hostgroup_name:a');
                    $oxml = get_xml_hostgroup_objects($args);
?>
                                    <select name="serviceargs[hostgroup][<?= $x ?>][hostgroup]" id="serviceargs[hostgroup][<?= $x ?>][hostgroup]" class="form-control form-select form-select-sm rounded hostgroupList monitor">
                                        <option value="" selected disabled><?= _("Choose a Hostgroup...") ?></option>
<?php
        if ($oxml) {
            foreach ($oxml->hostgroup as $hg) {
                if (isset($hg->hostgroup_name)) {
                    $name = strval($hg->hostgroup_name);
                }
?>
                                        <option value="<?= $name ?>" <?= is_selected($hostgroup, $name) ?>><?= $name ?></option>
<?php
            }
        }
?>
                                    </select>
                                    <div class="invalid-feedback">
                                        Please select a Hostgroup.
                                    </div>
                                    <i id="serviceargs_hostgroup_<?= $x ?>_hostgroup_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[hostgroup][<?= $x ?>][warning]" name="serviceargs[hostgroup][<?= $x ?>][warning]" value="<?= $warning ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_hostgroup_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[hostgroup][<?= $x ?>][critical]" name="serviceargs[hostgroup][<?= $x ?>][critical]" value="<?= $critical ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_hostgroup_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
<?php
    }
?>
                    </div> <!-- hostgroup adddeleterow -->
                </div> <!-- Closes #hostgroup-tab -->

                <div id="pills-servicegroup" class="tab-pane fade show" role="tabpanel" aria-labelledby="pills-servicegroup-tab">

                    <div id="servicegroup" class="position-relative adddeleterow">
                        <fieldset class="row g-2 mb-1">
                            <div class="d-flex align-items-end form-check col-sm-4">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold form-item-required"><?= _('Target Servicegroup') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-2 text-center">
                                <label class="form-check-label bold"><?= _('Warning') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-2">
                                <label class="form-check-label bold text-center"><?= _('Critical') ?></label>
                            </div>
                        </fieldset>
<?php
    for ($x = 0; $x < count($serviceargs['servicegroup']); $x++) {

        // Set values
        $servicegroup = encode_form_val(array_key_exists('servicegroup', $serviceargs['servicegroup'][$x]) ? $serviceargs['servicegroup'][$x]['servicegroup'] : '');
        $warning = encode_form_val($serviceargs['servicegroup'][$x]['warning']);
        $critical = encode_form_val($serviceargs['servicegroup'][$x]['critical']);
?>
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[servicegroup][<?= $x ?>]" class="form-check-input rounded mt-2 me-2" name="services[servicegroup][<?= $x ?>]" <?= (isset($services['servicegroup'][$x]) ?is_checked($services['servicegroup'][$x], 1) : '') ?>>
<?php
        $args = array('orderby' => 'servicegroup_name:a');
        $oxml = get_xml_servicegroup_objects($args);
?>
                                    <select name="serviceargs[servicegroup][<?= $x ?>][servicegroup]" id="serviceargs[servicegroup][<?= $x ?>][servicegroup]" class="form-control form-select form-select-sm rounded servicegroupList monitor">
                                        <option value="" selected disabled><?= _("Choose a Servicegroup...") ?></option>
<?php
        if ($oxml) {
            foreach ($oxml->servicegroup as $sg) {
                if (isset($sg->servicegroup_name)) {
                    $name = strval($sg->servicegroup_name);
                }
?>
                                        <option value="<?= $name ?>" <?= is_selected($servicegroup, $name) ?>><?= $name ?></option>
<?php
            }
        }
?>
                                    </select>
                                    <div class="invalid-feedback">
                                        Please select a Service.
                                    </div>
                                    <i id="serviceargs_servicegroup_<?= $x ?>_servicegroup_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[servicegroup][<?= $x ?>][warning]" name="serviceargs[servicegroup][<?= $x ?>][warning]" value="<?= $warning ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_servicegroup_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                    </span>
                                    <span class="input-group-text">@</span>
                                    <input type="text" id="serviceargs[servicegroup][<?= $x ?>][critical]" name="serviceargs[servicegroup][<?= $x ?>][critical]" value="<?= $critical ?>" class="form-control form-control-sm monitor">
                                    <span class="input-group-text rounded-end">%</span>
                                    <i id="serviceargs_servicegroup_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
<?php
    }
?>
                    </div> <!-- servicegroup adddeleterow -->
                </div> <!-- Closes #servicegroup-tab -->

            </div> <!-- End #tabs -->
        </div> <!-- #tabs - border-block -->

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {

            var servicetarget = "";
            var current = "";
            var retain = true;

            // trigger .hostSList.val();
            //$("#tabs").tabs();
            var triggerTabList = [].slice.call(document.querySelectorAll('#tabs li'));
            triggerTabList.forEach(function (triggerEl) {
//                var tabTrigger = new bootstrap.Tab(triggerEl);
                $(".adddeleterow .hostSList").trigger("change");

//                triggerEl.addEventListener('click', function (event) {
//                    event.preventDefault();
//                    tabTrigger.show();
//                })
            })

            $(".adddeleterow select").on("change", function () {
                if ($(this).val() != "") {
                    $(this).parents("fieldset").find("input[type=checkbox]").prop("checked", true);
                }
            });

            $(".adddeleterow").on("change", ".hostSList", function () {
                var selected = "";
                $(this).data("oldhost", $(this).data("newhost") || "");
                $(this).data("newhost", $(this).val());

                if ($(this).val() != "") {
                    servicetarget = $(this).parents("fieldset").find(".serviceList");
                    selected = servicetarget.val();

                    var reload = reload_service_list($(this).data("oldhost"), $(this).data("newhost"));
                    update_service_list($(this).val(), servicetarget, selected, reload);
                } else {
                    $(this).parents(".row").find(".serviceList").html("<option value=''>" + "Service:" + "</option>");
                }
            });

            function update_service_list(host, servicetarget, selected, reload) {
                // Check if we have a selection and retain
                if (selected && reload) {
                    selected = selected.replace(/\s/g, "+");
                    $.get("/nagiosxi/reports/sla.php?mode=getservices&host=" + host + "&service=" + selected, function(data) {
                        servicetarget.html(data);
                    });
                } else {
                    $.get("/nagiosxi/reports/sla.php?mode=getservices&host=" + host, function(data) {
                        servicetarget.html(data);
                    });
                }
            }

            // Do we need to reload services
            function reload_service_list(oldhost, newhost) {
                if (oldhost == "") {
                    return true;
                } else {
                    return false;
                }
            }

            // Data retention trigger for loaded service list
            if ($(".hostSList").val()) {
                retain = false;
                $(".adddeleterow .hostSList").trigger("change");
            }
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
