    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Prometheus Hosts') ?></h2>

            <!-- Operating System -->
            <div class="row mb-4">
                <div class="col-sm-6">
                    <label for="os_type" class="form-label"><?= _('Operating System') ?><?= xi6_info_tooltip(_('Select the operating system of the hosts.')) ?></label>
                    <select name="os_type" id="os_type" class="form-select form-select-sm" onchange="updatePortBasedOnOS()">
                        <option value="Linux" <?= encode_form_val($os_type) === 'Linux' ? 'selected' : '' ?>><?= _('Linux') ?></option>
                        <option value="Windows" <?= encode_form_val($os_type) === 'Windows' ? 'selected' : '' ?>><?= _('Windows') ?></option>
                    </select>
                </div>
            </div>

            <!-- Host Addresses -->
            <div class="row mb-4">
                <div class="col-sm pe-0">
                    <label for="hosts" class="form-label"><?= _('Host Addresses') ?><?= xi6_info_tooltip(_('The IP addresses or hostnames of Linux hosts using Prometheus Node Exporter or Windows hosts using Windows Exporter to monitor. One entry per line.')) ?></label>
                    <textarea name="hosts" id="hosts" style="font-family: Consolas, Courier New, monospace;" class="form-control form-control-sm" placeholder="<?= _('192.168.1.100&#13;&#10;server1.example.com&#13;&#10;10.0.0.50') ?>" rows="10"><?= encode_form_val($hosts) ?></textarea>
                </div>
            </div>

            <!-- Host Port -->
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _('Host Port:') ?> <?= xi6_info_tooltip(_('The port number used by Prometheus Node Exporter or Windows Exporter for the hosts. (Default is 9100 for Linux and 9182 for Windows)')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val(!empty($port) ? $port : '9100') ?>" class="form-control monitor rounded" placeholder="<?= _("Host Port:") ?>" required>    
                        <div class="invalid-feedback">
                            <?= _("Please enter the port used by Prometheus Node Exporter for the hosts.") ?>
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <script>
                function updatePortBasedOnOS() {
                    const osType = document.getElementById('os_type').value;
                    const portInput = document.getElementById('port');
                    if (osType === 'Windows') {
                        portInput.value = '9182';
                    } else if (osType === 'Linux') {
                        portInput.value = '9100';
                    }
                }
            </script>    
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
