<div class="container m-0 g-0">
        <h2 class="mt-4"><?= _('Services') ?> <?= xi6_info_tooltip(_('Use the following syntax to define value ranges for the thresholds:<br>10 -> alert triggered when outside range of {0 .. 10}<br> 10: -> alert triggered when outside range of {10 .. inf}<br> ~10 -> alert triggered when outside range of {-inf .. 10}<br>10:20 -> alert triggered when outside range of {10 .. 20}<br> @10:20 -> alert triggered when inside range of {10 .. 20}<br>The threshold values support scientific notation.')) ?></h2>
        <p><?= _('Specify which metrics you would like to monitor') ?></p>

        <!-- Host CPU -->
        <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset align-items-center metrics">
                    <div class="form-check col-sm-2 d-flex align-items-center">
                        <input type="checkbox" id="cpu" class="form-check-input me-2" name="services[cpu]" <?= isset($services["cpu"]) && $services["cpu"] == 'on' ? 'checked="checked"' : '' ?>>
                        <label for="cpu" class="form-check-label bold me-2 text-nowrap"><?= _('CPU Usage') ?> <?= xi6_info_tooltip(_("Monitor CPU utilization of the hosts")) ?></label>
                    </div>
                    <div class="col-sm-6 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold % (default=80)')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[cpu][warning]" id="cpu_warning" value="<?= encode_form_val($serviceargs["cpu"]["warning"] ?? 80) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_cpu_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold % (default=90)')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[cpu][critical]" id="cpu_critical" value="<?= encode_form_val($serviceargs["cpu"]["critical"] ?? 90) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_cpu_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <!-- Host Memory -->
        <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset align-items-center metrics">
                    <div class="form-check col-sm-2 d-flex align-items-center">
                        <input type="checkbox" id="memory" class="form-check-input me-2" name="services[memory]" <?= isset($services["memory"]) && $services["memory"] == 'on' ? 'checked="checked"' : '' ?>>
                        <label for="memory" class="form-check-label bold me-2 text-nowrap"><?= _('Memory Usage') ?> <?= xi6_info_tooltip(_("Monitor memory utilization of the hosts")) ?></label>
                    </div>
                    <div class="col-sm-6 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold % (default=80)')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[memory][warning]" id="memory_warning" value="<?= encode_form_val($serviceargs["memory"]["warning"] ?? 80) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_memory_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold % (default=90)')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[memory][critical]" id="memory_critical" value="<?= encode_form_val($serviceargs["memory"]["critical"] ?? 90) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_memory_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <!-- Host Disk -->
        <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset align-items-center metrics">
                    <div class="form-check col-sm-2 d-flex align-items-center">
                        <input type="checkbox" id="disk" class="form-check-input me-2" name="services[disk]" <?= isset($services["disk"]) && $services["disk"] == 'on' ? 'checked="checked"' : '' ?>>
                        <label for="disk" class="form-check-label bold me-2 text-nowrap"><?= _('Disk Usage') ?> <?= xi6_info_tooltip(_("Monitor disk space utilization of the hosts")) ?></label>
                    </div>
                    <div class="col-sm-6 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold % (default=80)')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[disk][warning]" id="disk_warning" value="<?= encode_form_val($serviceargs["disk"]["warning"] ?? 80) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_disk_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold % (default=90)')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[disk][critical]" id="disk_critical" value="<?= encode_form_val($serviceargs["disk"]["critical"] ?? 90) ?>" class="form-control form-control-sm">
                                    <span class="input-group-text">%</span>
                                    <i id="services_disk_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>


        <!-- Custom Metrics -->
        <h3 class="mt-4"><?= _('Custom Metrics') ?></h3>
        <p><?= _('Add additional Prometheus metrics to monitor on your hosts') ?></p>
        <p>Found <?= $parsed_metrics_count ?> metrics</p>
        

        <!-- Search and Select Metrics -->
        <div class="row mb-2">
            <div class="col-sm-12">
                <label for="custom_metric_search" class="form-label">
                    <?= _('Search Metrics:') ?>
                    <?= xi6_info_tooltip(_("Enter a search query and then click 'Select All from Search' to add all matching metrics.")) ?>
                </label>
                <div class="input-group input-group-sm">
                    <div class="col-sm-9">
                        <input type="text" id="custom_metric_search" class="form-control form-control-sm" placeholder="<?= _('Type to search...') ?>" onkeyup="filterMetrics(); updateSelectAllButtonText();">
                        <select style="height: 500px;" name="services-select[]" id="services-select" multiple="" class="form form-control metrics-select multiselect form-select">
                            <?php foreach ($parsed_metrics as $category => $metric): ?>
                                <?php $tooltip = $metric['tooltip']; ?>
                                <?php $type = $metric['metric_type']; ?>
                                <p> <?= escapeHtml($category) ?> </p>
                                <?php foreach ($metric['metrics'] as $name => $value): ?>
                                    <option value="<?= escapeHtml($name) ?>" data-name="<?= escapeHtml($name) ?>" data-value="<?= escapeHtml($value) ?>" data-tooltip="<?= escapeHtml($tooltip) ?>" data-type="<?= escapeHtml($type) ?>" selected><?= escapeHtml($name) ?> | <?= escapeHtml($tooltip) ?> | Type: <?= escapeHtml($type) ?></option>
                                <?php endforeach; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>


        <!-- Select All and Delete Selected Buttons -->
        <div class="row mb-2">
            <div class="col-sm-12 d-flex justify-content-start">
                <button type="button" id="select-all-button" class="btn btn-sm btn-secondary" onclick="selectAllMetrics()"><?= _('Select All') ?></button>
                <button type="button" id="delete-all-button" style="display: none;" class="btn btn-sm btn-secondary" onclick="deleteAllMetrics()"><?= _('Delete Selected') ?></button>
            </div>
        </div>


        <!-- Selected custom metrics box -->                               
        <h3 class="mt-4" id="selected-metrics-header" style="display: none;"><?= _('Selected Metrics') ?></h3>
        <div id="selected-metrics">
            <!-- Add existing custom metrics if going backwards -->
            <?php if (isset($custom_metrics) && is_array($custom_metrics)): ?>
                <?php foreach ($custom_metrics as $index => $metric): ?>
                    <div class="row mb-2 custom-metric">
                        <input type="hidden" name="custom_metrics[<?= $index ?>][name]" class="form-control form-control-sm" value="<?= htmlspecialchars($metric['name'], ENT_QUOTES, 'UTF-8') ?>" required>
                        <div class="col-sm-3">
                            <label class="form-label"><?= _('Service Name:') ?></label>
                            <div class="input-group input-group-sm">
                                <input type="text" name="custom_metrics[<?= $index ?>][label]" class="form-control form-control-sm" value="<?= htmlspecialchars($metric['label'], ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-label"><?= _('Current Value:') ?></label>
                            <div class="input-group input-group-sm">
                                <input type="text" name="custom_metrics[<?= $index ?>][current_value]" class="input-wrap-text form-control form-control-sm" value="<?= htmlspecialchars($metric['current_value'], ENT_QUOTES, 'UTF-8') ?>" readonly>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-label"><?= _('Warning:') ?></label>
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                </span>
                                <input type="text" name="custom_metrics[<?= $index ?>][warning]" class="form-control form-control-sm" value="<?= htmlspecialchars($metric['warning'], ENT_QUOTES, 'UTF-8') ?>" placeholder="Warning Threshold" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-label"><?= _('Critical:') ?></label>
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                </span>
                                <input type="text" name="custom_metrics[<?= $index ?>][critical]" class="form-control form-control-sm" value="<?= htmlspecialchars($metric['critical'], ENT_QUOTES, 'UTF-8') ?>" placeholder="Critical Threshold" required>
                            </div>
                        </div>
                        <div class="col-sm-1 d-flex align-items-end">
                            <button type="button" class="btn btn-sm" onclick="removeCustomMetric(this)"><i class="fa fa-trash"></i></button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>


    <script type="text/javascript">
        function filterMetrics() {
            const input = document.getElementById('custom_metric_search').value.toLowerCase();
            const select = document.getElementById('services-select');
            const options = select.options;

            // Get all selected metric names
            const selectedMetricsDiv = document.getElementById('selected-metrics');
            const selectedMetricNames = Array.from(selectedMetricsDiv.querySelectorAll('input[type="hidden"][name^="custom_metrics"]')).map(input => input.value);

            for (let i = 0; i < options.length; i++) {
                const optionText = options[i].text.toLowerCase();
                const optionValue = options[i].value;
                if (optionText.includes(input) && !selectedMetricNames.includes(optionValue)) {
                    options[i].style.display = '';
                } else {
                    options[i].style.display = 'none';
                }
            }
        }

        function updateSelectAllButtonText() {
            const searchInput = document.getElementById('custom_metric_search').value.trim();
            const selectAllButton = document.getElementById('select-all-button');
            if (searchInput.length > 0) {
                selectAllButton.textContent = "<?= _('Select All from Search') ?>";
            } else {
                selectAllButton.textContent = "<?= _('Select All') ?>";
            }
        }

        document.getElementById('services-select').addEventListener('click', function (e) {
            if (e.target.tagName === 'OPTION') {
                const option = e.target;
                const name = option.dataset.name;
                const value = option.dataset.value;
                const tooltip = option.dataset.tooltip;
                const type = option.dataset.type;
                addCustomMetric(name, value, tooltip, type);
            }
        })

        function addCustomMetric(name, value, tooltip, type) {
            const select = document.getElementById('services-select');
            Array.from(select.options).forEach(option => {
                if (option.value === name) {
                    option.style.display = 'none';
                }
            });

            const selectedMetricsDiv = document.getElementById('selected-metrics');
            const newMetricRow = document.createElement('div');
            newMetricRow.className = 'row mb-2 custom-metric';
            const index = selectedMetricsDiv.getElementsByClassName('custom-metric').length; 
            newMetricRow.innerHTML = `
                <input type="hidden" name="custom_metrics[${index}][name]" class="form-control form-control-sm" value="${name.replace(/"/g, '&quot;')}" required>
                <div class="col-sm-3">
                    <label class="form-label"><?= _('Service Name:') ?></label>
                    <div class="input-group input-group-sm">
                        <input type="text" name="custom_metrics[${index}][label]" class="form-control form-control-sm" value="${name.replace(/"/g, '&quot;')}" required>
                    </div>
                </div>
                <div class="col-sm-2">
                    <label class="form-label"><?= _('Current Value:') ?></label>
                    <div class="input-group input-group-sm">
                        <input type="text" name="custom_metrics[${index}][current_value]" class="form-control form-control-sm" value="${value.replace(/"/g, '&quot;')}" disabled>
                    </div>
                </div>
                <div class="col-sm-2">
                    <label class="form-label"><?= _('Warning:') ?></label>
                    <div class="input-group input-group-sm">
                        <span class="input-group-text">
                            <i class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                        </span>
                        <input type="text" name="custom_metrics[${index}][warning]" class="form-control form-control-sm" required>
                    </div>
                </div>
                <div class="col-sm-2">
                    <label class="form-label"><?= _('Critical:') ?></label>
                    <div class="input-group input-group-sm">
                        <span class="input-group-text">
                            <i class="material-symbols-outlined md-critical md-18 md-400">error</i>
                        </span>
                        <input type="text" name="custom_metrics[${index}][critical]" class="form-control form-control-sm" required>
                    </div>
                </div>
                <div class="col-sm-1 d-flex align-items-end">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeCustomMetric(this)"><i class="fa fa-trash"></i></button>
                </div>
            `;
            selectedMetricsDiv.appendChild(newMetricRow);
        }

        function removeCustomMetric(button) {
            const row = button.closest('.custom-metric');
            const hiddenInput = row.querySelector('input[type="hidden"][name^="custom_metrics"]');
            if (hiddenInput) {
                const metricName = hiddenInput.value;
                const select = document.getElementById('services-select');
                Array.from(select.options).forEach(option => {
                    if (option.value === metricName) {
                        option.style.display = '';
                    }
                });
            }
            row.remove();
        }

        function selectAllMetrics() {
            const select = document.getElementById('services-select');
            const options = select.options;
            
            for (let i = 0; i < options.length; i++) {
                if (options[i].style.display !== 'none') {
                    const name = options[i].value;
                    const value = options[i].getAttribute('data-value');
                    const tooltipAndType = options[i].text.split('|');
                    const tooltip = tooltipAndType[1].trim();
                    const type = tooltipAndType[2].replace('Type:', '').trim();
                    addCustomMetric(name, value, tooltip, type);
                }
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            const selectedMetricsDiv = document.getElementById('selected-metrics');
            const header = document.getElementById('selected-metrics-header');
            const deleteAllButton = document.getElementById('delete-all-button');

            // Hide already selected metrics when moving backwards between steps
            const select = document.getElementById('services-select');
            if (!select) return;
            const selectedMetricNames = Array.from(selectedMetricsDiv.querySelectorAll('input[type="hidden"][name^="custom_metrics"]')).map(input => input.value);
            Array.from(select.options).forEach(option => {
                if (selectedMetricNames.includes(option.value)) {
                option.style.display = 'none';
                }
            });

            function toggleVisibility() {
                if (selectedMetricsDiv.children.length > 0) {
                    header.style.display = 'inline-block';
                    deleteAllButton.style.display = 'inline-block';
                } else {
                    header.style.display = 'none';
                    deleteAllButton.style.display = 'none';
                }
            }
            toggleVisibility();

            const observer = new MutationObserver(toggleVisibility);
            observer.observe(selectedMetricsDiv, { childList: true });
        });

        function deleteAllMetrics() {
            const selectedMetricsDiv = document.getElementById('selected-metrics');
            const rows = selectedMetricsDiv.querySelectorAll('.custom-metric');
            const select = document.getElementById('services-select');
            rows.forEach(row => {
                const hiddenInput = row.querySelector('input[type="hidden"][name^="custom_metrics"]');
                if (hiddenInput) {
                    const metricName = hiddenInput.value;
                    Array.from(select.options).forEach(option => {
                        if (option.value === metricName) {
                            option.style.display = '';
                        }
                    });
                }
            });
            selectedMetricsDiv.innerHTML = '';
        }
    </script>
