<?php
//
// Map Component
// Copyright (c) 2019-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

$map_component_name = "map";

map_init();

/*
 *  Initialize component
 */
function map_init()
{
    global $map_component_name;

    $desc = _('Creates a map map visualization to allow geographic data visualization.');
    if ( !map_check_version() ) {
        $desc = "<b>" . _('Error: This component requires Nagios XI 2024R1.1 or later.') . "</b>";
    }

    $args = array(
        COMPONENT_NAME          => $map_component_name,
        COMPONENT_AUTHOR        => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION   => $desc,
        COMPONENT_TITLE         => _('World Map'),
        COMPONENT_VERSION       => '2.0.0',
        COMPONENT_DATE          => '04/26/2024',
    );

    register_component($map_component_name, $args);

    if ( map_check_version() ) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'map_component_addmenu');
    }
}

/*
 *  Checks to see if the component is compatible with the version of XI
 */
function map_check_version()
{
    if ( function_exists('get_product_release') ) {
        if (get_product_release() >= 60100) {
            return true;
        }
    }
    return false;
}

/*
 *  Adds the index page to the menu
 */
function map_component_addmenu()
{
    global $map_component_name;

    $component_url = get_component_url_base($map_component_name);

    // find the location of menu of network status map
    $menu_section = find_menu_item(MENU_HOME, "menu-home-section-maps", "id");
    if ($menu_section == null) {
        return false;
    }
    $order = grab_array_var($menu_section, "order", "");
    // Make this the top item in the maps section
    $new_order = $order + 0.1;
    if ($new_order < 0) {
        return false;
    }

    add_menu_item(MENU_HOME, array(
        "type"  => "link",
        "title" => _("World Map"),
        "id"    => "menu-home-section-map",
        "order" => $new_order,
        "opts"  => array(
            "href" => $component_url . "/index.php",
            "icon" => "fa-map-marker",
        )
    ));

    add_menu_item(MENU_HOME, array(
        "type"  => "linkspacer",
        "id"    => "menu-home-section-map-spacer",
        "order" => $new_order+0.1
    ));
}
