$(document).ready(function() {

    var light_tile = L.tileLayer('https://cartodb-basemaps-{s}.global.ssl.fastly.net/light_all/{z}/{x}/{y}{r}.png', {
        attribution: '&copy; <a href="http://cartodb.com/attributions">CartoDB</a>',
        subdomains: 'abcd',
        maxZoom: 19
    });

    var dark_tile = L.tileLayer('https://cartodb-basemaps-{s}.global.ssl.fastly.net/dark_all/{z}/{x}/{y}{r}.png', {
        attribution: '&copy; <a href="http://cartodb.com/attributions">CartoDB</a>',
        subdomains: 'abcd',
        maxZoom: 19
    });

    var base_maps = {
        "Light": light_tile,
        "Dark": dark_tile,
    };

    // Customize the Marker Cluster color based on warning severity
    var markerClusterGroup = L.markerClusterGroup.layerSupport(
    {
        iconCreateFunction: function(cluster) {
            var markers = cluster.getAllChildMarkers();
            var n = 0;
            var state_class = 'label-up'; 
            var cluster_state = 0;
            for (var i = 0; i < markers.length; i++) {
                if (cluster_state < markers[i].options.currentState) {
                    cluster_state = markers[i].options.currentState;
                    state_class = markers[i].options.stateClass; // Determines marker color
                }
                n++;
            }
            return L.divIcon({ 
                html:'<div><span>' + n + '</span></div>', 
                className: 'marker-cluster ' + state_class, 
                iconSize: L.point(40, 40) 
            });
        },
    }
    );
    
    var hostuptimegroup = L.layerGroup();
    var hostdowntimegroup = L.layerGroup();
    var servicegroup = L.layerGroup();

    // Refresh interval in seconds
    var interval = 30;

    load_markers();
    setInterval(load_markers, interval * 1000);

    function load_markers() {

        // Grab host data
        $.ajax({
            url: 'map.api.php',
            type: 'POST',
            data: { mode: 'hosts'},
            success: function(data) {
                hosts = JSON.parse(data);

                hostuptimegroup.clearLayers();
                hostdowntimegroup.clearLayers();

                for (var key in hosts) {
                    if (hosts[key]['latitude'] && hosts[key]['longitude']) {

                        var latitude = hosts[key]['latitude'];
                        var longitude = hosts[key]['longitude'];
                        var name = hosts[key]['name'];
                        var host_name = hosts[key]['host_name'];
                        var status_text = hosts[key]['status_text'];
                        var icon = hosts[key]['icon'];
                        var state_text = hosts[key]['state_text'];
                        var state_class = hosts[key]['state_class'];
                        var in_downtime = hosts[key]['in_downtime'];
                        var current_state = hosts[key]['current_state'];

                        var detail_url = '<a href="../xicore/status.php?show=hostdetail&host=' + host_name + '">Host Details</a>';

                        var newIcon = L.icon({
                            iconUrl: icon,
                            shadowUrl: 'library/leaflet/images/marker-shadow.png',
                            iconSize: [25, 41],
                            iconAnchor: [13, 41],
                            popupAnchor: [0, -40],
                            shadowAnchor: [15, 40],
                        });

                        var popup = 
                            '<h4>' + name  + '</h4>' + 
                            '<div class="status-text">' + 
                                '<span class="label ' + state_class + '">' + 
                                    state_text + 
                                '</span>' + 
                            '</div>' + 
                            '<div class="status-text">' + 
                                status_text + 
                            '</div>' + 
                            '<div>' + detail_url + '</div>';
                        var marker = L.marker([latitude, longitude], 
                            { 
                                icon: newIcon, 
                                name: name, 
                                hostName: host_name, 
                                currentState: current_state,
                                stateClass: state_class,
                                stateText: state_text,
                            });

                        marker.bindPopup(popup);
                        marker.on('mouseover', function(e) {
                            this.openPopup();
                        });
                        marker.on('focusout', function(e) {
                            setTimeout(() => { this.closePopup() }, 1250);
                        });

                        if (in_downtime === true) {
                            marker.addTo(hostdowntimegroup);
                        } else {
                            marker.addTo(hostuptimegroup);
                        }
                    }
                }
            },
            failure: function(xhr, error_string, error_thrown) {
                alert("Error loading markers");
            },
        });

        // Grab service data
        $.ajax({
            url: 'map.api.php',
            type: 'POST',
            data: { mode: 'services'},
            success: function(data) {
                services = JSON.parse(data);

                servicegroup.clearLayers();

                for (var key in services) {
                    if (services[key]['latitude'] && services[key]['longitude']) {

                        var latitude            = services[key]['latitude'];
                        var longitude           = services[key]['longitude'];
                        var name                = services[key]['name'];
                        var id                  = services[key]['service_id'];
                        var host_name           = services[key]['host_name'];
                        var service_description = services[key]['service_description'];
                        var status_text         = services[key]['status_text'];
                        var icon                = services[key]['icon'];
                        var state_text          = services[key]['state_text'];
                        var state_class         = services[key]['state_class'];
                        var current_state       = services[key]['current_state'];

                        var detail_url = '<a href="../xicore/status.php?show=servicedetail&host=' + host_name + '&service=' + service_description + '">Service Details</a>';

                        var newIcon = L.icon({
                            iconUrl: icon,
                            shadowUrl: 'library/leaflet/images/marker-shadow.png',
                            iconSize: [25, 41],
                            iconAnchor: [13, 41],
                            popupAnchor: [0, -40],
                            shadowAnchor: [15, 40],
                        });
        
                        var popup = 
                            '<h4>' + name  + '</h4>' + 
                                '<div class="status-text">' + 
                                    '<span class="label ' + state_class + '">' + 
                                        state_text + 
                                    '</span>' + 
                                '</div>' + 
                                '<div class="status-text">' + 
                                    status_text + 
                                '</div>' + 
                                '<div>' + detail_url + '</div>';
                        var marker = L.marker([latitude, longitude], { 
                            icon: newIcon, 
                            name: name, 
                            hostName: host_name, 
                            currentState: current_state,
                            stateClass: state_class,
                            stateText: state_text,
                        });

                        marker.bindPopup(popup);
                        marker.on('mouseover', function(e) {
                            this.openPopup();
                        });
                        marker.on('focusout', function(e) {
                            setTimeout(() => { this.closePopup() }, 1250);
                        });
                        marker.addTo(servicegroup);
                    }
                }

            },
            failure: function(xhr, error_string, error_thrown) {
                alert("Error loading markers");
            },
        });
    }

    selected_layer = light_tile;
    if (tile_selected == 'dark') {
        selected_layer = dark_tile;
    }

    map = L.map('map_container', {
        center: default_coords,
        zoom: 10,
        layers: [selected_layer]
    });


    // Setup controller (set base map tiles overlay)
    var control = L.control.layers(base_maps, null, {position: 'topleft'}).addTo(map);

    // Add only the groups to the overlay so we can select them
    control.addOverlay(hostuptimegroup, 'Hosts (uptime)');
    control.addOverlay(hostdowntimegroup, 'Hosts (downtime)');
    control.addOverlay(servicegroup, 'Services');

    // Group everything up
    markerClusterGroup.checkIn([hostuptimegroup, hostdowntimegroup, servicegroup]);

    // Add everything to the map
    hostuptimegroup.addTo(map);
    hostdowntimegroup.addTo(map);
    servicegroup.addTo(map);
    markerClusterGroup.addTo(map);

    var markerLayers = L.layerGroup([
        hostuptimegroup,
        hostdowntimegroup,
    ])
    .addTo(map);

    L.control.search({
		layer: markerLayers,
		initial: false,
        marker: false,
		propertyName: 'hostName',
	})
	.addTo(map);
});
