$(document).ready(function() {
	var favorites_ajax = base_url + 'includes/components/favorites/favorites_ajax.php';
	$('.favorites_icon').click(function() {

		// Get iframe url - we're inside the iframe so this is just window.
		var href = window.location.href;
		var partial_href = href.split(base_url).join('').replace(/\?&/, "\?"); //The replace removes &'s after ?'s

		// Check for session token and replace it with a blank token
		partial_href = partial_href.replace(/&nsp=[^&]*/, '&nsp=');

		// Same goes for the interior title - just refer to document
		var title = document.title;
		title = title.split(' · Nagios XI').join('');

		// Check to see if item partial href exists	
		var mode = { mode: "get" };
		$.get(favorites_ajax, mode, function(data) {
			// Switch to control whether to add menu item or delete a duplicate
			var is_duplicate = false;
			var item_id = "";
		
			data.forEach(function (element) {
				if(element.partial_href === partial_href) {
					item_id = element.item_id;
					is_duplicate = true;
				}
			})
			
			// To unfavorite a page, we are checking if there is a duplicate item and then removing it from favorites
			if (is_duplicate){
				var mode = { 
					mode: 'edit',
					nsp: nsp_str,
					["item["+item_id+"]"]: "*DELETED*",
				};
				$.post(favorites_ajax, mode, function() {
					favorites_redraw_menu(window.parent, document);
				}, 'json');
			}

			// Else add the menu item
			else {
				/* Now send this to the database */
				var query = { partial_href: partial_href, title: title, mode: 'add', nsp: nsp_str };
				$.post(favorites_ajax, query, function() {
					favorites_redraw_menu(window.parent, document);
				}, 'json');
			}
		}, 'json');


	});

	$('.favorites_manage').click(function(e) {
		e.stopPropagation();

		var menusections = $(this).parent().parent().children('.menusection');
		
		menusections.children('.menulink').hide();
		menusections.children('.favorites_hidden_form').children('li').children('input').each(function() {
			$(this).attr('value', $(this).data('original-value'));
			$(this).parent().show();
		});
		menusections.children('.favorites_hidden_form').show();

		$(this).hide();
		$(this).next().show();
		$(this).next().next().show();
	});

	$('.favorites_save').click(function(e) {
		e.stopPropagation();
		var query = $(this).parent().parent().children().children('.favorites_hidden_form').serialize();
		var mode = { mode: 'edit', nsp: nsp_str };
		$.post(favorites_ajax + '?' + query, mode, function() {
			favorites_redraw_menu(window, $('#maincontentframe').contents()[0]);
		}, 'json');
	});

	$('.favorites_cancel').click(function(e) {
		e.stopPropagation();

		var menusections = $(this).parent().parent().children('.menusection');

		menusections.children('.menulink').show();
		menusections.children('.favorites_hidden_form').hide();

		$(this).hide();
		$(this).next().hide();
		$(this).prev().show();
	});

	$('.favorites_delete').click(function(e) {
		e.stopPropagation();
		$(this).parent().hide();
		var preceding_input = $(this).prev();
		preceding_input.attr('value', '*DELETED*');
	});

	function favorites_redraw_menu(exterior_window, interior_document) {
		var url = interior_document.location.pathname+interior_document.location.search+interior_document.location.hash
		var base = exterior_window.location.pathname;
		
		if (is_neptune()) {
			window.parent.location.href = base + "?xiwindow="+encodeURIComponent(url);
		} else {
			//Removes & before ? in the url
			var cleanSearch = interior_document.location.search.replace(/\?&/, "\?")
			url = interior_document.location.pathname + cleanSearch + interior_document.location.hash;
			window.parent.location.href = base + "?xiwindow="+encodeURIComponent(url);
		}
	}
});