<?php
//
// Mac OS X Config Wizard
// Copyright (c) 2012-2024 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

macosx_configwizard_init();

function macosx_configwizard_init()
{
    $name = "macosx";
    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "3.0.0",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => _("Monitor a Mac OS X machine."),
        CONFIGWIZARD_DISPLAYTITLE => "Mac OS X",
        CONFIGWIZARD_FUNCTION => "ncpa_configwizard_func",
        CONFIGWIZARD_FUNCTION_ARGS => array('os' => 'osx', 'defaults' => 'server'),
        CONFIGWIZARD_PREVIEWIMAGE => "osx.png",
        CONFIGWIZARD_FILTER_GROUPS => array('otheros', 'mac', 'osx'),
        CONFIGWIZARD_REQUIRES_VERSION => 60100
    );
    register_configwizard($name, $args);
}
