    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="osversion" value="<?= encode_form_val($osversion) ?>">
    <input type="hidden" name="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>">
    <input type="hidden" name="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="snmpopts_serial" value="<?= base64_encode(json_encode($snmpopts)) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Windows Machine Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name:') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this Windows machine.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
<?php
    // Error if snmpwalk failed.
    if ($walksuccess == 0) {
?>
        <div class="alert alert-danger">
            <div class="align-items-center d-flex pb-3">
                <i class="material-symbols-outlined md-400">warning</i>
                <span class="fw-bold pe-2">
                    <?= _('The wizard detected that this server does not have snmpwalk permission on the target host.') ?>
                </span>
            </div>
            <div class="card card-p">
                <?= _('This will prevent the automatic scan of services and processes and prevent services from running successfully, but you can continue with the wizard manually. To troubleshoot this ensure that these OIDs are available on the target host: \"HOST-RESOURCES-MIB::hrStorageDescr\", \"SNMPv2-SMI::enterprises.77.1.2.3.1.1\" and \"HOST-RESOURCES-MIB::hrSWRunName\"') ?>
            </div>
        </div>
<?php
    }
?>
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the Windows machine') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="p" class="form-check-input" name="services[ping]"  <?= is_checked($services['ping'], "1") ?> >
                        <label for="p" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the machine with an ICMP \"ping\". Useful for watching network latency and general uptime.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="cpu" class="form-check-input" name="services[cpu]"  <?= is_checked($services['cpu'], "1") ?> >
                        <label for="cpu" class="form-check-label bold"><?= _('CPU') ?> <?= xi6_info_tooltip(_("Monitors the CPU (processor usage) on the machine.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[cpu_warning]" name="serviceargs[cpu_warning]" value="<?= encode_form_val($serviceargs['cpu_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_cpu_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[cpu_critical]" name="serviceargs[cpu_critical]" value="<?= encode_form_val($serviceargs['cpu_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_cpu_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="pmu" class="form-check-input" name="services[memory]"  <?= is_checked($services['memory'], "1") ?> >
                        <label for="pmu" class="form-check-label bold"><?= _('Physical Memory Usage') ?> <?= xi6_info_tooltip(_("Monitors the physical (real) memory usage on the machine.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[memory_warning]" name="serviceargs[memory_warning]" value="<?= encode_form_val($serviceargs['memory_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_memory_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[memory_critical]" name="serviceargs[memory_critical]" value="<?= encode_form_val($serviceargs['memory_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_memory_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="vmu" class="form-check-input" name="services[pagefile]"  <?= is_checked($services['pagefile'], "1") ?> >
                        <label for="vmu" class="form-check-label bold"><?= _('Virtual Memory Usage') ?> <?= xi6_info_tooltip(_("Monitors the virtual memory usage on the machine.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[pagefile_warning]" name="serviceargs[pagefile_warning]" value="<?= encode_form_val($serviceargs['pagefile_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_pagefile_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[pagefile_critical]" name="serviceargs[pagefile_critical]" value="<?= encode_form_val($serviceargs['pagefile_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_pagefile_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="col-sm-8 border-block">
            <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0 pt-1">
                            <input type="checkbox" id="du" class="form-check-input" name="services[disk]" <?= is_checked($services['disk'], "1") ?>>
                            <label for="du" class="form-check-label bold"><?= _('Disk Usage') ?> <?= xi6_info_tooltip(_("Monitors disk usage on the machine.")) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    if (!empty($disk)) {
?>
            <div class="ms-4 alert alert-primary"><?= _('The wizard will populate detected drives automatically. To add more drives select a new drive from the dropdown list.') ?></div>
            <div class="adddeleterow diskList">
<?php
    }

    if (isset($serviceargs["disk"]) && is_array($serviceargs["disk"])) {
        for ($x = 0; $x < count($serviceargs["disk"]); $x++) {
            $checkedstr = "";

            if ($x == 0) {
                $checkedstr = "checked";
            }
            ?>
            <div class="row <?= ($x < 1) ? 'pt-2' : '' ?>">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <span class="form-label m-0 ms-1 align-middle"><?= _('Drive') ?></span>
                                </span>
                                <select name="serviceargs[disk][<?= $x ?>]" class="form-control form-select form-select-sm">
                                    <option value=""></option>
                                    <?php
                                    for ($y = 0; $y < 26; $y++) {
                                        $selected = "";
                                        $diskname = chr(ord('A') + $y);
                                        $selected = is_selected($serviceargs["disk"][$x], $diskname);
                                        ?>
                                        <option value="<?= $diskname ?>" <?= $selected ?>><?= $diskname ?>:</option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <i id="serviceargs_disk_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[disk_warning][<?= $x ?>]" name="serviceargs[disk_warning][<?= $x ?>]" value="<?= encode_form_val($serviceargs['disk_warning'][$x]) ?>" class="form-control form-control-sm rounded monitor">
                                <span class="input-group-text">%</span>
                                <i id="serviceargs_disk_warning_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[disk_critical][<?= $x ?>]" name="serviceargs[disk_critical][<?= $x ?>]" value="<?= encode_form_val($serviceargs['disk_critical'][$x]) ?>" class="form-control form-control-sm monitor">
                                <span class="input-group-text">%</span>
                                <i id="serviceargs_disk_critical_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
            <?php
        }
    }
    ?>
            </div> <!-- adddeleterow diskList -->
        </div> <!-- border-block -->

        <h2 class="mt-4"><?= _('Services') ?></h2>
        <p><?= _('Specify any services that should be monitored to ensure they are in a running state') ?><br><strong>Note:</strong> <?= _('The Windows Service name must match the full name of the service you want to monitor.') ?></p>

<?php
    // show message if service data available
    if (!empty($w_services)) {
?>
        <div class="ms-4 w-50 alert alert-primary"><?= _('The SNMP wizard detected ').$service_count._(' services on ').$hostname ?></div>
<?php
    }
?>
        <div class="serviceList">
            <div class="position-relative adddeleterow">
                 <div class="row">
                    <div class="col-sm-8">
                        <fieldset class="row">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm ms-2 ps-1">
                                    <label class="form-check-label bold"><?= _('Windows Service') ?></label>
                                </div>
                            </div>
                            <div class="col-sm-5 form-label bold">
                                <label class="form-check-label bold ps-2"><?= _('Display Name') ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    for ($x = 0; $x < count($serviceargs['servicestate']); $x++) {
        $servicestring = encode_form_val($serviceargs['servicestate'][$x]['service']);
        $servicename = encode_form_val($serviceargs['servicestate'][$x]['name']);
        $is_checked = isset($services['servicestate'][$x]) ? is_checked($services['servicestate'][$x]) : '';
?>
                 <div class="row">
                    <div class="col-sm-8">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[servicestate][<?= $x ?>]" class="form-check-input mt-2 me-2" name="services[servicestate][<?= $x ?>]" <?= $is_checked ?>>
                                    <input type="text" id="serviceargs[servicestate][<?= $x ?>][service]" name="serviceargs[servicestate][<?= $x ?>][service]" value="<?= $servicestring ?>" class="form-control form-control-sm rounded monitor" autocomplete="windows_service">
                                    <i id="serviceargs_servicestate_<?= $x ?>_service_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-5 mt-0">
                                <input type="text" id="serviceargs[servicestate][<?= $x ?>][name]" name="serviceargs[servicestate][<?= $x ?>][name]" value="<?= $servicename ?>" class="form-control form-control-sm monitor" autocomplete="service_display_name">
                                <i id="serviceargs_servicestate_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </fieldset>
                    </div>
                    <div class="col-sm-4">
<?php
    // only display select box if we have services to display
    if (!empty($w_services) && $x < 1) {
?>
                        <div class="col-sm-4 position-absolute top-0 start-50">
                            <label for="serviceList" class="form-label bold ms-4 mt-2"><?= _("Scanned Service List &nbsp; (Service Name (Display Name) Status)") ?></label>
                            <select multiple="multiple" size="7" id="serviceList" class="form-control form-control-sm form-select form-select-sm mb-2"></select>
                            <a href="#" onClick="return false;" id="addServ" class="btn btn-link">Add Selected</a> | <a href="#" onClick="return false;" name="selectAll" class="btn btn-link">Select All</a>
                        </div>
<?php
    }
?>
                    </div>
                </div>
<?php
    }
?>
            </div>  <!-- adddeleterow -->
        </div>  <!-- serviceList -->

        <h2 class="mt-4"><?= _('Processes') ?></h2>
        <p><?= _('Specify any processes that should be monitored to ensure they are running') ?><br><strong>Note:</strong> <?= _('Process names are case-sensitive') ?></p>
<?php
    // show message if process data available
    if (!empty($process)) {
?>
        <div class="ms-4 w-50 alert alert-primary"><?= _('The SNMP wizard detected ').$process_count._(' processes on ').$hostname ?></div>
<?php
    }
?>
        <div class="processList">
            <div class="position-relative adddeleterow">
                 <div class="row">
                    <div class="col-sm-8">
                        <fieldset class="row">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm ms-2 ps-1">
                                    <label class="form-check-label bold"><?= _('Windows Process') ?></label>
                                </div>
                            </div>
                            <div class="col-sm-5 form-label bold">
                                <label class="form-check-label bold ps-2"><?= _('Display Name') ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    for ($x = 0; $x < count($serviceargs['processstate']); $x++) {
        $processstring = encode_form_val($serviceargs['processstate'][$x]['process']);
        $processname = encode_form_val($serviceargs['processstate'][$x]['name']);
        $is_checked = isset($services['processstate'][$x]) ? is_checked($services['processstate'][$x]) : '';
?>
                <div class="row">
                    <div class="col-sm-8">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[processstate][<?= $x ?>]" class="form-check-input mt-2 me-2" name="services[processstate][<?= $x ?>]" <?= $is_checked ?>>
                                    <input type="text" id="serviceargs[processstate][<?= $x ?>][process]" name="serviceargs[processstate][<?= $x ?>][process]" value="<?= $processstring ?>" class="form-control form-control-sm rounded monitor" autocomplete="windows_process">
                                    <i id="serviceargs_processstate_<?= $x ?>_process_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-5 mt-0">
                                <input type="text" id="serviceargs[processstate][<?= $x ?>][name]" name="serviceargs[processstate][<?= $x ?>][name]" value="<?= $processname ?>" class="form-control form-control-sm monitor" autocomplete="process_display_name">
                                <i id="serviceargs_processstate_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </fieldset>
                    </div>
                    <div class="col-sm-4">
<?php
    // only display select box if we have processes to display
    if (!empty($process) && $x < 1) {
?>
                        <div class="col-sm-4 position-absolute top-0 start-50">
                            <label for="processList" class="form-label bold ms-4 mt-2"><?= _("Scanned Process List") ?></label>
                            <select multiple="multiple" size="7" id="processList" class="form-control form-control-sm form-select form-select-sm mb-2"></select>
                            <a href="#" onClick="return false;" id="addProc" class="btn btn-link">Add Selected</a> | <a href="#" onClick="return false;" name="selectAll" class="btn btn-link">Select All</a>
                        </div>
<?php
    }
?>
                    </div>
                </div>
<?php
    }
?>
            </div>  <!-- adddeleterow -->
        </div>  <!-- processList -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function () {
            wizard_populate();

            var proccount = 0;
            var servcount = 0;

            // smart process selecter
            $("#addProc").click(function() {
                var element = "";
                var element = $("#processList option:selected");
                var selected = element.length;
                var value = element.text();

                row_count = get_empty_field_count("process");

                if (selected > row_count) {
                    row_count = get_empty_field_count("process");

                    // count how many rows we need to trigger
                    var create_inputs = selected - row_count;

                    for (i = 0; i < create_inputs; i++) {
                        $(".processList").find("a.wizard-add-row").trigger("click");
                    }
                }

                if (selected > 1) {
                    $.each(element, function() {
                        value = $(this).html();
                        $(this).remove();

                        // find empty input
                        target = $("[name^='serviceargs[processstate][" + proccount + "][process]']").filter(function() { return $(this).val() == ""; });
                        target.val(value);
                        targetdisplay = $("[name^='serviceargs[processstate][" + proccount + "][name]']").filter(function() { return $(this).val() == ""; });
                        targetdisplay.val(value);
                        target.closest("td").next("td").children("input").val(value);

                        proccount++;
                    });

                    check_box_with_value();
                } else {
                    element.remove();
                    target = target[0];
                    target = target["name"];

                    $("[name=" + "'" + target + "'" + "]").val(value);
                    $("[name=" + "'" + target + "'" + "]").closest("td").next("td").children("input").val(value);

                    proccount++;
                    check_box_with_value();
                }
            });

            // allow single double-click selector as well
            $("#processList").on("dblclick", "option", function() {
                var element = "";
                var element = $("#processList option:selected");
                var selected = element.length;
                var value = element.text();
                element.remove();

                row_count = get_empty_field_count("process");

                // add row if needed
                if (row_count < 1) {
                    $(".processList").find("a.wizard-add-row").trigger("click");
                }

                // find empty input
                target = $("[name^='serviceargs[processstate][" + proccount + "][process]']").filter(function() { return $(this).val() == ""; });
                target.val(value);
                targetdisplay = $("[name^='serviceargs[processstate][" + proccount + "][name]']").filter(function() { return $(this).val() == ""; });
                targetdisplay.val(value);
                target.closest("td").next("td").children("input").val(value);

                $("[name=" + "'" + target + "'" + "]").val(value);
                $("[name=" + "'" + target + "'" + "]").closest("td").next("td").children("input").val(value);

                proccount++;
                check_box_with_value();
            });

            // smart service selecter
            $("#addServ").click(function() {
                var element = "";
                var element = $("#serviceList option:selected");
                var selected = element.length;
                var value = element.text();

                var count = 0;
                row_count = get_empty_field_count("service");

                if (selected > row_count) {
                    row_count = get_empty_field_count("service");

                    // count how many rows we need to trigger
                    var create_inputs = selected - row_count;

                    for (i = 0; i < create_inputs; i++) {
                        $(".serviceList").find("a.wizard-add-row").trigger("click");
                    }
                }

                if (selected > 1) {
                    $.each(element, function() {
                        var servicename = "";
                        var displayname = "";
                        value = $(this).html();
                        $(this).remove();

                        servicename = value.split(" (", 1);
                        var displayname = $(this).val();

                        // find empty input
                        targetservice = $("[name^='serviceargs[servicestate][" + servcount + "][name]']").filter(function() { return $(this).val() == ""; });
                        targetservice.val(servicename);
                        targetdisplay = $("[name^='serviceargs[servicestate][" + servcount + "][service]']").filter(function() { return $(this).val() == ""; });
                        targetdisplay.val(displayname);

                        servcount++;
                    });

                    check_box_with_value();

                } else {
                    element.remove();
                    var servicename = value.split(" (", 1);
                    var displayname = element.val();

                    var targetservice = $("[name^='serviceargs[servicestate]'][name$='[name]']").filter(function() { return $(this).val() == "";});
                    targetservice = targetservice[0];
                    targetservice = targetservice["name"];

                    var targetdisplay = $("[name^='serviceargs[servicestate]'][name$='[service]']").filter(function() { return $(this).val() == "";});
                    targetdisplay = targetdisplay[0];
                    targetdisplay = targetdisplay["name"];

                    $("[name=" + "'" + targetservice + "'" + "]").val(servicename);
                    $("[name=" + "'" + targetdisplay + "'" + "]").val(displayname);

                    servcount++;
                    check_box_with_value();
                }
            });

            // allow single double-click selector
            $("#serviceList").on("dblclick", "option", function() {
                var element = "";
                var element = $("#serviceList option:selected");
                var selected = element.length;
                var value = element.text();
                var servicename = value.split(" (", 1);
                var displayname = element.val();
                element.remove();

                row_count = get_empty_field_count("service");

                // add row if needed
                if (row_count < 1) {
                    var tmp1 = $(".serviceList");
                    var tmp2 = $(".serviceList").find("a.wizard-add-row");
                    $(".serviceList").find("a.wizard-add-row").trigger("click");
                }

                // find empty input
                var targetdisplay = $("[name^='serviceargs[servicestate]']").filter(":even").filter(function() { return $(this).val() == ""; });
                targetdisplay = targetdisplay[0];
                targetdisplay = targetdisplay["name"];

                var targetservice = $("[name^='serviceargs[servicestate]']").filter(":odd").filter(function() { return $(this).val() == ""; });
                targetservice = targetservice[0];
                targetservice = targetservice["name"];

                $("[name=" + "'" + targetservice + "'" + "]").val(servicename);
                $("[name=" + "'" + targetdisplay + "'" + "]").val(displayname);

                servcount++;
                check_box_with_value();
            });
        });

        // Select all button
        $("[name=selectAll]").click(function() {
            $(this).parent().find("select option").prop('selected', true);
        });

        function wizard_populate() {
            var servicelist = [<?= $w_services ?>];
            servicelist.sort(function (a, b) {
                return a.toLowerCase().localeCompare(b.toLowerCase());
            });

            var proclist = [<?= $process ?>];
            proclist.sort(function (a, b) {
                return a.toLowerCase().localeCompare(b.toLowerCase());
            });

            var service_select = $("#serviceList");
            $.each(servicelist, function(key, value) {
                service_select.append($("<option></option>").attr("value", value).text(value));
            });

            var process_select = $("#processList");
            $.each(proclist, function(key, value) {
                process_select.append($("<option></option>").attr("value", key).text(value));
            });
        }

        function get_empty_field_count(type) {
            var input = "";
            target = "";

            // target the correct servicetype name
            if (type == "service") {
                input = "servicestate";
            } else if (type == "process") {
                input = "processstate";
            } else {
                input = "eventlog";
            }

            // find empty input fields
            target = $("[name^='serviceargs[" + input + "]']").filter(":even").filter(function() { return $(this).val() == ""; });
            var row_count = target.length;

            return row_count;
        }

        // make sure checkboxes are checked
        function check_box_with_value() {
            var servicetargets = $("input[name^='serviceargs[servicestate]']").filter(":even").filter(function() { return $(this).val() !== ""; });
            var processtargets = $("input[name^='serviceargs[processstate]']").filter(":even").filter(function() { return $(this).val() !== ""; });

            $.each(servicetargets, function() {
                $(this).parent().find("input[type=checkbox]").attr("checked", true);
            });

            $.each(processtargets, function() {
                $(this).parent().find("input[type=checkbox]").attr("checked", true);
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
