# Allowed commands for each domain
ALLOWED_COMMANDS = {
    "VM": {
        "CPU": {
            "USAGE": {
                "counterId": "cpu.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "cpu_usage",
            },
            "USAGEMHZ": {
                "counterId": "cpu.usagemhz.average",
                "unit": "MHz",
                "type": float,
                "output_name": "UsageMHz",
                "perfdata_name": "cpu_usagemhz",
            },
            "WAIT": {
                "counterId": "cpu.wait.summation",
                "unit": "ms",
                "type": float,
                "output_name": "Wait",
                "perfdata_name": "cpu_wait",
            },
            "READY": {
                "counterId": "cpu.ready.summation",
                "unit": "ms",
                "type": float,
                "output_name": "Ready",
                "perfdata_name": "cpu_ready",
            },
        },
            # mem_pct = round(GetPerfResults("mem.usage.average", vm) / 100, 2)
    # mem_active = cfb(ctb(GetPerfResults("mem.active.average", vm), "KB"), args.unit)
    # mem_overhead = cfb(ctb(GetPerfResults("mem.overhead.average", vm), "KB"), args.unit)
    # mem_swapped = cfb(ctb(GetPerfResults("mem.swapped.average", vm), "KB"), args.unit)
    # mem_swapin = cfb(ctb(GetPerfResults("mem.swapin.average", vm), "KB"), args.unit)
    # mem_swapout = cfb(ctb(GetPerfResults("mem.swapout.average", vm), "KB"), args.unit)
    # mem_consumed = cfb(ctb(GetPerfResults("mem.consumed.average", vm), "KB"), args.unit)
    # mem_memctl = cfb(ctb(GetPerfResults("mem.vmmemctl.average", vm), "KB"), args.unit)
        "MEM": {
            "USAGE": {
                "counterId": "mem.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "mem_usage",
            },
            "USAGE<UNITS>": {
                "counterId": "mem.usage.average",
                "unit": "MB",
                "type": float,
                "output_name": "Usage<UNITS>",
                "perfdata_name": "mem_usage<UNITS>",
            },
            "SWAP": {
                "counterId": "mem.swapped.average",
                "unit": "MB",
                "type": float,
                "output_name": "Swap",
                "perfdata_name": "mem_swap",
            },
            "OVERHEAD": {
                "counterId": "mem.overhead.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overhead",
                "perfdata_name": "mem_overhead",
            },
            "ACTIVE": {
                "counterId": "mem.active.average",
                "unit": "MB",
                "type": float,
                "output_name": "Active",
                "perfdata_name": "mem_active",
            },
            "MEMCTL": {
                "counterId": "mem.vmmemctl.average",
                "unit": "MB",
                "type": float,
                "output_name": "MemCtl",
                "perfdata_name": "mem_memctl",
            },
        },
        "NET": {
            "USAGE": {
                "counterId": "net.usage.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "net_usage",
            },
            "RECEIVE": {
                "counterId": "net.received.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Receive",
                "perfdata_name": "net_receive",
            },
            "SEND": {
                "counterId": "net.transmitted.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Send",
                "perfdata_name": "net_send",
            },
        },
        "IO": {
            "USAGE": {
                "counterId": "disk.usage.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "disk_usage",
            },
            "READ": {
                "counterId": "disk.read.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Read",
                "perfdata_name": "disk_read",
            },
            "WRITE": {
                "counterId": "disk.write.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Write",
                "perfdata_name": "disk_write",
            },
        },
        "RUNTIME": {
            "CON": {
                "counterId": "runtime.connectionState",
                "unit": "",
                "type": str,
                "output_name": "ConnectionState",
                "perfdata_name": "runtime_con",
            },
            "CPU": {
                "counterId": "runtime.maxCpuUsage",
                "unit": "MHz",
                "type": int,
                "output_name": "CPU",
                "perfdata_name": "runtime_cpu",
            },
            "MEM": {
                "counterId": "runtime.maxMemoryUsage",
                "unit": "MB",
                "type": int,
                "output_name": "MEM",
                "perfdata_name": "runtime_mem",
            },
            "STATE": {
                "counterId": "runtime.powerState",
                "unit": "",
                "type": str,
                "output_name": "State",
                "perfdata_name": "runtime_state",
            },
            "STATUS": {
                "counterId": "runtime.overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Status",
                "perfdata_name": "runtime_status",
            },
            "CONSOLECONNECTIONS": {
                "counterId": "runtime.consoleConnections",
                "unit": "",
                "type": int,
                "output_name": "ConsoleConnections",
                "perfdata_name": "runtime_consoleconnections",
            },
            "GUEST": {
                "counterId": "guest.guestState",
                "unit": "",
                "type": str,
                "output_name": "Guest",
                "perfdata_name": "runtime_guest",
            },
            "TOOLS": {
                "counterId": "guest.toolsStatus",
                "unit": "",
                "type": str,
                "output_name": "Tools",
                "perfdata_name": "runtime_tools",
            },
            "ISSUES": {
                "counterId": "triggeredAlarmState",
                "unit": "",
                "type": str,
                "output_name": "Issues",
                "perfdata_name": "runtime_issues",
            },
        },
    },
    "HOST": {
        "CPU": {
            "USAGE": {
                "counterId": "cpu.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "cpu_usage",
            },
            "USAGEMHZ": {
                "counterId": "cpu.usagemhz.average",
                "unit": "MHz",
                "type": float,
                "output_name": "UsageMHz",
                "perfdata_name": "cpu_usagemhz",
            },
        },
        "MEM": {
            "USAGE": {
                "counterId": "mem.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "mem_usage",
            },
            "USAGEMB": {
                "counterId": "mem.usage.average",
                "unit": "MB",
                "type": float,
                "output_name": "UsageMB",
                "perfdata_name": "mem_usagemb",
            },
            "SWAP": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "Swap",
                "perfdata_name": "mem_swap",
            },
            "SWAPIN": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapIn",
                "perfdata_name": "mem_swapin",
            },
            "SWAPOUT": {
                "counterId": "mem.swapoutRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapOut",
                "perfdata_name": "mem_swapout",
            },
            "OVERHEAD": {
                "counterId": "mem.overhead.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overhead",
                "perfdata_name": "mem_overhead",
            },
            "OVERALL": {
                "counterId": "mem.overallUsage.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overall",
                "perfdata_name": "mem_overall",
            },
            "MEMCTL": {
                "counterId": "mem.vmmemctl.average",
                "unit": "MB",
                "type": float,
                "output_name": "MemCtl",
                "perfdata_name": "mem_memctl",
            },
        },
        "NET": {
            "USAGE": {
                "counterId": "net.usage.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "net_usage",
            },
            "RECEIVE": {
                "counterId": "net.received.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Receive",
                "perfdata_name": "net_receive",
            },
            "SEND": {
                "counterId": "net.transmitted.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Send",
                "perfdata_name": "net_send",
            },
        },
        "IO": {
            "ABORTED": {
                "counterId": "disk.aborted.summation",
                "unit": "",
                "type": int,
                "output_name": "Aborted",
                "perfdata_name": "disk_aborted",
            },
            "RESETS": {
                "counterId": "disk.reset.summation",
                "unit": "",
                "type": int,
                "output_name": "Resets",
                "perfdata_name": "disk_resets",
            },
            "READ": {
                "counterId": "disk.read.average",
                "unit": "ms",
                "type": float,
                "output_name": "Read",
                "perfdata_name": "disk_read",
            },
            "WRITE": {
                "counterId": "disk.write.average",
                "unit": "ms",
                "type": float,
                "output_name": "Write",
                "perfdata_name": "disk_write",
            },
            "KERNEL": {
                "counterId": "disk.kernelLatency.average",
                "unit": "ms",
                "type": float,
                "output_name": "Kernel",
                "perfdata_name": "disk_kernel",
            },
            "DEVICE": {
                "counterId": "disk.deviceLatency.average",
                "unit": "ms",
                "type": float,
                "output_name": "Device",
                "perfdata_name": "disk_device",
            },
            "QUEUE": {
                "counterId": "disk.queueLatency.average",
                "unit": "ms",
                "type": float,
                "output_name": "Queue",
                "perfdata_name": "disk_queue",
            },
        },
        "VMFS": {
            "FREE": {
                "counterId": "datastore.freeSpace",
                "unit": "GB",
                "type": float,
                "output_name": "Free",
                "perfdata_name": "datastore_free",
            },
            "USED": {
                "counterId": "datastore.capacity",
                "unit": "GB",
                "type": float,
                "output_name": "Used",
                "perfdata_name": "datastore_used",
            },
        },
        "RUNTIME": {
            "CON": {
                "counterId": "runtime.connectionState",
                "unit": "",
                "type": str,
                "output_name": "ConnectionState",
                "perfdata_name": "runtime_con",
            },
            "HEALTH": {
                "counterId": "overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Health",
                "perfdata_name": "runtime_health",
            },
            "TEMPERATURE": {
                "counterId": "runtime.healthSystemRuntime.systemHealthInfo.numericSensorInfo",
                "unit": "",
                "type": str,
                "output_name": "Temperature",
                "perfdata_name": "runtime_temperature",
            },
            "SENSOR": {
                "counterId": "runtime.healthSystemRuntime.systemHealthInfo.numericSensorInfo",
                "unit": "",
                "type": str,
                "output_name": "Sensor",
                "perfdata_name": "runtime_sensor",
            },
            "MAINTENANCE": {
                "counterId": "runtime.inMaintenanceMode",
                "unit": "",
                "type": str,
                "output_name": "Maintenance",
                "perfdata_name": "runtime_maintenance",
            },
            "LISTVM": {
                "counterId": "vm",
                "unit": "",
                "type": str,
                "output_name": "ListVM",
                "perfdata_name": "runtime_listvm",
            },
            "STATUS": {
                "counterId": "overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Status",
                "perfdata_name": "runtime_status",
            },
            "ISSUES": {
                "counterId": "triggeredAlarmState",
                "unit": "",
                "type": str,
                "output_name": "Issues",
                "perfdata_name": "runtime_issues",
            },
        },
        "SERVICE": {
            "NAMES": {
                "counterId": "config.service.serviceName",
                "unit": "",
                "type": str,
                "output_name": "Names",
                "perfdata_name": "service_names",
            },
        },
        "STORAGE": {
            "ADAPTER": {
                "counterId": "storageAdapter",
                "unit": "",
                "type": str,
                "output_name": "Adapter",
                "perfdata_name": "storage_adapter",
            },
            "LUN": {
                "counterId": "scsiLun",
                "unit": "",
                "type": str,
                "output_name": "LUN",
                "perfdata_name": "storage_lun",
            },
            "PATH": {
                "counterId": "scsiPath",
                "unit": "",
                "type": str,
                "output_name": "Path",
                "perfdata_name": "storage_path",
            },
        },
        "UPTIME": {
            "UPTIME": {
                "counterId": "summary.quickStats.uptimeSeconds",
                "unit": "s",
                "type": int,
                "output_name": "Uptime",
                "perfdata_name": "uptime",
            },
        },
    },
    "DC": {
        "CPU": {
            "USAGE": {
                "counterId": "cpu.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "cpu_usage",
            },
            "USAGEMHZ": {
                "counterId": "cpu.usagemhz.average",
                "unit": "MHz",
                "type": float,
                "output_name": "UsageMHz",
                "perfdata_name": "cpu_usagemhz",
            },
        },
        "MEM": {
            "USAGE": {
                "counterId": "mem.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "mem_usage",
            },
            "USAGEMB": {
                "counterId": "mem.usage.average",
                "unit": "MB",
                "type": float,
                "output_name": "UsageMB",
                "perfdata_name": "mem_usagemb",
            },
            "SWAP": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "Swap",
                "perfdata_name": "mem_swap",
            },
            "SWAPIN": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapIn",
                "perfdata_name": "mem_swapin",
            },
            "SWAPOUT": {
                "counterId": "mem.swapoutRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapOut",
                "perfdata_name": "mem_swapout",
            },
            "OVERHEAD": {
                "counterId": "mem.overhead.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overhead",
                "perfdata_name": "mem_overhead",
            },
            "OVERALL": {
                "counterId": "mem.overallUsage.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overall",
                "perfdata_name": "mem_overall",
            },
            "MEMCTL": {
                "counterId": "mem.vmmemctl.average",
                "unit": "MB",
                "type": float,
                "output_name": "MemCtl",
                "perfdata_name": "mem_memctl",
            },
        },
        "NET": {
            "USAGE": {
                "counterId": "net.usage.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "net_usage",
            },
            "RECEIVE": {
                "counterId": "net.received.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Receive",
                "perfdata_name": "net_receive",
            },
            "SEND": {
                "counterId": "net.transmitted.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Send",
                "perfdata_name": "net_send",
            },
        },
        "IO": {
            "USAGE": {
                "counterId": "disk.usage.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "disk_usage",
            },
            "READ": {
                "counterId": "disk.read.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Read",
                "perfdata_name": "disk_read",
            },
            "WRITE": {
                "counterId": "disk.write.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Write",
                "perfdata_name": "disk_write",
            },
        },
        "VMFS": {
            "FREE": {
                "counterId": "datastore.freeSpace",
                "unit": "GB",
                "type": float,
                "output_name": "Free",
                "perfdata_name": "datastore_free",
            },
            "USED": {
                "counterId": "datastore.capacity",
                "unit": "GB",
                "type": float,
                "output_name": "Used",
                "perfdata_name": "datastore_used",
            },
        },
        "RUNTIME": {
            "LISTVM": {
                "counterId": "vm",
                "unit": "",
                "type": str,
                "output_name": "ListVM",
                "perfdata_name": "runtime_listvm",
            },
            "LISTHOST": {
                "counterId": "host",
                "unit": "",
                "type": str,
                "output_name": "ListHost",
                "perfdata_name": "runtime_listhost",
            },
            "LISTCLUSTER": {
                "counterId": "cluster",
                "unit": "",
                "type": str,
                "output_name": "ListCluster",
                "perfdata_name": "runtime_listcluster",
            },
            "TOOLS": {
                "counterId": "guest.toolsStatus",
                "unit": "",
                "type": str,
                "output_name": "Tools",
                "perfdata_name": "runtime_tools",
            },
            "STATUS": {
                "counterId": "overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Status",
                "perfdata_name": "runtime_status",
            },
            "ISSUES": {
                "counterId": "triggeredAlarmState",
                "unit": "",
                "type": str,
                "output_name": "Issues",
                "perfdata_name": "runtime_issues",
            },
        },
    },
    "CLUSTER": {
        "CPU": {
            "USAGE": {
                "counterId": "cpu.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "cpu_usage",
            },
            "USAGEMHZ": {
                "counterId": "cpu.usagemhz.average",
                "unit": "MHz",
                "type": float,
                "output_name": "UsageMHz",
                "perfdata_name": "cpu_usagemhz",
            },
        },
        "MEM": {
            "USAGE": {
                "counterId": "mem.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "mem_usage",
            },
            "USAGEMB": {
                "counterId": "mem.usage.average",
                "unit": "MB",
                "type": float,
                "output_name": "UsageMB",
                "perfdata_name": "mem_usagemb",
            },
            "SWAP": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "Swap",
                "perfdata_name": "mem_swap",
            },
            "SWAPIN": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapIn",
                "perfdata_name": "mem_swapin",
            },
            "SWAPOUT": {
                "counterId": "mem.swapoutRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapOut",
                "perfdata_name": "mem_swapout",
            },
            "OVERHEAD": {
                "counterId": "mem.overhead.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overhead",
                "perfdata_name": "mem_overhead",
            },
            "OVERALL": {
                "counterId": "mem.overallUsage.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overall",
                "perfdata_name": "mem_overall",
            },
            "MEMCTL": {
                "counterId": "mem.vmmemctl.average",
                "unit": "MB",
                "type": float,
                "output_name": "MemCtl",
                "perfdata_name": "mem_memctl",
            },
        },
        "NET": {
            "USAGE": {
                "counterId": "net.usage.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "net_usage",
            },
            "RECEIVE": {
                "counterId": "net.received.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Receive",
                "perfdata_name": "net_receive",
            },
            "SEND": {
                "counterId": "net.transmitted.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Send",
                "perfdata_name": "net_send",
            },
        },
        "IO": {
            "USAGE": {
                "counterId": "disk.usage.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "disk_usage",
            },
            "READ": {
                "counterId": "disk.read.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Read",
                "perfdata_name": "disk_read",
            },
            "WRITE": {
                "counterId": "disk.write.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Write",
                "perfdata_name": "disk_write",
            },
        },
        "VMFS": {
            "FREE": {
                "counterId": "datastore.freeSpace",
                "unit": "GB",
                "type": float,
                "output_name": "Free",
                "perfdata_name": "datastore_free",
            },
            "USED": {
                "counterId": "datastore.capacity",
                "unit": "GB",
                "type": float,
                "output_name": "Used",
                "perfdata_name": "datastore_used",
            },
        },
        "RUNTIME": {
            "LISTVM": {
                "counterId": "vm",
                "unit": "",
                "type": str,
                "output_name": "ListVM",
                "perfdata_name": "runtime_listvm",
            },
            "TOOLS": {
                "counterId": "guest.toolsStatus",
                "unit": "",
                "type": str,
                "output_name": "Tools",
                "perfdata_name": "runtime_tools",
            },
            "STATUS": {
                "counterId": "overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Status",
                "perfdata_name": "runtime_status",
            },
            "ISSUES": {
                "counterId": "triggeredAlarmState",
                "unit": "",
                "type": str,
                "output_name": "Issues",
                "perfdata_name": "runtime_issues",
            },
        },
    },
    "DATASTORE": {
        "CPU": {
            "USAGE": {
                "counterId": "cpu.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "cpu_usage",
            },
            "USAGEMHZ": {
                "counterId": "cpu.usagemhz.average",
                "unit": "MHz",
                "type": float,
                "output_name": "UsageMHz",
                "perfdata_name": "cpu_usagemhz",
            },
        },
        "MEM": {
            "USAGE": {
                "counterId": "mem.usage.average",
                "unit": "%",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "mem_usage",
            },
            "USAGEMB": {
                "counterId": "mem.usage.average",
                "unit": "MB",
                "type": float,
                "output_name": "UsageMB",
                "perfdata_name": "mem_usagemb",
            },
            "SWAP": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "Swap",
                "perfdata_name": "mem_swap",
            },
            "SWAPIN": {
                "counterId": "mem.swapinRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapIn",
                "perfdata_name": "mem_swapin",
            },
            "SWAPOUT": {
                "counterId": "mem.swapoutRate.average",
                "unit": "MB",
                "type": float,
                "output_name": "SwapOut",
                "perfdata_name": "mem_swapout",
            },
            "OVERHEAD": {
                "counterId": "mem.overhead.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overhead",
                "perfdata_name": "mem_overhead",
            },
            "OVERALL": {
                "counterId": "mem.overallUsage.average",
                "unit": "MB",
                "type": float,
                "output_name": "Overall",
                "perfdata_name": "mem_overall",
            },
            "MEMCTL": {
                "counterId": "mem.vmmemctl.average",
                "unit": "MB",
                "type": float,
                "output_name": "MemCtl",
                "perfdata_name": "mem_memctl",
            },
        },
        "NET": {
            "USAGE": {
                "counterId": "net.usage.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "net_usage",
            },
            "RECEIVE": {
                "counterId": "net.received.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Receive",
                "perfdata_name": "net_receive",
            },
            "SEND": {
                "counterId": "net.transmitted.average",
                "unit": "KBps",
                "type": float,
                "output_name": "Send",
                "perfdata_name": "net_send",
            },
        },
        "IO": {
            "USAGE": {
                "counterId": "disk.usage.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Usage",
                "perfdata_name": "disk_usage",
            },
            "READ": {
                "counterId": "disk.read.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Read",
                "perfdata_name": "disk_read",
            },
            "WRITE": {
                "counterId": "disk.write.average",
                "unit": "MB/s",
                "type": float,
                "output_name": "Write",
                "perfdata_name": "disk_write",
            },
        },
        "VMFS": {
            "FREE": {
                "counterId": "datastore.freeSpace",
                "unit": "GB",
                "type": float,
                "output_name": "Free",
                "perfdata_name": "datastore_free",
            },
            "USED": {
                "counterId": "datastore.capacity",
                "unit": "GB",
                "type": float,
                "output_name": "Used",
                "perfdata_name": "datastore_used",
            },
        },
        "RUNTIME": {
            "LISTVM": {
                "counterId": "vm",
                "unit": "",
                "type": str,
                "output_name": "ListVM",
                "perfdata_name": "runtime_listvm",
            },
            "TOOLS": {
                "counterId": "guest.toolsStatus",
                "unit": "",
                "type": str,
                "output_name": "Tools",
                "perfdata_name": "runtime_tools",
            },
            "STATUS": {
                "counterId": "overallStatus",
                "unit": "",
                "type": str,
                "output_name": "Status",
                "perfdata_name": "runtime_status",
            },
            "ISSUES": {
                "counterId": "triggeredAlarmState",
                "unit": "",
                "type": str,
                "output_name": "Issues",
                "perfdata_name": "runtime_issues",
            },
        },
    },
}

usage = """Usage: check_vsphere.py  -H <host_name> [ -D <datacenter> ] [ -C <cluster_name> ] [ -N <vm_name> ]
                    -u <user> -p <password> | -f <authfile>
                    -l <command> [ -s <subcommand> ] [ -T <timeshift> ] [ -i <interval> ]
                    [ -G <get_guests> ]
                    [ -x <blacklist> ] [ -o <additional_options> ]
                    [ -t <timeout> ] [ -w <warn_range> ] [ -c <crit_range> ]
                    [ -V <version> ] [ -v <verbose> ]"""
                    
epilog = """*** vSphere Wizard Help ***
            When connecting to either an ESXi host or a vCenter server, you must specify a host name (-H) and either a username and password (-u and -p) or an authfile (-f).
            
            You may also specify a datacenter (-D) and/or a cluster (-C). When you specify only a datacenter or a cluster with no host or VM specified, the plugin will
            check the resource usage of the datacenter or cluster. When you specify a host or VM, the search for that resource will be limited to the datacenter or cluster
            specified.

            You must also specify a command (-l) and optionally a subcommand (-s).
            
            Examples: 
            $ ./check_vsphere.py -H vcenter.example.com -D datacenter1 -C cluster1 -l CPU 
                This will check the CPU usage of the compute cluster resource since no host or VM was specified.
                
            $ ./check_vsphere.py -H esxi.domain.local -D datacenter1 -C some -N vm1 -l CPU
                This will search for the VM named 'vm1' in the cluster named 'some' in the datacenter named 'datacenter1' and check the CPU usage. If either the cluster or 
                VM are not found when searching in the datacenter, the check will fail.
                
            $ ./check_vsphere.py -H esxi.domain.local -N some_vm -l MEM
                This will search for the VM named 'some_vm' on the ESXi host and return all memory usage checks.
                
            $ ./check_vsphere.py -H vcenter.example.com -C some_cluster -N some_vm -l MEM -s usage
                This will search for the VM named 'some_vm' in the cluster named 'some_cluster' and check the memory usage.
                
            *** Thresholds ***
            Thresholds are specified using the -w and -c options. You may specify multiple thresholds for each check. The thresholds are checked in the order they are specified.
            If a threshold is not specified, it will not be checked. If a threshold is specified but the check does not return a value, the check will fail.
            
            Examples:
            $ ./check_vsphere.py -H vcenter.example.com -D datacenter1 -C some -N vm1 -l CPU -s USAGE -w 10 -c 20
                This will check the CPU usage of the VM named 'vm1' in the cluster named 'some' in the datacenter named 'datacenter1'. If the CPU usage is >20, the check will
                return CRITICAL. If the CPU usage is >10, the check will return WARNING. If the CPU usage is <10, the check will return OK.
                
            $ ./check_vsphere.py -H vcenter.example.com -D datacenter1 -C some -N vm1 -l CPU -w 10 -c 20 -w 30 -c 40
                This will check the CPU usage of the VM named 'vm1' in the cluster named 'some' in the datacenter named 'datacenter1'. Since no subcommand was specified, all CPU
                metrics will be returned in one check. The first metric will be tested against the first set of thresholds. If the first metric is >20, the check will return
                CRITICAL. If the first metric is >10, the check will return WARNING. If the first metric is <10, the check will return OK. The second metric will be tested against
                the second set of thresholds. If the second metric is >40, the check will return CRITICAL. If the second metric is >30, the check will return WARNING. If the second
                metric is <30, the check will return OK.
                
            If you specify multiple thresholds, you must specify the same number of warning and critical thresholds. If you specify more warning or critical thresholds than there
            are metrics, the extra thresholds will be ignored. If you specify more metrics than thresholds, the extra metrics will return OK. The most severe status will be returned.
            
            *** Commands ***
                
            Supported commands(^ - blank or not specified parameter, o - options, T - timeshift value, b - blacklist) :"
		    VM specific :"
		        * cpu - shows cpu info"
		            + usage - CPU usage in percentage"
		            + usagemhz - CPU usage in MHz"
		            + wait - CPU wait time in ms"
		            + ready - CPU ready time in ms"
		            ^ all cpu info(no thresholds)"
		        * mem - shows mem info"
		            + usage - mem usage in percentage"
		            + usagemb - mem usage in MB"
		            + swap - swap mem usage in MB"
		            + overhead - additional mem used by VM Server in MB"
		            + overall - overall mem used by VM Server in MB"
		            + active - active mem usage in MB"
		            + memctl - mem used by VM memory control driver(vmmemctl) that controls ballooning"
		            ^ all mem info(except overall and no thresholds)"
		        * net - shows net info"
		            + usage - overall network usage in KBps(Kilobytes per Second)"
		            + receive - receive in KBps(Kilobytes per Second)"
		            + send - send in KBps(Kilobytes per Second)"
		            ^ all net info(except usage and no thresholds)"
		        * io - shows disk I/O info"
		            + usage - overall disk usage in MB/s"
		            + read - read disk usage in MB/s"
		            + write - write disk usage in MB/s"
		            ^ all disk io info(no thresholds)"
		        * runtime - shows runtime info"
		            + con - connection state"
		            + cpu - allocated CPU in MHz"
		            + mem - allocated mem in MB"
		            + state - virtual machine state (UP, DOWN, SUSPENDED)"
		            + status - overall object status (gray/green/red/yellow)"
		            + consoleconnections - console connections to VM"
		            + guest - guest OS status, needs VMware Tools"
		            + tools - VMware Tools status"
		            + issues - all issues for the host"
		            ^ all runtime info(except con and no thresholds)"
		    Host specific :"
		        * cpu - shows cpu info"
		            + usage - CPU usage in percentage"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + usagemhz - CPU usage in MHz"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            ^ all cpu info"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		        * mem - shows mem info"
		            + usage - mem usage in percentage"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + usagemb - mem usage in MB"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + swap - swap mem usage in MB"
		                o listvm - turn on/off output list of swapping VM's"
		            + overhead - additional mem used by VM Server in MB"
		            + overall - overall mem used by VM Server in MB"
		            + memctl - mem used by VM memory control driver(vmmemctl) that controls ballooning"
		                o listvm - turn on/off output list of ballooning VM's"
		            ^ all mem info(except overall and no thresholds)"
		        * net - shows net info"
		            + usage - overall network usage in KBps(Kilobytes per Second)"
		            + receive - receive in KBps(Kilobytes per Second)"
		            + send - send in KBps(Kilobytes per Second)"
		            + nic - makes sure all active NICs are plugged in"
		            ^ all net info(except usage and no thresholds)"
		        * io - shows disk io info"
		            + aborted - aborted commands count"
		            + resets - bus resets count"
		            + read - read latency in ms (totalReadLatency.average)"
		            + write - write latency in ms (totalWriteLatency.average)"
		            + kernel - kernel latency in ms"
		            + device - device latency in ms"
		            + queue - queue latency in ms"
		            ^ all disk io info"
		        * vmfs - shows Datastore info"
		            + (name) - free space info for datastore with name (name)"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o regexp - whether to treat name as regexp"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
		            ^ all datastore info"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
		        * runtime - shows runtime info"
		            + con - connection state"
		            + health - checks cpu/storage/memory/sensor status and propagates worst state"
		                o listitems - list all available sensors(use for listing purpose only)"
		                o blackregexpflag - whether to treat blacklist as regexp"
		                b - blacklist status objects"
		            + storagehealth - storage status check"
		                o blackregexpflag - whether to treat blacklist as regexp"
		                b - blacklist status objects"
		            + temperature - temperature sensors"
		                o blackregexpflag - whether to treat blacklist as regexp"
		                b - blacklist status objects"
		            + sensor - threshold specified sensor"
		            + maintenance - shows whether host is in maintenance mode"
		                o maintwarn - sets warning state when host is in maintenance mode"
		                o maintcrit - sets critical state when host is in maintenance mode"
		            + list(vm) - list of VMware machines and their statuses"
		            + status - overall object status (gray/green/red/yellow)"
		            + issues - all issues for the host"
		                b - blacklist issues"
		            ^ all runtime info(health, storagehealth, temperature and sensor are represented as one value and no thresholds)"
		        * service - shows Host service info"
		            + (names) - check the state of one or several services specified by (names), syntax for (names):<service1>,<service2>,...,<serviceN>"
		            ^ show all services"
		        * storage - shows Host storage info"
		            + adapter - list bus adapters"
		                b - blacklist adapters"
		            + lun - list SCSI logical units"
		                b - blacklist LUN's"
		            + path - list logical unit paths"
		                b - blacklist paths"
		            ^ show all storage info"
		        * uptime - shows Host uptime"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		    DC specific :"
		        * cpu - shows cpu info"
		            + usage - CPU usage in percentage"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + usagemhz - CPU usage in MHz"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            ^ all cpu info"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		        * mem - shows mem info"
		            + usage - mem usage in percentage"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + usagemb - mem usage in MB"
		                o quickstats - switch for query either PerfCounter values or Runtime info"
		            + swap - swap mem usage in MB"
		            + overhead - additional mem used by VM Server in MB"
		            + overall - overall mem used by VM Server in MB"
		            + memctl - mem used by VM memory control driver(vmmemctl) that controls ballooning"
		            ^ all mem info(except overall and no thresholds)"
		        * net - shows net info"
		            + usage - overall network usage in KBps(Kilobytes per Second)"
		            + receive - receive in KBps(Kilobytes per Second)"
		            + send - send in KBps(Kilobytes per Second)"
		            ^ all net info(except usage and no thresholds)"
		        * io - shows disk io info"
		            + aborted - aborted commands count"
		            + resets - bus resets count"
		            + read - read latency in ms (totalReadLatency.average)"
		            + write - write latency in ms (totalWriteLatency.average)"
		            + kernel - kernel latency in ms"
		            + device - device latency in ms"
		            + queue - queue latency in ms"
		            ^ all disk io info"
		        * vmfs - shows Datastore info"
		            + (name) - free space info for datastore with name (name)"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o regexp - whether to treat name as regexp"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
		            ^ all datastore info"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
		        * runtime - shows runtime info"
		            + list(vm) - list of VMware machines and their statuses"
		            + listhost - list of VMware esx host servers and their statuses"
		            + listcluster - list of VMware clusters and their statuses"
		            + tools - VMware Tools status"
		                b - blacklist VM's"
		            + status - overall object status (gray/green/red/yellow)"
		            + issues - all issues for the host"
		                b - blacklist issues"
		            ^ all runtime info(except cluster and tools and no thresholds)"
		        * recommendations - shows recommendations for cluster"
		            + (name) - recommendations for cluster with name (name)"
		            ^ all clusters recommendations"
		    Cluster specific :"
		        * cpu - shows cpu info"
		            + usage - CPU usage in percentage"
		            + usagemhz - CPU usage in MHz"
		            ^ all cpu info"
		        * mem - shows mem info"
		            + usage - mem usage in percentage"
		            + usagemb - mem usage in MB"
		            + swap - swap mem usage in MB"
		                o listvm - turn on/off output list of swapping VM's"
		            + memctl - mem used by VM memory control driver(vmmemctl) that controls ballooning"
		                o listvm - turn on/off output list of ballooning VM's"
		            ^ all mem info(plus overhead and no thresholds)"
		        * cluster - shows cluster services info"
		            + effectivecpu - total available cpu resources of all hosts within cluster"
		            + effectivemem - total amount of machine memory of all hosts in the cluster"
		            + failover - VMware HA number of failures that can be tolerated"
		            + cpufairness - fairness of distributed cpu resource allocation"
		            + memfairness - fairness of distributed mem resource allocation"
		            ^ only effectivecpu and effectivemem values for cluster services"
		        * runtime - shows runtime info"
		            + list(vm) - list of VMware machines in cluster and their statuses"
		            + listhost - list of VMware esx host servers in cluster and their statuses"
		            + status - overall cluster status (gray/green/red/yellow)"
		            + issues - all issues for the cluster"
		                b - blacklist issues"
		            ^ all cluster runtime info"
		        * vmfs - shows Datastore info"
		            + (name) - free space info for datastore with name (name)"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o regexp - whether to treat name as regexp"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
		            ^ all datastore info"
		                o used - output used space instead of free"
		                o brief - list only alerting volumes"
		                o blacklistregexp - whether to treat blacklist as regexp"
		                b - blacklist VMFS's"
		                T (value) - timeshift to detemine if we need to refresh"
            """

unit_list = ["%", "MHz", "GHz", "B", "Bps", "KB", "KBps", "Kib", "Kibps", "MB", "MBps", "Mib", "Mibps", "GB", "GBps", "Gib", "Gibps", "TB", "TBps", "Tib", "Tibps", "s", "ms", "us", "ns", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s", "KBps", "MBps", "GBps", "TBps", "Kibps", "Mibps", "Gibps", "Tibps", "KB/s", "MB/s", "GB/s", "TB/s", "Kib/s", "Mib/s", "Gib/s", "Tib/s"]