    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Server Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the server you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Operating System') ?> <?= xi6_info_tooltip(_('The operating system running on the server you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <select name="osdistro" id="osdistro" class="form-select monitor rounded" placeholder="<?= _("Select Operating System") ?> " required>
                            <option value="" disabled selected hidden>Choose Operating System...</option>
                            <option value="AIX" <?= is_selected($osdistro, "AIX") ?>>AIX</option>
                            <option value="FreeBSD" <?= is_selected($osdistro, "FreeBSD") ?>>FreeBSD</option>
                            <option value="HP-UX" <?= is_selected($osdistro, "HP-UX") ?>>HP-UX</option>
                            <option value="RHEL" <?= is_selected($osdistro, "RHEL") ?>>Linux - RedHat Enterprise</option>
                            <option value="Fedora" <?= is_selected($osdistro, "Fedora") ?>>Linux - Fedora</option>
                            <option value="CentOS" <?= is_selected($osdistro, "CentOS") ?>>Linux - CentOS</option>
                            <option value="Ubuntu" <?= is_selected($osdistro, "Ubuntu") ?>>Linux - Ubuntu</option>
                            <option value="Debian" <?= is_selected($osdistro, "Debian") ?>>Linux - Debian</option>
                            <option value="SUSE" <?= is_selected($osdistro, "SUSE") ?>>Linux - SUSE Enterprise</option>
                            <option value="OpenSUSE" <?= is_selected($osdistro, "OpenSUSE") ?>>Linux - OpenSUSE</option>
                            <option value="Linux" <?= is_selected($osdistro, "Linux") ?>>Linux - Other</option>
                            <option value="NetBSD" <?= is_selected($osdistro, "NetBSD") ?>>NetBSD</option>
                            <option value="OpenBSD" <?= is_selected($osdistro, "OpenBSD") ?>>OpenBSD</option>
                            <option value="Solaris" <?= is_selected($osdistro, "Solaris") ?>>Solaris</option>
                            <option value="Windows" <?= is_selected($osdistro, "Windows") ?>>Windows</option>
                            <option value="Mac" <?= is_selected($osdistro, "Mac") ?>>Mac OS/X</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Operating System
                        </div>
                        <i id="osdistro_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <p class="mt-4">
                <a href="https://assets.nagios.com/downloads/nagiosxi/docs/Monitoring_Hosts_Using_SSH.pdf" target="_blank"><?= _("Instructions for how to monitor hosts using ssh") ?></a>
            </p>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
