<?php

require_once(dirname(__FILE__) . '/../../common.inc.php');

// Start session
init_session(false, false);

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs(false);
check_authentication(false);
check_nagios_session_protector();

print_json_alert_history();

/**
 * This function needs to output data formatted like:
 * 
 * [
 *   {
 *     "value": 149,
 *     "day": "2017-01-23"
 *   },
 *   {
 *     "value": 191,
 *     "day": "2017-12-17"
 *   },
 *   {
 *     "value": 266,
 *     "day": "2018-01-03"
 *   },
 *   {
 *     "value": 163,
 *     "day": "2016-08-02"
 *   },
 *   {
 *     "value": 237,
 *     "day": "2016-10-16"
 *   }
 * ]
 */
function print_json_alert_history() {

    $lookback = intval(grab_request_var("lookback", "365"));


    // Get a count of our state changes to non-OK states, grouped & sorted by the day on which they occurred.
    // Some people would say that you should instead grab all of the periods during which a host/service stayed non-OK
    // (e.g. if a host was down for 3 days straight, it should contribute to all of those).
    // That query gets really hairy and the performance is questionable (and I especially don't want to implement a cache for this),
    // so we're not doing that right now.
    $sql = "SELECT 
                DATE(state_time) as day, 
                COUNT(*) as value 
            FROM nagios.nagios_statehistory 
            WHERE state_time > DATE_SUB(NOW(), INTERVAL $lookback DAY) 
                AND state_type != 0 
            GROUP BY DATE(state_time)
            ORDER BY DATE(state_time)";

    $result = exec_sql_query(DB_NDOUTILS, $sql);

    if ($result === null) {
        return;
    }

    $data = $result->GetArray();

    // Use the date of the oldest non-empty record if available
    if (!empty($data)) {
         $candidate_date = date_create($data[0]['day']);
    } else {
         // Fallback to the lookback period start
         $candidate_date = alert_history_truncated_datetime("now -$lookback days");
    }

    $corrected_data = array();
    $one_day = new DateInterval("P1D");

    foreach ($data as $record) {
        $record_date = date_create($record['day']);

        while ($record_date > $candidate_date) {
            $corrected_data[] = array('day' => $candidate_date->format('Y-m-d'), 'value' => 0);
            $candidate_date->add($one_day);
        }
        $corrected_data[] = $record;
        $candidate_date->add($one_day);
    }

    // We also aren't required to have a record that matches the end of our period.
    // Fill in all of the values from our last record through to today.
    $today_date = alert_history_truncated_datetime('now');
    while ($today_date >= $candidate_date) {
        $corrected_data[] = array('day' => $candidate_date->format('Y-m-d'), 'value' => 0);
        $candidate_date->add($one_day);
    }

    echo json_encode($corrected_data);
}

// Takes a datestring, returns the DateTime with only "day" resolution.
function alert_history_truncated_datetime($datestring) {
    $as_datetime = date_create($datestring);
    $truncated_to_date = $as_datetime->format('Y-m-d');
    $as_truncated = date_create($truncated_to_date);
    return $as_truncated;
}