<?php
//
// Alert History Dashlet
// Copyright (c) 2023-2024 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../dashlethelper.inc.php');

alert_history_dashlet_init();

function alert_history_dashlet_init()
{
    $name = "alert_history";

    $args = array(
        DASHLET_NAME => $name,
        DASHLET_AUTHOR => "Nagios Enterprises, LLC",
        DASHLET_DESCRIPTION => _("Alert History."),
        DASHLET_FILTER_GROUPS => array("alerts"),
        DASHLET_COPYRIGHT => "Dashlet Copyright &copy; 2023-2024 Nagios Enterprises, LLC.",
        DASHLET_LICENSE => "MIT",
        DASHLET_FUNCTION => "alert_history_dashlet_func",
        DASHLET_TITLE => _("Alert History"),
        DASHLET_VERSION => '1.0.2',
        DASHLET_OUTBOARD_CLASS => "alert_history_outboardclass",
        DASHLET_INBOARD_CLASS => "alert_history_inboardclass",
        DASHLET_PREVIEW_CLASS => "alert_history_previewclass",
        DASHLET_WIDTH => "1040",
        DASHLET_HEIGHT => "400",
        DASHLET_OPACITY => "1.0",
        DASHLET_BACKGROUND => "",
        DASHLET_ISCUSTOM => false
    );

    register_dashlet($name, $args);
}


/**
 * @param string $mode
 * @param string $id
 * @param null   $args
 *
 * @return string
 */
function alert_history_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{

    $output = "";

    $imgbase = get_dashlet_url_base("alert_history") . "/images/";

    switch ($mode) {
        case DASHLET_MODE_GETCONFIGHTML:
            ob_start();
            $output = ob_get_clean();

            break;
        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:

            $container = $id;
            $lookback = grab_array_var($args, 'lookback', '365');
            ob_start();
            include __DIR__.'/react-iframe.php';
            $output = ob_get_clean();
            //$output = '<div> your face </div>';

            // //print_r($args);
            // //return "ARGS:";

            // $regionid = $args["region"];
            // $theregion = $regions[$regionid];
            // $siteurl = $baseurl . "" . $theregion["details_url"];
            // $imgurl = $baseurl . "" . $theregion[$args["map"]];

            // $width = "90%";
            // $height = "90%";

            // $output = "<div id='internettrafficreport-container-" . $id . "' style='width: " . $width . "; height: " . $height . ";' ><div style='display: block;'><a href='" . $siteurl . "' target='_blank' title='Go To The Internet Traffic Report'><img src='" . $imgurl . "' width='100%'></a></div></div>";
            break;
        case DASHLET_MODE_PREVIEW:

            if(!is_neptune()) {
                $output = "<img src='" . $imgbase . "ah_preview_220.PNG'>";
            } else if (get_theme() == "neptunelight"){
                $output = "<img src='" . $imgbase . "alert_history_neptune_light_preview.png'>";
            } else {
                $output = "<img src='" . $imgbase . "neptune_preview.png'>";
            }
            break;
    }

    return $output;
}
