<?php

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

header('Content-Type: application/json');

// Initialization stuff
pre_init();
init_session();
// Grab GET or POST variables and pre-reqs
grab_request_vars();
check_prereqs();
check_authentication(false);

$mode = grab_request_var('mode');

switch ($mode) {
    case 'service_from_host':
        $host = grab_request_var('host');
        $service_object = capacity_planning_wizard_get_service_from_host($host);
        print json_encode($service_object);
        return;
    case 'track_name_from_host_service':
        $host = grab_request_var('host');
        $service = grab_request_var('service');
        $perfdata_object = capacity_planning_wizard_get_perfdata_from_host_service($host, $service);
        print json_encode($perfdata_object);
        return;
    default:
        print json_encode(array('error' => _("Please specify a mode")));
        return;
}

// Takes a host_name, returns an array ('service' => array(<service_descriptions>))
// On failure, returns an array ('error' => <error-msg>)
function capacity_planning_wizard_get_service_from_host($host_name) {
    $args = array("host_name" => $host_name);
    $services = array();
    $data = get_xml_service_objects($args);
    foreach ($data->service as $service) {
        $services[] = strval($service->service_description);
    }
    return $services;
}

// Takes a host_name, service_description, returns an array ('perfdata_info' => array(<perfdata_names>))
// pooooossibly also include warning and critical values?
// On failure, reutrns an array ('error' => <error-msg>)
function capacity_planning_wizard_get_perfdata_from_host_service($host_name, $service_description) {

    $file_location = pnp_get_host_perfdata_dir($host_name).'/'.pnp_convert_object_name($service_description).'.xml';
    $simplexml_data = simplexml_load_file($file_location);

    $ret = array();
    foreach ($simplexml_data->DATASOURCE as $track_info) {
        $important = array(
            'name' => strval($track_info->NAME),
            'warn' => strval($track_info->WARN),
            'crit' => strval($track_info->CRIT)
        );
        $ret[] = $important;
    }

    return $ret;
}