    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="Host_Name" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The Host Name in Nagios XI')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="Host_Name" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="Host_Name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="Service Description" class="form-label"><?= _('Service Description') ?> <?= xi6_info_tooltip(_('The Description you would like to have associated with this test case')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="servicedesc" id="Service Description" value="<?= encode_form_val($servicedesc) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Description") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="Service Description_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Email Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="To_Address" class="form-label"><?= _('To Address') ?> <?= xi6_info_tooltip(_('The email address to send the test message to. This is used in the envelope headers and must match the IMAP account you wish to check')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="smtpto" id="To_Address" value="<?= encode_form_val($smtpto) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter To Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="To_Address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="From_Address" class="form-label"><?= _('From Address') ?> <?= xi6_info_tooltip(_('Address to use as the from/sender address in the envelope headers')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="smtpfrom" id="From_Address" value="<?= encode_form_val($smtpfrom) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter From Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="From_Address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('SMTP Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="SMTP Address" class="form-label"><?= _('SMTP Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the SMTP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="smtp_address" id="SMTP Address" value="<?= encode_form_val($smtp_address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter SMTP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="SMTP Address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="SMTP Username" class="form-label"><?= _('SMTP Username') ?> <?= xi6_info_tooltip(_('The username used to login to the SMTP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="smtp_username" id="SMTP Username" value="<?= encode_form_val($smtp_username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter SMTP Username") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="SMTP Username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _("Change SMTP Password") ?> <?= xi6_info_tooltip(_("Use to change the SMTP Password, otherwise, the existing SMTP Password will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="SMTP Password" class="form-label"><?= _('SMTP Password') ?> <?= xi6_info_tooltip(_('The password used to login to the SMTP server')) ?></label>
                <div class="input-group">
                    <input type="password" name="smtp_password" id="SMTP Password" value="<?= encode_form_val($smtp_password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter SMTP Password") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show SMTP Password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="SMTP Password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="SMTP Port" class="form-label"><?= _('SMTP Port') ?> <?= xi6_info_tooltip(_('Service port on the SMTP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="smtp_port" id="SMTP Port" value="<?= encode_form_val($smtp_port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter SMTP Port") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="SMTP Port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="SMTP TLS" class="form-check-input" name="smtp_tls"  <?= is_checked($smtp_tls, "on") ?> >
                        <label for="SMTP TLS" class="form-check-label bold"><?= _('SMTP TLS') ?> <?= xi6_info_tooltip(_('Enable or disable TLS/AUTH for the SMTP plugin.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('IMAP Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="IMAP Address" class="form-label"><?= _('IMAP Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the IMAP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="imap_address" id="IMAP Address" value="<?= encode_form_val($imap_address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IMAP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="IMAP Address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="IMAP Username" class="form-label"><?= _('IMAP Username') ?> <?= xi6_info_tooltip(_('The username used to login to the IMAP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="imap_username" id="IMAP Username" value="<?= encode_form_val($imap_username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IMAP Username") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="IMAP Username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _("Change IMAP Password") ?> <?= xi6_info_tooltip(_("Use to change the IMAP Password, otherwise, the existing IMAP Password will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="IMAP Password" class="form-label"><?= _('IMAP Password') ?> <?= xi6_info_tooltip(_('The password used to login to the IMAP server')) ?></label>
                <div class="input-group">
                    <input type="password" name="imap_password" id="IMAP Password" value="<?= encode_form_val($imap_password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter IMAP Password") ?>" >
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show IMAP Password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="IMAP Password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="IMAP Port" class="form-label"><?= _('IMAP Port') ?> <?= xi6_info_tooltip(_('Service port on the IMAP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="imap_port" id="IMAP Port" value="<?= encode_form_val($imap_port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IMAP Port") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="IMAP Port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="IMAP SSL" class="form-check-input" name="imap_ssl"  <?= is_checked($imap_ssl, "on") ?> >
                        <label for="IMAP SSL" class="form-check-label bold"><?= _('IMAP SSL') ?> <?= xi6_info_tooltip(_('Enable or disable SSL for the IMAP plugin.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
