<?php
//
// Escalation Wizard
// Copyright (c) 2010-2024 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

$escalationwizard_component_name = "escalationwizard";
escalationwizard_component_init();


////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////


function escalationwizard_component_init()
{
    global $escalationwizard_component_name;
    $versionok = escalationwizard_component_checkversion();

    // Component description
    $desc = _("This component host and service escalations to be easily created through a wizard");

    if (!$versionok) {
        $desc = "<b>" . _("Error: This component requires Nagios XI 2024R1.1 or later.") . "</b>";
    }

    // All components require a few arguments to be initialized correctly.
    $args = array(
        COMPONENT_NAME => $escalationwizard_component_name,
        COMPONENT_VERSION => '1.5.3',
        COMPONENT_DATE => '05/28/2024',
        COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION => $desc,
        COMPONENT_TITLE => _("Escalation Wizard")
    );

    // Register this component with XI
    register_component($escalationwizard_component_name, $args);

    if ($versionok) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'escalationwizard_component_addmenu');
    }
}


///////////////////////////////////////////////////////////////////////////////////////////
// MISC FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////


function escalationwizard_component_checkversion()
{
    if (!function_exists('get_product_release') || get_product_release() < 60100) {
        return false;
    }
    return true;
}


function escalationwizard_component_addmenu($arg = null)
{
    global $escalationwizard_component_name;
    global $menus;

    $urlbase = get_component_url_base($escalationwizard_component_name);

    if (ccm_has_access_for('hostescalation') || ccm_has_access_for('serviceescalation')) {
        add_menu_item(MENU_CCM, array(
            "type" => "link",
            "title" => _("Escalation Wizard"),
            "id" => "menu-ccm-escalationwizard",
            "order" => 802.6,
            "opts" => array(
                "href" => $urlbase . "/escalationwizard.php",
                "icon" => "fa-chevron-circle-up"
            )
        ));
    }
}
