/*
 * Home Tour - Tour of the home page
 *
 *  If the wizard is still enabled and the user is on the home page,
 *  loads homepage tour.
 * 
 */

/* NOTE:: if you add steps, you will need to update the 
    ::CAREFUL:: if you add steps, you need to update this::CAREFUL::
 section */

// console.log("home-tour.js loaded on " + document.title + " page");


// TODO: REMOVE AFTER TESTING IS COMPLETE
// ajaxSetStep("home", 14);

// load tour
window.onload=function() {
    // load tour if on home page
    if(document.title == "Nagios XI") {
        $.get(window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php', { 'cmd': 'get_step', 'tour': 'home' }, function(data) {
            data = JSON.parse(data);

            if(data.step == null) {
                startHomeTour(0);
            } else {
                startHomeTour(data.step);
            }
        });

        // load tour css because it doesn't work unless I do it here
        var link = document.createElement('link');
        link.rel = 'stylesheet';
        link.type = 'text/css';
        link.href = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/css/hopscotch.css';
        document.getElementsByTagName('head')[0].appendChild(link);
    }

}

/*
 * Home Tour
 *
 *  Points out various features of the home page
 *  and then guides the user to the configuration wizard
 * 
 */
function startHomeTour(step) {
    hopscotch.endTour();

    // first child
    var menulink = document.querySelector("#config-menulink");
    var menulinkul = document.querySelector("#config-menulink span > ul");

    // console.log("starting step: "+step);

    var steps = [
        { // 0
            title: "Welcome to Nagios XI",
            content: "This tour will show you around the Nagios XI <b>home page</b>.",
            target: "header",
            placement: "bottom",
            yOffset: -15,
            arrowOffset: 60,
            onNext: function() {
                document.querySelector("#leftnav").scrollTop = 0;
            }
        }, { // 1
            title: "Quick View",
            content: "<b>Quick View</b> items show you a quick overview of your host and service statuses.",
            target: "mid-menu-home-section-quickview",
            placement: "right",
            yOffset: -20,
            xOffset: -50,
        }, { // 2
            title: "Details",   
            content: "The <b>Details</b> section items show you more detailed information about your hosts and services.",
            target: "mid-menu-home-section-details",
            placement: "right",
            yOffset: -20,
            xOffset: -50,
            onPrev: function() {
                document.querySelector("#leftnav").scrollTop = 0;
            },
            onNext: function() {
                let leftnav = document.querySelector("#leftnav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            }
        }, { // 3
            title: "Graphs",
            content: "The <b>Graphs</b> section shows you graphs of your host and service status history.",
            target: "mid-menu-home-section-graphs",
            placement: "right",
            yOffset: -20,
            xOffset: -50,
            onPrev: function() {
                document.querySelector("#leftnav").scrollTop = 0;
            },
            onNext: function() {
                let leftnav = document.querySelector("#leftnav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            }
        }, { // 4
            title: "Maps",
            content: "The <b>Maps</b> section gives you various visual representations of your hosts and services.",
            target: "mid-menu-home-section-maps",
            placement: "right",
            yOffset: -20,
            xOffset: -50,
            onPrev: function() {
                let leftnav = document.querySelector("#leftnav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            },
            onNext: function() {
                let leftnav = document.querySelector('#leftnav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
            }
        }, { // 5
            title: "Incident Management",
            content: "The <b>Incident management</b> section gives you a number of ways to view and manage incidents on your Hosts/Services.",
            target: "mid-menu-home-section-incident-management",
            placement: "bottom",
            onPrev: function() {
                let leftnav = document.querySelector('#leftnav');
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            },
            onNext: function() {
                let leftnav = document.querySelector('#leftnav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
            }
        }, { // 6
            title: "Monitoring Process",
            content: "The <b>Monitoring Process</b> section gives an overview of the Nagios XI server's monitoring processes.",
            target: "mid-menu-home-section-monitoringprocess",
            placement: "bottom",
            onPrev: function() {
                let leftnav = document.querySelector('#leftnav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
            },
            onNext: function() {
                document.querySelector('#leftnav').scrollTop = 0;
            }
        }, { // 7
            title: "Visualizations",
            content: "The <b>Views/Dashboards/Reports</b> sections give you a number of ways to view your hosts and services.",
            target: document.querySelector(".mainmenu"),
            placement: "bottom",
            yOffset: 48,
            xOffset: 50,
            arrowOffset: 40,
            onPrev: function() {
                let leftnav = document.querySelector('#leftnav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
                // reset views/dashboards/reports color
                for (var i = 0; i < document.querySelectorAll(".mainmenu > div").length; i++) {
                    if (i >= 0 && i < 3){
                        document.querySelectorAll(".mainmenu > div")[i].style.background = "";
                    }
                }
            },
            onShow: function() {
                // darken views/dashboards/reports
                for (var i = 0; i < document.querySelectorAll(".mainmenu > div").length; i++) {
                    if (i >= 0 && i < 3){
                        document.querySelectorAll(".mainmenu > div")[i].style.background = "#222";
                    }
                }
            },
            onNext: function() {
                // reset views/dashboards/reports color
                for (var i = 0; i < document.querySelectorAll(".mainmenu > div").length; i++) {
                    if (i >= 0 && i < 3){
                        document.querySelectorAll(".mainmenu > div")[i].style.background = "";
                    }
                }
            }
        }, { // 8
            title: "Configuration Menu",
            content: "The <b>Configuration Menu</b> allows you to configure various aspects of Nagios XI.",
            target: document.querySelector("#config-menulink"),
            placement: "bottom",
            arrowOffset: 19,
            xOffset: 1,
            onShow: function() {
                addCloseListener();
                document.querySelector("#config-menulink").style.background = "#222";
            },
            onPrev: function() {
                document.querySelector("#config-menulink").style.background = "";
            },
            onNext: function() {
                showConfigMenu();
            }
        }, { // 9
            title: "Configuration Wizards",
            content: "To set up monitoring, you can select <b>Configuration Wizards</b>.",
            target: document.querySelector("#config-menulink span > ul > li:nth-child(1)"),
            placement: "right",
            yOffset: 1,
            onShow: function() {
                showConfigMenu();
                addCloseListener();
                removeEventListener("mouseout", hideConfigMenu);
            },
            onPrev: function() {
                hideConfigMenu();
            },
            onNext: function() {
                showConfigMenu();
            }
        }, { // 10
            title: "Deploy Agent",
            content: "Deploy the <b>Nagios Cross-Platform Agent</b> (<b>NCPA</b>) to monitor remote hosts.",
            target: document.querySelector("#config-menulink span > ul > li:nth-child(1)"),
            placement: "right",
            yOffset: 1,
            arrowOffset: 20,
            onShow: function() {
                showConfigMenu();
                addCloseListener();
                removeEventListener("mouseout", hideConfigMenu);
            },
            onPrev: function() {
                showConfigMenu();
            },
            onNext: function() {
                showConfigMenu();
            }
        }, { // 11
            title: "Core Config Manager",
            content: "The <b>Core Config Manager</b> gives you the ability to modify <b>Nagios Core</b> configurations.",
            target: document.querySelector("#config-menulink span > ul > li:nth-child(1)"),
            placement: "right",
            yOffset: 1,
            arrowOffset: 50,
            onShow: function() {
                showConfigMenu();
                addCloseListener();
                removeEventListener("mouseout", hideConfigMenu);
            },
            onPrev: function() {
                showConfigMenu();
            },
            onNext: function() {
                hideConfigMenu();
            }
        }, 
        { // 12
            title: "Admin",
            content: "The <b>Admin</b> pages allow you to modify many different aspects of your Nagios XI server.",
            target: document.querySelector(".mainmenu > div:nth-child(6)"),
            placement: "bottom",
            xOffset: 1,
            arrowOffset: 17,
            onShow: function() {
                document.querySelector(".mainmenu > div:nth-child(6)").style.background = "#222";
            },
            onPrev: function() {
                document.querySelector(".mainmenu > div:nth-child(6)").style.background = "";
                showConfigMenu();
            },
            onNext: function() {
                document.querySelector(".mainmenu > div:nth-child(6)").style.background = "";
            }
        },
        { // 13
            title: "Enterprise Features",
            content: "The <b>Enterprise Features</b> page has a quick menu for accessing all of your enterprise Nagios XI features.",
            target: document.querySelector(".mainmenu > div:nth-child(7)"),
            placement: "bottom",
            xOffset: 1,
            arrowOffset: 17,
            onShow: function() {
                document.querySelector(".mainmenu > div:nth-child(7)").style.background = "#222";
            },
            onPrev: function() {
                document.querySelector(".mainmenu > div:nth-child(7)").style.background = "";
            },
            onNext: function() {
                document.querySelector(".mainmenu > div:nth-child(7)").style.background = "";
                showHelpMenu();
            }
        },
        { // 14
            title: "Help & Support",
            content: "The help menu gives you access to the Nagios XI documentation and support resources such as <b>API Docs</b>, <b>Developer Docs</b> and more.",
            target: document.querySelector("#help-button-div > ul > li:nth-child(2)"),
            placement: "left",
            yOffset: 6,
            xOffset: 15,
            onNext: function() {
                showHelpMenu();
            }
        },
        { // 15
            title: "Nagios Exchange",
            content: "The <b>Nagios Exchange</b> is a community site where you can find plugins, addons, and more for Nagios Products.",
            target: document.querySelector("#help-button-div > ul > li:nth-child(6)"),
            placement: "left",
            yOffset: 1,
            xOffset: 15,
            onPrev: function() {
                showHelpMenu();
            },
            onNext: function() {
                showProfileMenu();
            }
        },
        { // 16
            title: "User Profile",
            content: "Your <b>User Profile</b> allows you to customize various things for your user experience from <b>password</b> to <b>email</b> to <b>theme</b>. You can also restart tours from here.",
            target: document.querySelector("#profile-button-div > ul > li:nth-child(1)"),
            placement: "left",
            xOffset: 15,
            yOffset: -13,
            onShow: function() {
                if(menulink === null) { // if is not admin, this is the last step
                    document.querySelector(".hopscotch-next").addEventListener("click", function() {
                        ajaxSetStep("home", 16);
                    });
                }
                // can't darken background because of the menu styling
            },
            onPrev: function() {
                showHelpMenu();
            },
            onNext: function() {
                showConfigMenu();
            }
        },
        { // 17
            title: "Use a Wizard!",
            content: "Let's set up monitoring via a wizard! You can select <b>Configuration Wizards</b> or hit <b>Next</b> to continue.",
            target: document.querySelector("#config-menulink span > ul > li:nth-child(1)"),
            placement: "right",
            yOffset: -17,
            nextOnTargetClick: true,
            onShow: function() {
                addCloseListener();
                removeEventListener("mouseout", hideConfigMenu);
                document.querySelector("#config-menulink span > ul > li:nth-child(1) > a").addEventListener("click", function() {
                    event.preventDefault();
                    ajaxSetStep("home", 17);
                    setTimeout(() => {
                        window.location.href = document.querySelector("#config-menulink span > ul > li:nth-child(1) > a").href;
                    }, 200);
                });
            },
            onPrev: function() {
                showProfileMenu();
                hideConfigMenu();
            },

            multipage: true,
            onNext: function() {
                ajaxSetStep("wizard-landing", 0);
                setTimeout(() => {
                    window.location = window.location.origin + "/nagiosxi/config/?xiwindow=monitoringwizard.php";
                }, 200);
            }
        }, { // 18
            // needs empty step for last step to have a next button, 
            // but can't make the other steps part of this wizard because 
            // the next step is in an iframe
        } 
    ]

    // add behaviors to each step:    
    let counter = 1;
    function addBehavior(oldBehavior, extraBehavior, currentStep) {
        return function() {
            if (typeof currentStep !== 'undefined') {
                extraBehavior(currentStep);
            } else {
                extraBehavior();
            }

            if (oldBehavior) {
                oldBehavior();
            }
        };
    }
    steps = steps.map(step => {
        // Add extra behavior to onShow
        step.onShow = addBehavior(step.onShow, () => styleAll("home", steps.length));
        step.onShow = addBehavior(step.onShow, addCloseListener);

        step.showPrevButton = true;

        // Add extra behavior to onPrev
        step.onPrev = addBehavior(step.onPrev, (currentStep) => {
            ajaxSetStep("home", currentStep - 2);
        }, counter);

        // Add extra behavior to onNext
        step.onNext = addBehavior(step.onNext, (currentStep) => {
            ajaxSetStep("home", currentStep);
        }, counter);

        counter++;
        return step;
    });

    // user has completed tour (empty last step to allow next button to show)
    if(step > steps.length - 1) {
        return;
    }

    // ::CAREFUL:: if you add steps, you need to update this::CAREFUL::
    // pre-show things that need to happen before the step is shown for timing reasons
    if(step == 3 || step == 4) {
        let leftnav = document.querySelector("#leftnav");
        let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
        leftnav.scrollTop = scroll50;
    } else if(step == 5 || step == 6) {
        let leftnav = document.querySelector("#leftnav");
        leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
    }
    // open configure menu to show configuration wizards link
    else if(step == steps.length - 2 || (step >= 9 && step <= 11)) { // NOTE: REMEMBER TO UPDATE THIS IF YOU ADD STEPS
        showConfigMenu();
    }
    else if(step == 14 || step == 15) {
        showHelpMenu();
    }
    else if(step == 16) {
        showProfileMenu();
    }

    // console.log("starting tour step: "+step);

    homeTour = {
        id: "home-tour",
        steps: steps
    }

    function showConfigMenu(){
        menulink.style.background = "#222";
        menulinkul.style.display = "block";
    }
    function hideConfigMenu(){
        menulink.style.background = "";
        menulinkul.style.display = "none";
    }


    function showHelpMenu(){
        // needs both, one for if menu starts closed and one for if the menu is open... it's a pain, but necessary
        if($('#help-button').attr('aria-expanded') != 'true'){
            $('#help-button').click();
        }
        setTimeout(() => {
            if($('#help-button').attr('aria-expanded') != 'true'){
                $('#help-button').click();
            }
        }, 50);
        // check for update in menu
        help_ajax_check_for_updates(0);
    }

    function showProfileMenu(){
        if($('#profile-button').attr('aria-expanded') != 'true'){
            $('#profile-button').click();
        }
        setTimeout(() => {
            if($('#profile-button').attr('aria-expanded') != 'true'){
                $('#profile-button').click();
            }
        })
    }

    // make the sidebar tour sticky? - (WIP) TODO: make this work? maybe not worth?
    // function setSticky(sticky = true) {
    //     var sidebar = document.querySelector("#leftnav");

    //     sidebar.addEventListener('scroll', function() {
    //         const hopBubble = document.querySelector(".hopscotch-bubble-container");
    //         console.log(hopBubble.style.top);
    //         if(!sticky) {
    //             return;
    //         } else {
    //             hopBubble.style.top = `${hopBubble.style.top + window.scrollY}px`;
    //         }
    //         console.log(hopBubble.style.top + window.scrollY);
    //     });
    // }

    // start tour
    if(step < steps.length - 1) {
        // console.log("starting tour step: "+step);
        setTimeout(() => (hopscotch.startTour(homeTour, step)), 150);
    }
}

function ajaxSetStep(tour, step, callback = null) {
    $.get(window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php', { 'cmd': 'set_step', 'tour': tour, 'step': step }, function(data) {
        data = JSON.parse(data);
        if(callback != null) {
            callback(data.result);
        }
    });
}

// reset config menu style on tour close
// this needs to be out here because of how the x is now a close tour button and had to get moved in the DOM and I don't want us to have to maintain a custom hopscotch library
function addCloseListener(tour, steps) {
    var hopclose = document.querySelector(".hopscotch-bubble-close");
    var menulink = document.querySelector("#config-menulink");
    var menulinkul = document.querySelector("#config-menulink span > ul");

    function hideConfigMenu() {
        menulink.style.background = "";
        menulinkul.style.display = "none";
    }

    hopclose.addEventListener("click", function() {
        ajaxSetStep(tour, steps);
        if(typeof menulink !== 'undefined' && menulink != null) {
            hideConfigMenu();
            menulink.addEventListener("mouseout", hideConfigMenu);
        }
        var navbtns = document.querySelectorAll(".mainmenu > div");
        navbtns.forEach(navbtn => {
            navbtn.style.background = "";
        });
    });
    // tooltip looks bad IMO, so I'm commenting this out until further notice
    // $(hopclose).tooltip();
    // hopclose.setAttribute("data-original-title", "End Tour");
    if(typeof menulink !== 'undefined' && menulink != null) {
        menulink.addEventListener("mouseout", hideConfigMenu);
    }
}


//////////////////
// STYLE FUNCTIONS
//////////////////

function styleAll(tour = "", steps = 255){
    stylebubble();
    stylecircle();
    stylenextbtn();
    styleclosebtn(tour, steps);
}

function stylebubble() {
    arw = document.querySelector(".hopscotch-bubble-arrow");
    bbl = document.querySelector(".hopscotch-bubble");
    bbl.style.borderRadius = "15px";
    // if(dark_theme) {
    //     arw.style.background = "#333";
    //     bbl.style.background = "#333";
    // }
}

function stylecircle() {
    ccl = document.querySelector(".hopscotch-bubble-number");
    ccl.style.width = "32px";
    ccl.style.height = "32px";
    ccl.style.borderRadius = "50%";
    ccl.style.padding = "0px";
    ccl.style.background = "#4D89F9";
}

function stylecontent() {
    content = document.querySelector(".hopscotch-bubble-content");
}

function stylenextbtn() {
    btns = document.querySelectorAll(".hopscotch-nav-button");
    btns.forEach(element => {
        element.classList.add("btn");
        element.classList.add("btn-primary");
        element.classList.remove("hopscotch-nav-button");
    });
}

function styleclosebtn(tour, steps) {
    btn = document.querySelector(".hopscotch-bubble-close");
    btn.classList.add("btn");
    // choose one
    btn.classList.add("btn-default");
    // btn.classList.add("btn-info");
    btn.innerHTML = "End Tour";
    hopact = document.querySelector(".hopscotch-actions");
    hopact.insertBefore(btn, hopact.firstChild);
    btn.style.float = "left";
    addCloseListener(tour, steps);
}
