let frameObserver = new MutationObserver(function (mutations) {
    if (document.contains(document.getElementById("maincontentframe"))) {
      const mainFrameSrc = document.getElementById("maincontentframe").src;
      if (mainFrameSrc.endsWith("/page-home-main.php")) {
          runHomeTour();
      }
      frameObserver.disconnect();
    }
  });
  
  frameObserver.observe(document, {
    attributes: true,
    childList: true,
    characterData: false,
    subtree: true,
  });
  


// load tour

// THIS SHOULD BE LOOKED INTO IN THE FUTURE IMO -AC
const runHomeTour = () => {
 
    // load tour if on home page   
        var details = {
            'cmd': 'get_step', 
            'tour': 'neptune_intro', 
        };
        
        var formBody = [];
        for (var property in details) {
          var encodedKey = encodeURIComponent(property);
          var encodedValue = encodeURIComponent(details[property]);
          formBody.push(encodedKey + "=" + encodedValue);
        }
        formBody = formBody.join("&");
        
        fetch(window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php?', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded;'
          },
          body: formBody
        }).then((data) => {
            return data.json()
        }).then((data) => {
            if (data.step == null) {
                startHomeTour(0);
            } else {
                startHomeTour(data.step);
            }
        })

        // load tour css because it doesn't work unless I do it here
        var link = document.createElement('link');
        link.rel = 'stylesheet';
        link.type = 'text/css';
        link.href = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/css/hopscotch.css';
        document.getElementsByTagName('head')[0].appendChild(link);

        /* Load the theme specific css. */
       
            var theme_link = document.createElement('link');
            theme_link.rel = 'stylesheet';
            theme_link.type = 'text/css';
            theme_link.href = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/css/hopscotch.neptune.css';
            document.getElementsByTagName('head')[0].appendChild(theme_link);

            var hopscotch_script = document.createElement('script');
            hopscotch_script.type = 'text/javascript';
            hopscotch_script.src = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/js/hopscotch.js';
        
    
// }

/*
 * Home Tour
 *
 *  Points out various features of the home page
 *  and then guides the user to the configuration wizard
 * 
 */
function startHomeTour(step) {
    hopscotch.endTour();
    
    // first child
    var menulink = document.querySelector("#config-menulink");
    var menulinkul = document.querySelector("#config-menulink span > ul");
  
    menulink = parent.document.querySelector("#config-menulink");
    if (menulink === null) {
        menulink = '';
    }
    

    const documentroot = window.parent.document;
    var steps = [
        { // 0
            title: "Welcome to Nagios XI",
            content: "This tour will show you around the Nagios XI interface.",
            target: documentroot.getElementById("home-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            onShow: function() {
                documentroot.getElementById("home-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("home-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.querySelector("#secondary-nav").scrollTop = 0;
                documentroot.getElementById("home-menu-icon").style.background = "";
            }
        }, { // 1
            title: "Quick View",
            content: "<b>Quick View</b> items show you a quick overview of your host and service statuses.",
            target: documentroot.getElementById("menu-home-section-quickview"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onPrev: function() {
                documentroot.getElementById("menu-home-section-quickview").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-quickview").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-quickview").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-quickview").style.background = "";
            },
        }, { // 2
            title: "Details",   
            content: "The <b>Details</b> section items show you more detailed information about your hosts and services.",
            target: documentroot.getElementById("menu-home-section-details"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onPrev: function() {
                documentroot.querySelector("#secondary-nav").scrollTop = 0;
                documentroot.getElementById("menu-home-section-details").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-details").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-details").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-details").style.background = "";
                let leftnav =  documentroot.querySelector("#secondary-nav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            }
        }, { // 3
            title: "Graphs",
            content: "The <b>Graphs</b> section shows you graphs of your host and service status history.",
            target: documentroot.getElementById("menu-home-section-graphs"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            onPrev: function() {
                documentroot.querySelector("#secondary-nav").scrollTop = 0;
                documentroot.getElementById("menu-home-section-graphs").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-graphs").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-graphs").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-graphs").style.background = "";
                let leftnav =  documentroot.querySelector("#secondary-nav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
            }
        }, { // 4
            title: "Maps",
            content: "The <b>Maps</b> section gives you various visual representations of your hosts and services.",
            target: documentroot.getElementById("menu-home-section-maps"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            onPrev: function() {
                let leftnav =  documentroot.querySelector("#secondary-nav");
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
                documentroot.getElementById("menu-home-section-maps").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-maps").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-maps").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-maps").style.background = "";
                let leftnav = documentroot.querySelector('#secondary-nav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
            }
        }, { // 5
            title: "Incident Management",
            content: "The <b>Incident management</b> section gives you a number of ways to view and manage incidents on your Hosts/Services.",
            target: documentroot.getElementById("menu-home-section-incident-management"),
            placement: "right",
            yOffset: -125,
            xOffset: 5,
            arrowOffset: 125,
            onPrev: function() {
                let leftnav =  documentroot.querySelector('#secondary-nav');
                let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
                leftnav.scrollTop = scroll50;
                documentroot.getElementById("menu-home-section-incident-management").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-incident-management").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-incident-management").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-incident-management").style.background = "";
                let leftnav =  documentroot.querySelector('#secondary-nav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
            }
        }, { // 6
            title: "Monitoring Process",
            content: "The <b>Monitoring Process</b> section gives an overview of the Nagios XI server's monitoring processes.",
            target: documentroot.getElementById("menu-home-section-monitoringprocess"),
            placement: "right",
            yOffset: -125,
            xOffset: 5,
            arrowOffset: 125,
            // arrowOffset: -100000,
            onPrev: function() {
                let leftnav =  documentroot.querySelector('#secondary-nav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
                documentroot.getElementById("menu-home-section-monitoringprocess").style.background = "";
            },
            onShow: function() {
                documentroot.getElementById("menu-home-section-monitoringprocess").style.background = "hsl(var(--muted))";
                documentroot.getElementById("menu-home-section-monitoringprocess").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                documentroot.getElementById("menu-home-section-monitoringprocess").style.background = "";
                documentroot.querySelector('#secondary-nav').scrollTop = 0;
            }
        }, { // 7
            title: "Visualizations",
            content: "The <b>Views/Dashboards/Reports</b> sections give you a number of ways to view your hosts and services.",
            target: documentroot.getElementById("dashboards-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onPrev: function() {
                let leftnav =  documentroot.querySelector('#secondary-nav');
                leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
                documentroot.getElementById("views-menu-icon").style.background = "";
                documentroot.getElementById("dashboards-menu-icon").style.background = "";
                documentroot.getElementById("reports-menu-icon").style.background = "";
            },
            onShow: function() {
                // darken views/dashboards/reports
                documentroot.getElementById("views-menu-icon").style.background ="hsl(var(--muted))";
                documentroot.getElementById("dashboards-menu-icon").style.background ="hsl(var(--muted))";
                documentroot.getElementById("reports-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("views-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
                documentroot.getElementById("dashboards-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
                documentroot.getElementById("reports-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onNext: function() {
                // reset views/dashboards/reports color
                documentroot.getElementById("views-menu-icon").style.background = "";
                documentroot.getElementById("dashboards-menu-icon").style.background = "";
                documentroot.getElementById("reports-menu-icon").style.background = "";
            }
        }, { // 8
            title: "Configuration Menu",
            content: "The <b>Configuration Menu</b> allows you to configure various aspects of Nagios XI.",
            target: documentroot.getElementById("config-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("config-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("config-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("config-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("config-menu-icon").style.background = "";
            }
        }, { // 9
            title: "Help Menu",
            content: "The <b>Help Menu</b> contains various documentation and resources to help you get started and learn about Nagios XI.",
            target: documentroot.getElementById("help-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("help-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("help-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("help-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("help-menu-icon").style.background = "";
            }
        }, { // 10
            title: "Tools",
            content: "<b>Tools</b> are user-defined utilities that you can quickly access from Nagios using your web browser.",
            target: documentroot.getElementById("tools-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("tools-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("tools-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("tools-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("tools-menu-icon").style.background = "";
            }
        }, { // 11
            title: "Admin",
            content: "The <b>Admin</b> pages allow you to modify many different aspects of your Nagios XI server.",
            target: documentroot.getElementById("admin-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("admin-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("admin-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("admin-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("admin-menu-icon").style.background = "";
            }
        }, { // 12
            title: "Enterprise Features",
            content: "The <b>Enterprise Features</b> page has a quick menu for accessing all of your enterprise Nagios XI features.",
            target: documentroot.getElementById("enterprise-menu-icon"),
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("enterprise-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("enterprise-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("enterprise-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("enterprise-menu-icon").style.background = "";
            }
        }, { // 13
            title: "Account",
            content: "Your <b>Account</b> page allows you to customize various things for your user experience from <b>password</b> to <b>email</b> to <b>theme</b>. You can also restart tours from here.",
            target: "account-menu-icon",
            placement: "right",
            yOffset: -10,
            xOffset: 5,
            // arrowOffset: -100000,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("account-menu-icon").style.background = "hsl(var(--muted))";
                documentroot.getElementById("account-menu-icon").style.borderRadius = "calc(var(--radius) - 2px)";
            },
            onPrev: function() {
                documentroot.getElementById("account-menu-icon").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("account-menu-icon").style.background = "";
            }
        }, { // 14
            title: "System Status",
            content: "The <b>System Status</b> indicator gives you an overview of the health of your Nagios XI system. Click for a breakdown of various components of the system.",
            target:  documentroot.getElementById("system-status-button"),
            placement: "bottom",
            xOffset: 45,
            // arrowOffset: -100000,
            onShow: function() {
                ajaxSetStep('home', 14)
                addCloseListener();
            }
        }, { // 15
            title: "Search",
            content: "The <b>Search</b> box allows you to quickly search for hosts and services and pages within Nagios XI, including Dashboards, Reports and Views.",
            target: documentroot.getElementById("header-search-box"),
            placement: "bottom",
            xOffset: -150,
            arrowOffset: 250,
            onShow: function() {
                addCloseListener();
                
                documentroot.getElementById('header-search-box').style.borderColor = 'white'
            },
            onPrev: function() {
                documentroot.getElementById('header-search-box').style.borderColor = 'hsl(var(--border))'
            },
            onNext: function() {
                documentroot.getElementById('header-search-box').style.borderColor = 'hsl(var(--border))'
            }
        }, { // 16
            title: "Changelog",
            content: "The <b>Changelog</b> lists the changes between different versions of Nagios XI.",
            target: documentroot.getElementById("changelog-button"),
            placement: "bottom",
            arrowOffset: 200,
            xOffset: -150,
            onShow: function() {
                addCloseListener();
                
                documentroot.getElementById('changelog-button').style.borderColor = 'white'
            },
            onPrev: function() {
                documentroot.getElementById('changelog-button').style.borderColor = 'transparent'
            },
            onNext: function() {
                documentroot.getElementById('changelog-button').style.borderColor = 'transparent'
            }
        }, { // 17
            title: "Help Resources",
            content: "The <b>Help Resources</b> contains links to documentation, Nagios support, the Community Forums, the Nagios Exchange where you can find community made addins and a link to submit feedback about Nagios XI.",
            target: documentroot.getElementById("help-resources-button"),
            placement: "bottom",
            arrowOffset: 280,
            xOffset: -275,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("help-resources-button").style.background = "hsl(var(--muted))";
            },
            onPrev: function() {
                documentroot.getElementById("help-resources-button").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("help-resources-button").style.background = "";
            }
        }, { // 18
            title: "Profile",
            content: "The <b>Profile Dropdown</b> contains a link to your Account Page and the Logout button.",
            target: documentroot.getElementById("profile-dropdown-button"),
            placement: "bottom",
            arrowOffset: 280,
            xOffset: -275,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("profile-dropdown-button").style.background = "hsl(var(--muted))";
            },
            onPrev: function() {
                documentroot.getElementById("profile-dropdown-button").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("profile-dropdown-button").style.background = "";
            }
        }, { // 19
            title: "Page Actions",
            content: "The <b>Page Actions</b> dropdown contains page-specific actions such as Schedule Page, that allows you to schedule a recurring report of the current page.",
            target: documentroot.getElementById("page-action-button"),
            placement: "left",
            // arrowOffset: -100000,
            yOffset: -7,
            xOffset: 5,
            onShow: function() {
                addCloseListener();
                documentroot.getElementById("page-action-button").style.background = "hsl(var(--muted))";
            },
            onPrev: function() {
                documentroot.getElementById("page-action-button").style.background = "";
            },
            onNext: function() {
                documentroot.getElementById("page-action-button").style.background = "";
            }
        }, { // 20
            title: "Use a Wizard!",
            content: "Let's set up monitoring via a wizard! You can hover the gear icon and Click <b>Configuration Wizards</b> or hit <b>Next</b> to continue.",
            target: documentroot.getElementById("config-menu-icon"),
            placement: "top",
            yOffset: -1,
            xOffset: 38,
            nextOnTargetClick: true,
            multipage: true,
            onShow: function() {
                addCloseListener();
                window.dispatchEvent(new Event('open-tooltip'));
                documentroot.getElementById("config-menu-icon").style.background = "hsl(var(--muted))";
                setTimeout(() => {
                    if (documentroot.getElementById("config-tour-popup").style.display != "none") {
                        documentroot.getElementById("config-tour-popup").style.background = "hsl(var(--muted))";
                        documentroot.getElementById("config-tour-popup").addEventListener("click", function() {
                                hopscotch.nextStep();
                        });
                    }

                }, 200);
            },
            onPrev: function() {
                documentroot.getElementById("config-menu-icon").style.background = "";
                documentroot.getElementById("config-tour-popup").style.background = "";
                window.dispatchEvent(new Event('close-tooltip'));
            },
            onNext: function() {
                window.dispatchEvent(new Event('close-tooltip'));
                ajaxSetStep("wizard-landing", 0);
                setTimeout(() => {
                    window.location = window.location.origin + "/nagiosxi/config/?xiwindow=monitoringwizard.php";
                }, 200);
            }
        },  { // 18
            // needs empty step for last step to have a next button, 
            // but can't make the other steps part of this wizard because 
            // the next step is in an iframe
        } 
    ]

    // add behaviors to each step:    
    let counter = 1;
    function addBehavior(oldBehavior, extraBehavior, currentStep) {
        return function() {
            if (typeof currentStep !== 'undefined') {
                extraBehavior(currentStep);
            } else {
                extraBehavior();
            }

            if (oldBehavior) {
                oldBehavior();
            }
        };
    }

    steps = steps.map(step => {
        // Add extra behavior to onShow
        step.onShow = addBehavior(step.onShow, () => styleAll("neptune_intro", steps.length));
        step.onShow = addBehavior(step.onShow, addCloseListener);

        step.showPrevButton = true;

        // Add extra behavior to onPrev
        step.onPrev = addBehavior(step.onPrev, (currentStep) => {
            ajaxSetStep("neptune_intro", currentStep - 2);
        }, counter);

        // Add extra behavior to onNext
        step.onNext = addBehavior(step.onNext, (currentStep) => {
            ajaxSetStep("neptune_intro", currentStep);
        }, counter);
        counter++;
        return step;
    });

    // user has completed tour (empty last step to allow next button to show)
    if (step > steps.length - 1) {
        return;
    }

    // ::CAREFUL:: if you add steps, you need to update this ::CAREFUL::
    // pre-show things that need to happen before the step is shown for timing reasons
    if (step == 3 || step == 4) {
        let leftnav = document.querySelector("#secondary-nav");
        let scroll50 = (leftnav.scrollHeight - leftnav.clientHeight) / 2;
        leftnav.scrollTop = scroll50;
    } else if (step == 5 || step == 6) {
        let leftnav = document.querySelector("#secondary-nav");
        leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
        //leftnav.scrollTop = leftnav.scrollHeight - leftnav.clientHeight;
    }
    
    homeTour = {
        id: "neptune-home-tour",
        steps: steps,
    }

    // start tour
    if(step < steps.length - 1) {
        setTimeout(() => (
            hopscotch.startTour(homeTour, step)
        ), 150);
    }
}
}
function ajaxSetStep(tour, step, callback = null) {
    var details = {
        'cmd': 'set_step', 
        'tour': tour, 
        'step': step
    };
    
    var formBody = [];
    for (var property in details) {
      var encodedKey = encodeURIComponent(property);
      var encodedValue = encodeURIComponent(details[property]);
      formBody.push(encodedKey + "=" + encodedValue);
    }
    formBody = formBody.join("&");
    
    fetch(window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php?', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded;'
      },
      body: formBody
    }).then((response) => {
        return response.json()
    }).then((data) => {
        if (callback != null) {
            callback(data.result);
        }
    })
    
    // I THINK THIS IS BROKEN NGL
    // fetch(window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php', { 'cmd': 'set_step', 'tour': tour, 'step': step }, function(data) {
    //     data = JSON.parse(data);
    //     if (callback != null) {
    //         callback(data.result);
    //     }
    // });
}

// reset config menu style on tour close
// this needs to be out here because of how the x is now a close tour button and had to get moved in the DOM and I don't want us to have to maintain a custom hopscotch library
function addCloseListener(tour, steps) {
    var hopclose = document.querySelector(".hopscotch-bubble-close");
    hopclose.addEventListener("click", function() {
        ajaxSetStep(tour, steps);
        if(typeof menulink !== 'undefined' && menulink != null) {
            hideConfigMenu();
            menulink.addEventListener("mouseout", hideConfigMenu);
        }
        unsetTourStyles();
        window.dispatchEvent(new Event('close-tooltip'));
    });
    // tooltip looks bad IMO, so I'm commenting this out until further notice
    // $(hopclose).tooltip();
    // hopclose.setAttribute("data-original-title", "End Tour");
    if(typeof menulink !== 'undefined' && menulink != null) {
        menulink.addEventListener("mouseover", showConfigMenu);
        menulink.addEventListener("mouseout", hideConfigMenu);
    }
  
}


//////////////////
// STYLE FUNCTIONS
//////////////////
const unsetTourStyles = () => {
    document.getElementById("home-menu-icon").style.background = "";
    document.getElementById("menu-home-section-quickview").style.background = "";
    document.getElementById("menu-home-section-details").style.background = "";
    document.getElementById("menu-home-section-graphs").style.background = "";
    document.getElementById("menu-home-section-maps").style.background = "";
    document.getElementById("menu-home-section-incident-management").style.background = "";
    document.getElementById("menu-home-section-monitoringprocess").style.background = "";
    document.getElementById("views-menu-icon").style.background = "";
    document.getElementById("dashboards-menu-icon").style.background = "";
    document.getElementById("reports-menu-icon").style.background = "";
    document.getElementById("config-menu-icon").style.background = "";
    document.getElementById("help-menu-icon").style.background = "";
    document.getElementById("tools-menu-icon").style.background = "";
    document.getElementById("admin-menu-icon").style.background = "";
    document.getElementById("enterprise-menu-icon").style.background = "";
    document.getElementById("account-menu-icon").style.background = "";
    document.getElementById("header-search-box").style.borderColor = "hsl(var(--border))";
    document.getElementById("changelog-button").style.borderColor = "transparent";
    document.getElementById("help-resources-button").style.background = "";
    document.getElementById("profile-dropdown-button").style.background = "";
    document.getElementById("page-action-button").style.background = "";
}
function styleAll(tour = "", steps = 255){
    stylebubble();
    stylecircle();
    stylenextbtn();
    styleclosebtn(tour, steps);
}

function stylebubble() {
    arw = document.querySelector(".hopscotch-bubble-arrow");
    bbl = document.querySelector(".hopscotch-bubble");
    bbl.style.borderRadius = "15px";
}

function stylecircle() {
    ccl = document.querySelector(".hopscotch-bubble-number");
    ccl.style.width = "32px";
    ccl.style.height = "32px";
    ccl.style.borderRadius = "50%";
    ccl.style.padding = "0px";
    ccl.style.background = "#4D89F9";
}

function stylecontent() {
    content = document.querySelector(".hopscotch-bubble-content");
}

function stylenextbtn() {
    btns = document.querySelectorAll(".hopscotch-nav-button");
    btns.forEach(element => {
        element.classList.add("btn");
        element.classList.add("btn-primary");
        element.classList.remove("hopscotch-nav-button");
    });
}

function styleclosebtn(tour, steps) {
    btn = document.querySelector(".hopscotch-bubble-close");
    btn.classList.add("btn");
    // choose one
    btn.classList.add("btn-default");
    // btn.classList.add("btn-info");
    btn.innerHTML = "End Tour";
    hopact = document.querySelector(".hopscotch-actions");
    hopact.insertBefore(btn, hopact.firstChild);
    btn.style.float = "left";
    addCloseListener(tour, steps);
}
