    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>">
    <input type="hidden" id="operation" name="operation" value="<?= (!empty($operation)) ? encode_form_val($operation) : "" ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= (!empty($selectedhostconfig)) ? encode_form_val($selectedhostconfig) : "" ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="url" value="<?= (!empty($url)) ? encode_form_val($url) : "" ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    $services = array();
    if (array_key_exists('website_wizard_services', $_SESSION)) {
        $services = $_SESSION['website_wizard_services'];
    }
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Website Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="url" class="form-label"><?= _('Website URL') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="url" id="url" value="<?= (!empty($url)) ? encode_form_val($url) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Website URL") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the URL") ?>
                    </div>
                    <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this website.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip" class="form-label"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address associated with the website fully qualified domain name (FQDN).')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="ip" id="ip" value="<?= (!empty($ip)) ? encode_form_val($ip) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Website Options') ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ssl" class="form-check-input" name="ssl"  <?= is_checked($ssl, "on") ?> >
                        <label for="ssl" class="form-check-label bold"><?= _('Use SSL') ?> <?= xi6_info_tooltip(_('Monitor the website using SSL/HTTPS.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port to use when contacting the website')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= (!empty($port)) ? encode_form_val($port) : "" ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="onredirect" class="form-label form-item-required"><?= _('On Redirect') ?> <?= xi6_info_tooltip(_('How to handle redirected pages. Sticky is like follow but will stick to the specified IP address. Stickyport ensures the port stays the same.')) ?></label>
                <div class="input-group position-relative">
                    <select name="onredirect" id="onredirect" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select On Redirect:") ?>" >
                        <option <?= is_selected($onredirect, 'ok') ?>>ok</option>
                        <option <?= is_selected($onredirect, 'warning') ?>>warning</option>
                        <option <?= is_selected($onredirect, 'critical') ?>>critical</option>
                        <option <?= is_selected($onredirect, 'follow') ?>>follow</option>
                        <option <?= is_selected($onredirect, 'sticky') ?>>sticky</option>
                        <option <?= is_selected($onredirect, 'stickyport') ?>>stickyport</option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select on Redirect") ?>
                    </div>
                    <i id="onredirect_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <label for="username" class="form-label bold m-0 ms-1"><?= _('Credentials') ?> <span class="fw-normal"> (<?= _('optional') ?>)</span> <?= xi6_info_tooltip(_('Basic authentication, only! The username and password used to authenticate to the website.')) ?></label>
                <fieldset class="row">
                    <div class="col-sm-5 ps-2 pe-0">
                        <div class="input-group input-group-sm">
                            <input type="text" name="username" id="username" value="<?= (!empty($username)) ? encode_form_val($username) : "" ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _('Username') ?>">

                            <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-5 ps-2 pe-0">
                        <div class="input-group input-group-sm">
                            <input type="text" id="password" name="password" value="<?= (!empty($password)) ? encode_form_val($password) : "" ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _('Password') ?>">

                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Website Services') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the website.') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="http" class="form-check-input" name="services[]" value='http'  <?php echo in_array('http', $services) ? 'checked' : ''; ?>>
                        <label for="http" class="form-check-label bold"><?= _('HTTP') ?> <?= xi6_info_tooltip(_("Includes basic monitoring of the website to ensure the web server responds with a valid HTTP response.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ping" class="form-check-input" name="services[]" value='ping' <?php echo in_array('ping', $services) ? 'checked' : ''; ?>>
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the website server with an ICMP ping. Useful for watching network latency and general uptime of your web server. Not all web servers support this.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="dns" class="form-check-input" name="services[]" value='dns'  <?php echo in_array('dns', $services) ? 'checked' : ''; ?>>
                        <label for="dns" class="form-check-label bold"><?= _('DNS Resolution') ?> <?= xi6_info_tooltip(_("Monitors the website DNS name to ensure it resolves to a valid IP address.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="dnsip" class="form-check-input" name="services[]" value='dnsip'  <?php echo in_array('dnsip', $services) ? 'checked' : ''; ?>>
                        <label for="dnsip" class="form-check-label bold"><?= _('DNS IP Match') ?> <?= xi6_info_tooltip(_("Monitors the website DNS name to ensure it resolves to the current known IP address. Helps ensure your DNS does not change unexpectedly, which may mean a security breach has occurred.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="httpcontent" class="form-check-input rounded" name="services[]" value='httpcontent'  <?php echo in_array('httpcontent', $services) ? 'checked' : ''; ?>>
                        <label for="httpcontent" class="form-check-label bold"><?= _('Web Page Content') ?> <?= xi6_info_tooltip(_("Monitors the website to ensure the specified string is found in the content of the web page. A content mismatch may indicate that your website has experienced a security breach or is not functioning correctly.")) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0 pt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <?= _('Content') ?>
                            </span>
                            <input type="text" id="httpcontentstr" name="serviceargs[httpcontentstr]" value="<?= (!empty($httpcontentstr)) ? encode_form_val($httpcontentstr) : "" ?>" class="form-control form-control-sm monitor rounded-end" placeholder="Page Content String">

                            <i id="httpcontentstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="httpregex" class="form-check-input" name="services[]" value='httpregex'  <?php echo in_array('httpregex', $services) ? 'checked' : ''; ?> >
                        <label for="httpregex" class="form-check-label bold"><?= _('Web Page Regular Expression') ?> <?= xi6_info_tooltip(_("Monitors the website to ensure the specified regular expression is found in the content of the web page. A content mismatch may indicate that your website has experienced a security breach or is not functioning correctly.")) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0 pt-0 ps-2">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <?= _('Reg Ex') ?>
                            </span>
                            <input type="text" id="httpregexstr" name="serviceargs[httpregexstr]" value="<?= (!empty($httpregexstr)) ? encode_form_val($httpregexstr) : "" ?>" class="form-control form-control-sm monitor rounded-end">

                            <i id="httpregexstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    if ($ssl == "on") {
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="sslcert" class="form-check-input" name="services[]" value='sslcert'  <?= is_checked($ssl, 1) ?> >
                        <label for="sslcert" class="form-check-label bold"><?= _('SSL Certificate') ?> <?= xi6_info_tooltip(_("Monitors the expiration date of the website&apos;s SSL certificate and alerts you if it expires within the specified number of days. Helps ensure that SSL certificates do not inadvertently go un-renewed.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <label for="sslcertdays" class="form-label m-0 ms-1 align-middle"><?= _('Days To Expiration') ?></label>
                            </span>
                            <input type="text" id="sslcertdays" name="serviceargs[sslcertdays]" value="<?= (!empty($sslcertdays)) ? encode_form_val($sslcertdays) : "" ?>" class="form-control form-control-sm monitor">

                            <i id="sslcertdays_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }
?>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
