<?php
//
// Proxy Component
// Copyright (c) 2008-2019 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs 
grab_request_vars();
check_prereqs();
check_authentication(false);

// Only admins can access this page
is_admin_with_error_message();

route_request();


function route_request()
{
    global $request;

    if (isset($request['update'])) {
        do_update_options();
    } else {
        show_options();
    }
}


function show_options($error = false, $msg = "")
{
    global $request;

    // Proxy options
    $use_proxy = grab_request_var("use_proxy", get_option('use_proxy', 0)); //checkbox
    $proxy_address = grab_request_var("proxy_address", get_option('proxy_address', ''));
    $proxy_port = grab_request_var("proxy_port", get_option('proxy_port', ''));
    $proxy_auth = grab_request_var("proxy_auth", get_option('proxy_auth', ''));
    $proxy_tunnel = grab_request_var("proxy_tunnel", get_option('proxy_tunnel', 1));

    do_page_start(array("page_title" => _("Proxy Configuration")), true);
?>

    <h1><?php echo _("Proxy Configuration"); ?></h1>

    <p class="neptune-subtext"><?php echo _("Set up the proxy that Nagios XI will use when contacting the Nagios update server."); ?></p>

    <?php display_message($error, false, $msg); ?>
    
    <?php if (is_neptune()) { echo neptune_section_spacer(); } ?>

    <form id="manageOptionsForm" class="neptune-admin-config-table neptune-admin-config-table-150" method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">

        <input type="hidden" name="options" value="1">
        <?php echo get_nagios_session_protector(); ?>
        <input type="hidden" name="update" value="1">

        <?php if (!is_neptune()) { ?>
        <div class="checkbox" style="margin: 15px 0;">
            <label>
                <input type="checkbox" class="checkbox" id="use_proxy" name="use_proxy" <?php echo is_checked($use_proxy, 1); ?>>
                <?php echo _("Enable proxy for update checks"); ?>
            </label>
        </div>
        <?php } else {
            echo neptune_centered_checkbox(_('Enable proxy for update checks'), "use_proxy", "use_proxy", $use_proxy, 1);
        } ?>

        <?php if (!is_neptune()) { ?>
            <h5 class="ul"><?php echo _("Proxy Settings"); ?></h5>
        <?php } else {
            echo neptune_section_spacer();
            echo neptune_heading(_('Proxy Settings'));
        } ?>

        <table class="table table-no-border table-condensed table-auto-width">
            <tr>
                <td><label for="proxy_address"><?php echo _("Proxy Address"); ?>:</label></td>
                <td>
                    <input type="text" size="45" name="proxy_address" id="proxy_address" value="<?php echo encode_form_val($proxy_address); ?>" class="textfield form-control">
                </td>
            </tr>
            <tr>
                <td><label for="adminNameBox"><?php echo _("Proxy Port"); ?>:</label></td>
                <td>
                    <input type="text" size="4" name="proxy_port" id="proxy_port" value="<?php echo encode_form_val($proxy_port); ?>" class="textfield form-control">
                </td>
            </tr>
            <tr>
                <td><label for="proxy_auth"><?php echo _("Proxy Auth"); ?>:</td>
                <td>
                    <input type="text" size="30" name="proxy_auth" id="proxy_auth" value="<?php echo encode_form_val($proxy_auth); ?>" class="textfield form-control" placeholder="username:password">
                </td>
            </tr>
            <tr>
                <td></td>
                <?php if (!is_neptune()) { ?>
                    <td class="checkbox">
                        <label>
                            <input type="checkbox" class="checkbox" id="proxy_tunnel" name="proxy_tunnel" <?php echo is_checked($proxy_tunnel, 1); ?>>
                            <?php echo _("Use HTTP tunnel"); ?>
                        </label>
                    </td>
                <?php } else { ?>
                    <td>
                        <?php
                        echo neptune_centered_checkbox(_('Use HTTP tunnel'), "proxy_tunnel", "proxy_tunnel", $proxy_tunnel, 1);
                        ?>
                    </td>
                <?php } ?>
            </tr>
        </table>

        <div id="formButtons" style="margin-top: 30px;">
            <button type="submit" class="submitbutton btn btn-sm btn-primary" name="updateButton" id="updateButton" style="margin: 0;"><?php echo _('Update Settings'); ?></button>
            <a href="../../../admin/main.php" class="btn btn-sm btn-default"><?php echo _('Cancel'); ?></a>
        </div>

    </form>

    <?php

    do_page_end(true);
    exit();
}

function do_update_options()
{
    global $request;

    // Check session
    check_nagios_session_protector();

    $errmsg = array();
    $errors = 0;

    // Proxy address
    $use_proxy = checkbox_binary(grab_request_var('use_proxy', ''));

    $proxy_address = grab_request_var('proxy_address', '');
    $proxy_port = grab_request_var('proxy_port', '');
    $proxy_auth = grab_request_var('proxy_auth', '');
    $proxy_tunnel = checkbox_binary(grab_request_var('proxy_tunnel', ''));

    // handle errors
    if ($errors > 0)
        show_options(true, $errmsg);

    // update options
    set_option('use_proxy', $use_proxy);
    set_option('proxy_address', $proxy_address);
    set_option('proxy_port', $proxy_port);
    set_option('proxy_auth', $proxy_auth);
    set_option('proxy_tunnel', $proxy_tunnel);

    // success!
    show_options(false, "Proxy settings updated successfully!");
}