<?php
//
// Dashlet that generically gets host / service data to be used in visualizations
// Uses highcharts, refreshes, label links

include_once(dirname(__FILE__).'/../dashlethelper.inc.php');

// Run the initialization function
highchart_dashlet_init();

function highchart_dashlet_init() {
	$name = "highchart-dashlet";
	
	$args = array(
		DASHLET_NAME => $name,
		DASHLET_VERSION => "2.1.2",
		DASHLET_AUTHOR => "Nagios Enterprises, LLC",
		DASHLET_DESCRIPTION => _("A highchart dashlet."),
		DASHLET_COPYRIGHT => "Copyright (c) 2025 Nagios Enterprises, LLC",
		DASHLET_FILTER_GROUPS => array("metrics"),
		DASHLET_HOMEPAGE => "https://www.nagios.com",
		DASHLET_REFRESHRATE => 60,
		DASHLET_FUNCTION => "highchart_dashlet_func",
		DASHLET_TITLE => _("Highchart Dashlet"),
		DASHLET_JS_FILE => "highchart-dashlet.js",
		DASHLET_OUTBOARD_CLASS=> "highchart_dashlet_outboardclass",
		DASHLET_INBOARD_CLASS => "highchart_dashlet_inboardclass",
		DASHLET_PREVIEW_CLASS => "highchart_dashlet_previewclass",
		DASHLET_WIDTH => "400",
		DASHLET_HEIGHT => "300",
		DASHLET_OPACITY => "1.0",
        DASHLET_ISCUSTOM => false
	);
		
	register_dashlet($name, $args);
}
	
function highchart_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null) {
	$output = "";
	switch ($mode) {
		// Config options for dashlify popup modal
		case DASHLET_MODE_GETCONFIGHTML:
		
			$output .= '

				<div class="form-group">
					<label for="graphChoiceSelect">'._('Graph Type').'</label>
					<div class="popup-form-box">
						<select class="form-control" name="graphChoiceSelect" id="graphChoiceSelect" onchange="switch_sort(this.value)">
							<option value="bar">'._('Bar Chart').'</option>
							<option value="barstacked">'._('Stacked Bar Chart').'</option>
							<option value="column">'._('Column Chart').'</option>
							<option value="columnstacked">'._('Stacked Column Chart').'</option>
							<option value="columnpyramid">'._('Pyramid Column Chart').'</option>
							<option value="radial">'._('Radial Bar Chart').'</option>
							<option value="line">'._('Line Graph').'</option>
							<option value="spline">'._('Spline Graph').'</option>
							<option value="area">'._('Area Chart').'</option>
							<option value="areaspline">'._('Spline Area Chart').'</option>
							<option value="pie">'._('Pie Chart').'</option>
							<option value="donut">'._('Donut Chart').'</option>
						</select>
					</div>
					<div class="popup-form-box">
						<label>Limit To</label>
						<select id="group_select" class="form-control" onchange="show_dashlet_selection(this.value)">
							<option value="all">' . _("All Hosts and Services") . '</option>
							<option value="host" class="hide">' . _("Host") . '</option>
							<option value="hostgroup">' . _("Hostgroup") . '</option>
							<option value="servicegroup">' . _("Servicegroup") . '</option>
						</select>
					</div>';
			$output .= dashlet_host_select();
			$output .= dashlet_hostgroup_select();
			$output .= dashlet_servicegroup_select();
			$output .= '
					<div id="sort_select" class="popup-form-box">
						<label for="sortChoiceSelect">'._('Sort By').'</label>
						<div>
							<select class="form-control" name="sortChoiceSelect" id="sortChoiceSelect">
								<option value="default">'._('Name').'</option>
								<option value="total_ok">'._('Total Ok').'</option>
								<option value="total_warning">'._('Total Warning').'</option>
								<option value="total_unknown">'._('Total Unknown').'</option>
								<option value="total_critical">'._('Total Critical').'</option>
							</select>
						</div>
					</div>
        </div>';
			break;

		// How the dashlet displays based on inboard (in dashboard)
		// vs. outboard (just in a page)
		case DASHLET_MODE_OUTBOARD:
		case DASHLET_MODE_INBOARD:
			// Random dashlet id
			$divId = uniqid();
			if (grab_array_var($args, "divId") != NULL) { // If we're coming from the cool dashboard, link the existing uniqid
				$divId = $args["divId"];
			}
			
            $url = "includes/dashlets/highchart-dashlet/make_highchart.php";
			
			if (grab_array_var($args, "coolMode") == NULL) {
				$url .= "?mode=getbetterchart&divId=" . $divId;
			}
			else {
				$url .= "?mode=coolmodeactivated&divId=" . $divId;
				$output .= '
							<div class="dashifybutton2">
                	<a class="dashifybutton2 tt-bind" id="dashify2' . $divId . '" href="#" title="Add to Dashboard"><i class="fa fa-14 fa-sign-in fa-rotate-270"></i></a>
            	</div>';
			}
			
            // Check to make sure it's not using static hardcoded IPs
            if (strpos($url, "://") === FALSE) {
                $url = get_base_url() . $url;
            }

            // Availability args
            foreach ($args as $key => $val) {
                if ($mode == DASHLET_MODE_INBOARD && $key == 'data') { continue; }
				if (is_array($val)) {
					$val = implode(", ", $val);
				}
                $url .= "&" . $key . "=" .  urlencode($val);
            }

            $size = "";
            if ($mode == DASHLET_MODE_OUTBOARD) {
                $size = ' style="width: 400px; height: 300px;"';
            }

            $output .= '
            <div class="highchart_dashlet" cool-highchart-count="' . grab_array_var($args, "coolMode") . '" id="' . $divId . '"'.$size.'>
            ' . get_throbber_html() . '
            </div>

            <script type="text/javascript">
            $(document).ready(function() {

                get_' . $divId . '_content("true");

                // Re-build the content when we resize
                $("#' . $divId . '").closest(".ui-resizable").on("resizestop", function(e, ui) {
                    get_' . $divId . '_content("false");
                });
				
				setTimeout(function() {
					$(".highcharts-button").click(function () {
						let highestZIndex = 0;
						$(".dashboarddashletcontainer").each(function() {
							let zIndex = parseInt($(this).css("z-index"), 10);
							if (zIndex > highestZIndex) {
								highestZIndex = zIndex;
							}
						});
						$(this).closest(".dashboarddashletcontainer").css("z-index", highestZIndex + 1);
					});
				}, 500);
				';

				if (grab_array_var($args, "coolMode") != NULL) {
					$graph_choice = $args["graphChoiceSelect"];
					$sort_choice = $args["sortChoiceSelect"];
					$name = base64_encode(json_encode(array(DASHLET_NAME => "highchart-dashlet")));

					$output .= '
					$("#dashify2' . $divId . '").click(function() {
						dashify_highchart(' . json_encode($graph_choice) . ', ' . json_encode($sort_choice) . ', ' . json_encode($name) . ');
					});

					$("#dashify2' . $divId . '").hover(
						function () {
							$("#' . $divId . '"'.$size.').addClass("graphdashlethover").fadeTo(0, 0.40);
						},
						function () {
							$("#' . $divId . '"'.$size.').removeClass("graphdashlethover").fadeTo(0, 1.00);
						}
					);';
				}
				$output .= '
                // Auto-update every x amount of time
                setInterval(get_' . $divId . '_content, 300*1000);
            });

            function get_' . $divId . '_content(animation, height, width)
            {	
                if (height == undefined) { var height = $("#' . $divId . '").parent().height(); }
                if (width == undefined) { var width = $("#' . $divId . '").parent().width(); }
				if (animation == undefined) { var animation = "false"; }
                $("#' . $divId . '").load("' . $url . '&height="+height+"&width="+width+"&animation="+animation);	
            }
            </script>'; 
			break;
			
		case DASHLET_MODE_PREVIEW:
			if(!is_neptune()) {
                $output = "<img src='/nagiosxi/includes/dashlets/highchart-dashlet/highchart_dashlet.png' alt='No Preview Available' />";
			} else if (get_theme() == 'neptunelight') {
                $output = "<img src='/nagiosxi/includes/dashlets/highchart-dashlet/highchart_neptune_light_preview.png' alt='No Preview Available' />";
            } else {
                $output = "<img src='/nagiosxi/includes/dashlets/highchart-dashlet/neptune_preview.png' alt='No Preview Available' />";
            }
			break;			
		}
	return $output;
}
