<?php

require_once(dirname(__FILE__) . '/../../common.inc.php');

// Start session
init_session(false, false);

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs(false);
check_authentication(false);
check_nagios_session_protector();

do_the_thing();

function do_the_thing() {
	$container = grab_request_var('container', '');
	// Note: these 'default' values should never be triggered - we fill in defaults in snmptraps.inc.php already
	$interval_value = intval(grab_request_var('interval_value', '5'));
	$interval_unit  = strtoupper(grab_request_var('interval_unit', "MINUTE"));
	$lookback_value = intval(grab_request_var('lookback_value', "90"));
	$lookback_unit  = strtoupper(grab_request_var('lookback_unit', "MINUTE"));

	$interval_unit = snmptrapvolume_interval_as_mysql($interval_unit);
	$lookback_unit = snmptrapvolume_interval_as_mysql($lookback_unit);

	$interval_in_seconds = $interval_value * snmptrapvolume_interval_as_multiplier($interval_unit);
	$lookback_in_seconds = $lookback_value * snmptrapvolume_interval_as_multiplier($lookback_unit);

	$sql = 'SELECT 
	            COUNT(*) as count, 
	            FROM_UNIXTIME(
	            	UNIX_TIMESTAMP(trapdata_log_datetime) - 
	            	MOD(UNIX_TIMESTAMP(trapdata_log_datetime), '.$interval_in_seconds.')
	            ) as bucket,
	            UNIX_TIMESTAMP(trapdata_log_datetime) - MOD(UNIX_TIMESTAMP(trapdata_log_datetime), '.$interval_in_seconds.') as unixtime
	        FROM xi_cmp_trapdata_log 
	        WHERE trapdata_log_datetime > DATE_SUB(NOW(), INTERVAL '.$lookback_in_seconds.' SECOND)
	        GROUP BY bucket';

	$result = exec_sql_query(DB_NAGIOSXI, $sql);
	if ($result === null) {
		return;
	}

	$data = $result->GetArray();
	$i = 0;

	$totals = "";
	$timestamps = array();
	// Set the start time / buckets to line up exactly with our SQL statement above.
	$start_time = time() - $lookback_value * snmptrapvolume_interval_as_multiplier($lookback_unit);
	$start_time = $start_time - $start_time % ($interval_in_seconds);
	$now = time();
	for ($current_time = $start_time; $current_time < $now; $current_time += $interval_in_seconds) {

		if ($current_time != $start_time) {
			$totals .= ",";
		}
		$timestamps[] = date("H:i:s", $current_time);

		if ($i >= count($data)) {
			$totals .= "0";
			continue;
		}

		$current_data = $data[$i];

		while ($current_data['unixtime'] < $current_time) {
			// Current bucket is in the past ? 
			// This shouldn't happen, but just move it forward I guess...
			$i += 1;
			if ($i >= count($data)) {
				$totals .= "0";
				break;
			}
			$current_data = $data[$i];
		}
		if ($current_data['unixtime'] > $current_time) {
			// Current bucket is in the future relative to our timestamp, print empty cell and move on.
			$totals .= "0";
			continue;
		}

		$totals .= $current_data['count'];
		$i += 1;
	}

	for ($i = 0; $i < count($timestamps); $i += 1) {
		$timestamps[$i] = "'".$timestamps[$i]."'";
	}
	$timestamps = implode(',', $timestamps);

?>
	<div id="<?php echo $container; ?>"></div>
    <script type='text/javascript'>
    $(function () {
        $('#<?php echo $container; ?>').highcharts({
            chart: {
                type: 'column',
                animation: false,
                marginRight: 35
            },
            title: {
                text: '<?php echo _('Last Updated').": ".get_datetime_string(time()); ?>',
                style: {
                    color: '#999',
                    fontSize: '10px'
                }
            },
            credits: { enabled: false },
            tooltip: { enabled: false },
            legend: { enabled: false },
            exporting: { enabled: false },
            xAxis: {
                categories: [<?php echo $timestamps; ?>],
                tickInterval: 20,
                tickmarkPlacement: 'on'
            },
            yAxis: {
                min: 0,
                allowDecimals: false,
                minRange: 8,
                title: {
                    text: null
                },
                gridLineDashStyle: 'solid',
                gridLineColor: '#EEE'
            },
            plotOptions: {
                column: {
                    pointPadding: -0.33,
                    borderWidth: 0
                }
            },
            series: [{
                data: [<?php echo $totals; ?>],
                animation: false,
                color: '#17b33b'
            }]
        });
    });
    </script>

<?php

}

function snmptrapvolume_interval_as_mysql($input_unit) {
	if (!in_array($input_unit, array("SECOND", "MINUTE", "HOUR", "DAY"))) {
		$input_unit = "MINUTE";
	}

	return $input_unit;
}

function snmptrapvolume_interval_as_multiplier($input_unit) {
	$lookup = array(
		"SECOND" => 1,
		"MINUTE" => 60,
		"HOUR" => 60 * 60,
		"DAY" => 24 * 60 * 60,
	);

	if (!array_key_exists($input_unit, $lookup)) {
		return $lookup["MINUTE"];
	}

	return $lookup[$input_unit];
}

?>