// Set colors for current status bar (not background zones)
// const critColor = '#FF795F'; //service status page red

let critColor, warnColor, okColor;

if (theme == 'colorblind') {
  critColor = '#CC79A7';  
  warnColor = '#D55E00';  
  okColor = '#56B4E9';    
}
else {
  critColor = '#F96c59';  
  warnColor = '#FEFF5F';  //service status page yellow
  okColor = '#5CDF45';  //monitoring engine graph
}

$('.dashletedit').click(function() {
  $('.dashlet-modify-menu').querySelector('div.dashlet-modify-menu').toggle();
});

function setstrokewidth(id, num) {
  document.querySelector('#dashlet-'+id+' svg circle').style.setProperty('stroke-width',num);
}

function updategauge(id, args, host, service){
  document.querySelector('#dashlet-'+id).querySelector(' .gaugetext p#serviceName').innerHTML = args['label'];
  document.querySelector('#dashletcontainer-'+id+' .dashlettopbox .dashlettitle').innerHTML += ' - ' + host+' - '+ service+' - '+args['label'];
  setvalhelper('#dashlet-'+id, args['current'],args['warn'],args['crit'], args['max'], args['uom']);
}
  
function setvalhelper(id, num, war, crt, max, unit) {  
  const gaugedashlet = document.querySelector(id);
  const r = gaugedashlet.querySelector('svg circle:nth-child(4)').getAttribute('r');
  const circumference = 2 * Math.PI * r;

  // Simple threshold sorting
  if(parseFloat(war) > parseFloat(crt)){
    const tmp = war;
    war = crt;
    crt = tmp;
  }

  var span = document.querySelector(id).querySelector('.gaugetext h2 span')
  span.innerHTML = unit;
  const h2 = document.querySelector(id).querySelector('.gaugetext h2');
  h2.textContent = num;
  h2.style.fontSize = (2.5-(0.25*(Math.max(0,Math.abs(num).toString().length-4))))+'em';
  
  // Calculate percentages
  const numPercent = (num / max) * 100;
  const warPercent = (war / max) * 100;
  const crtPercent = (crt / max) * 100;

  // Simple color thresholds
  if (num >= crt) { //critical
    setpercentcolor(id,critColor);
  } else if (num >= war) { //warning
    setpercentcolor(id,warnColor);
  } else { //ok
    setpercentcolor(id,okColor);
  }

  document.querySelector(id).style.setProperty('--num', Math.abs(numPercent));
  
  // Set initial stroke-dasharray for all circles
  const circles = gaugedashlet.querySelectorAll('svg circle');
  circles.forEach(circle => {
    circle.style['stroke-dasharray'] = circumference;
  });
  
  // Current value indicator (green)
  const currentCircle = gaugedashlet.querySelector(id+' svg circle:nth-child(4)');
  currentCircle.style['stroke-dasharray'] = `${(circumference * Math.abs(numPercent)/100)} ${circumference}`;
  currentCircle.style['stroke-dashoffset'] = 0;
  
  // Warning zone (yellow)
  const warningCircle = gaugedashlet.querySelector(id+' svg circle:nth-child(3)');
  const warningLength = Math.abs(crtPercent - warPercent);
  warningCircle.style['stroke-dasharray'] = `${(circumference * warningLength/100)} ${circumference}`;
  warningCircle.style['stroke-dashoffset'] = -(circumference * Math.abs(warPercent)/100);
  
  // Critical zone (red)
  const criticalCircle = gaugedashlet.querySelector(id+' svg circle:nth-child(2)');
  const criticalLength = 100 - Math.abs(crtPercent);
  criticalCircle.style['stroke-dasharray'] = `${(circumference * criticalLength/100)} ${circumference}`;
  criticalCircle.style['stroke-dashoffset'] = -(circumference * Math.abs(crtPercent)/100);

  if(Math.abs(numPercent) > 100) {
    gaugedashlet.querySelector(id+' .gaugetext p#value').style.setProperty('display', 'none');
  } else {
    const valueDisplay = gaugedashlet.querySelector(id+' .gaugetext p#value');
    valueDisplay.innerHTML = Math.abs(numPercent).toFixed(2);
  }
}

// percent to degrees
function p2d(num){
  return 3.6*num;
}

// Simplified arclen function
function arclen(num, circumference){
  return circumference * (1 - num / 100);
}

function setpercentcolor(id,color){
  document.querySelector(id+' svg circle:nth-child(4)').style.setProperty('--color',color);
  document.querySelector(id+' .gaugetext > *').style.setProperty('--color', colorsubdue(color,2));
}

function colorsubdue(color, degree){
  //subdue the color for the center stuff
  color = color.substring(1, color.length).toLowerCase(); //remove # and set to lowercase
  
  numlist = '0123456789abcdef';
  numlist = '0'.repeat(degree) + numlist;
  
  for (i=0; i<color.length; i++){
    color = color.substring(0,i) + 
    numlist[numlist.indexOf(color[i], degree) - degree] + 
    color.substring(i+1,color.length);
  }
  return '#'+color;
}

function hidezones(id){
  document.querySelector(id+' svg circle:nth-child(3)').style['display'] = 'none';
  document.querySelector(id+' svg circle:nth-child(2)').style['display'] = 'none';
}
function showzones(id){
  const warningCircle = document.querySelector(id+' svg circle:nth-child(3)');
  const criticalCircle = document.querySelector(id+' svg circle:nth-child(2)');
  
  warningCircle.style['display'] = 'block';
  criticalCircle.style['display'] = 'block';
  
  // Ensure critical circle maintains its transform
  criticalCircle.style['transform'] = 'translate(0px, 0px) rotate(360deg)';
}

function hidepercent(id){
  document.querySelector(id+' .gaugetext p#value').style['display'] = 'none';
  document.querySelector(id+' .gaugetext p#value').style['display'] = 'none';
}

function showpercent(id){
  document.querySelector(id+' .gaugetext p#value').style['display'] = 'block';
  document.querySelector(id+' .gaugetext p#value').style['display'] = 'block';
}

function hidetickmarks(id){
  document.querySelector(id+' svg .war').style['display'] = 'none';
  document.querySelector(id+' svg .crt').style['display'] = 'none';
}
