<?php
//
// Minemap Dashlet
// Copyright (c) 2010-2019 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../../dashlets/dashlethelper.inc.php');


function minemap_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{
    $output = "";
    $imgbase = get_base_url() . "includes/components/minemap/images/";

    switch ($mode) {

        case DASHLET_MODE_GETCONFIGHTML:
            $output .= '
                <div class="form-group">';
            $output .= dashlet_limit_select(false, true, true);
            $output .= dashlet_hostgroup_select();
            $output .= dashlet_servicegroup_select();
            $output .='
                </div>';
            break;

        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:

            $output = "";

            $id = "minemap_" . random_string(6);

            // ajax updater args
            $ajaxargs = $args;
            // build args for javascript
            $n = 0;
            $jargs = "{";
            foreach ($ajaxargs as $var => $val) {
                // This is ok because hostgroup names can't have commas
                if (is_array($val))
                    $val = implode(', ', $val);
                if ($n > 0)
                    $jargs .= ", ";
                $jargs .= "\"$var\" : \"$val\"";
                $n++;
            }
            $jargs .= "}";

            $output .= '
			<div class="minemap_dashlet dashlet-auto-overflow" id="' . $id . '">
			
			<div class="infotable_title">Status Grid</div>
			' . get_throbber_html() . '
			
			</div><!--ahost_status_summary_dashlet-->

			<script type="text/javascript">
			$(document).ready(function(){
			
				get_' . $id . '_content();
					
				$("#' . $id . '").everyTime(30*1000, "timer-' . $id . '", function(i) {
					get_' . $id . '_content();
				});
				
				function get_' . $id . '_content(){
					$("#' . $id . '").each(function(){
						var optsarr = {
							"func": "get_minemap_dashlet_html",
							"args": ' . $jargs . '
							}
						var opts=JSON.stringify(optsarr);
						get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
						setTimeout(function() {
							$(".tt-bind-d").tooltip({ placement: "left" });
							$(".tt-bind-dr").tooltip({ placement: "right" });
						} , 500);
						});
					}
			});
			</script>
			';

            break;

        case DASHLET_MODE_PREVIEW:

            if(!is_neptune()) {
                $output = "<p><img src='" . $imgbase . "preview.png'></p>";
            } else if (get_theme() == "neptunelight") {
                $output = "<img src='" . $imgbase . "minemap_neptune_light_preview.png'>";
            } else {
                $output = "<img src='" . $imgbase . "neptune_preview.png'>";
            }

            break;
    }

    return $output;
}
