<?php
//
// Minemap Report
// Copyright (c) 2008-2019 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');
include_once(dirname(__FILE__) . '/dashlet.inc.php');


// Initialization stuff
pre_init();
init_session();

// Check pre-reqs and auth
grab_request_vars();
check_prereqs();
check_authentication(false);


route_request();

function route_request()
{
    global $request;

    $mode = grab_request_var("mode");
    switch ($mode) {
        case "getdata":
            minemap_get_data();
            break;
        default:
            display_minemap();
            break;
    }
}

function display_minemap()
{

    $type = grab_request_var("type", "");
    $host = grab_request_var("host", "");
    $hostgroup = grab_request_var("hostgroup", "");
    $servicegroup = grab_request_var("servicegroup", "");
    
    $manual_run = grab_request_var("manual_run", 0);

    // Do not do any processing unless we have default report running enabled
    $disable_report_auto_run = get_option("disable_report_auto_run", 0);
    
    // makes sure user has appropriate license level
    licensed_feature_check();

    // start the HTML page
    do_page_start(array("page_title" => "Minemap"), true);

    ?>
    

    <form action="" method="get">
    <div class="well report-options form-inline neptune-metric-well flex margin-left-well">

            <div class="input-group" style="margin-right: 10px;">
                <label class="input-group-addon border-right"><?php echo _("Limit To"); ?></label>
                <select name="hostgroup" id="hostgroupList" style="width: 150px;" class="rounded-l-none border-l h-9 form-control">
                    <option value=""><?php echo _("Hostgroup"); ?>:</option>
                    <?php
                    $args = array('orderby' => 'hostgroup_name:a');
                    $oxml = get_xml_hostgroup_objects($args);
                    if ($oxml) {
                        foreach ($oxml->hostgroup as $hg) {
                            $name = strval($hg->hostgroup_name);
                            echo "<option value='" . $name . "' " . is_selected($hostgroup, $name) . ">$name</option>\n";
                        }
                    }
                    ?>
                </select>
                <select name="servicegroup" id="servicegroupList" style="width: 175px;" class="rounded-l-none rounded-r h-9 form-control">
                    <option value=""><?php echo _("Servicegroup"); ?>:</option>
                    <?php
                    $args = array('orderby' => 'servicegroup_name:a');
                    $oxml = get_xml_servicegroup_objects($args);
                    if ($oxml) {
                        foreach ($oxml->servicegroup as $sg) {
                            $name = strval($sg->servicegroup_name);
                            echo "<option value='" . $name . "' " . is_selected($servicegroup, $name) . ">$name</option>\n";
                        }
                    }
                    ?>
                </select>
            </div>

            <button type="submit" class="btn btn-sm btn-primary h-9" name="goButton" id="goButton"><?php echo _('Update'); ?></button>
            
            <!-- Set a variable to let us know it's okay to run this -->
            <input type="hidden" name="manual_run" value="1">
           
            </div>
        </form>
       
        <h1><?php echo _("Minemap"); ?></h1>

    <script type="text/javascript">
    $(document).ready(function () {
        if (!is_neptune()) {
            $('#hostgroupList').searchable({maxMultiMatch: 9999});
            $('#servicegroupList').searchable({maxMultiMatch: 9999});
        }
        $('#servicegroupList').change(function () {
            $('#hostgroupList').val('');
        });
        $('#hostgroupList').change(function () {
            $('#servicegroupList').val('');
        });
    });
    </script>

    <?php
        // Die right here if we don't want to auto-load the page
        if ($disable_report_auto_run == 1 && $manual_run == 0 ) {
            die();
        }
     ?>
    <?php
    $dargs = array(
        DASHLET_ARGS => array(
            "type" => $type,
            "host" => $host,
            "hostgroup" => $hostgroup,
            "servicegroup" => $servicegroup,
        ),
    );
    /*
    echo "ARGS GOING IN=";
    print_r($dargs);
    echo "<BR>";
    */
    display_dashlet("minemap", "", $dargs, DASHLET_MODE_OUTBOARD);
    ?>

    <?php

    // closes the HTML page
    do_page_end(true);
}
    