<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h5><?= _('AWS Account Information') ?></h5>
            <p><?= _('Specify the credentials for the Amazon Web Services account you would like to monitor') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="accesskeyid" class="form-label form-item-required"><?= _('Access Key ID') ?> <?= xi6_info_tooltip(_('The Access Key ID of the bucket to be monitored')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="accesskeyid" id="accesskeyid" value="<?= encode_form_val($accesskeyid) ?>" class="form-control monitor rounded credinput" placeholder="<?= _("Enter Access Key ID") ?>"  <?= (checkbox_binary($staticcreds) ? "disabled" : "") ?> required>
                        <div class="invalid-feedback">
                            <?= _('Please enter an Access Key ID or specify a static credentials file') ?>
                        </div>
                        <i id="accesskeyid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="accesskey" class="form-label form-item-required"><?= _('Secret Access Key') ?> <?= xi6_info_tooltip(_('The Secret Access Key of the bucket to be monitored')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="accesskey" id="accesskey" value="<?= encode_form_val($accesskey) ?>" class="form-control monitor rounded credinput" placeholder="<?= _("Enter Secret Access Key") ?>"  <?= (checkbox_binary($staticcreds) ? "disabled" : "") ?> required>
                        <div class="invalid-feedback">
                            <?= _('Please enter a Secret Access Key or specify a static credentials file') ?>
                        </div>
                        <i id="accesskey_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-3">
                <div class="col-sm">
                    <input type="checkbox" id="staticcreds" name="staticcreds" class="form-check-input mt-1 me-2" <?= is_checked(checkbox_binary($staticcreds), "1") ?>>
                    <label for="staticcreds" class="form-check-label bold">
                        <?= _('Static credentials file') ?>
                        <?= xi6_info_tooltip(_("If this box is checked, Nagios will read a local file containing your AWS credentials that follows Amazon's syntax. Read more about credentials files <a target='_blank' href='http://docs.aws.amazon.com/cli/latest/userguide/cli-config-files.html'>here</a>.")) ?>
                        <p class="mb-0 fw-normal"><?= _('Use a statically defined AWS credentials file') ?>.</p>
                    </label>
                </div>
            </div>

            <!-- Initially hidden -->
            <div id="credsfilepathdiv" class="row mb-2 visually-hidden">
                <div class="col-sm-6 ms-4">
                    <label for="credsfilepath" class="form-label form-item-required">
                        <?= _('File path') ?>
                        <?= xi6_info_tooltip(_('The absolute file path to the Amazon Credentials file (<b>Default:</b> /usr/local/nagiosxi/etc/.aws/credentials)'). _('<b>Note: Ensure the nagios group has read permissions for the entirety of the file path leading to the credentials file, including the file itself</b>')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <input type="text" name="credsfilepath" id="credsfilepath" value="<?= encode_form_val($credsfilepath) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter File path") ?>" disabled>
                        <div class="invalid-feedback">
                            <?= _("Please enter the absolute file path for the credentials file") ?>
                        </div>
                        <i id="credsfilepath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm">
                    <input type="checkbox" id="staticconfig" name="staticconfig" class="form-check-input mt-1 me-2" <?= is_checked(checkbox_binary($staticconfig), "1") ?>>
                    <label for="staticconfig" class="form-check-label bold">
                        <?= _('Static configuration file') ?>
                        <?= xi6_info_tooltip(_("If this box is checked, Nagios will read a local file containing your AWS configuration that follows Amazon's syntax. Read more about configuration files <a target='_blank' href='http://docs.aws.amazon.com/cli/latest/userguide/cli-config-files.html'>here</a>.")) ?>
                        <p class="mb-0 fw-normal"><?= _('Use a statically defined AWS configurations file') ?>.</p>
                    </label>
                </div>
            </div>

            <!-- Initially hidden -->
            <div id="configfilepathdiv" class="row mb-2 visually-hidden">
                <div class="col-sm-6 ms-4">
                    <label for="configfilepath" class="form-label form-item-required">
                        <?= _('File path') ?>
                        <?= xi6_info_tooltip(_('The absolute file path to the Amazon Configuration file (<b>Default:</b> /usr/local/nagiosxi/etc/.aws/config)'). _('<b>Note: Ensure the nagios group has read permissions for the entirety of the file path leading to the config file, including the file itself</b>')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <input type="text" name="configfilepath" id="configfilepath" value="<?= encode_form_val($configfilepath) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter File path") ?>" disabled>
                        <div class="invalid-feedback">
                            <?= _("Please enter the absolute file path for the configuration file") ?>
                        </div>
                        <i id="configfilepath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h5 class="mt-4"><?= _('S3 Bucket Information') ?></h5>
            <p><?= _('Select the buckets you would like to monitor, then enter the region name by the selected buckets') ?></p>

            <div id="bucket-notice-div" class="row pb-3 visually-hidden">
                <div class="col-sm-6">
                    <div id="bucket-notice" class="alert alert-secondary col-sm-12 text-center loader">
                        <div id="info-placeholder"></div>
                    </div>
                </div>
            </div>
            <div id="get-buckets-div" class="row pb-3">
                <div class="col-sm-6">
                    <button type="button" id="get-buckets" class="btn btn-lg btn-primary available-buckets">Get Available Buckets</button>
                    <?= xi6_info_tooltip(_('Fill out the AWS Credentials above, then click "Get Available Buckets".')) ?>
                </div>
            </div>
<?php
    if ($bucket_list == '') {
?>
            <div id="bucket-container" class="col-sm-6 border-block mb-2 visually-hidden"></div>
<?php
    } else {
?>
            <div id="bucket-container" class="col-sm-6 border-block mb-2">
                <div class="row g-1 mb-1">
                    <div class="col-sm-auto me-2 mt-1">
                        <input type="checkbox" id="select-all-buckets" class="form-check-input select-all-buckets" checked>
                    </div>
                    <div class="col-sm-5">
                        <label class="form-label ps-2"><?= _('Bucket Name') ?></label>
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label ps-2"><?= _('Bucket Region') ?></label>
                    </div>
                </div>
<?php
        foreach ($bucket_list as $bucket_name => $bucket_info) {
?>
                <div class="row mb-2 g-1">
                    <div class="col-sm-auto me-2 mt-2">
                        <input type="checkbox" id="bucketlist[<?= $bucket_name ?>][checkbox]" name="bucketlist[<?= $bucket_name ?>][checkbox]" class="form-check-input bucket-list-checkbox" <?= (checkbox_binary($bucket_info['checkbox']) ? "checked" : "") ?>>
                    </div>
                    <div class="col-sm-5">
                        <input type="text" class="form-control form-control-sm me-1 rounded" id="bucketlist[<?= $bucket_name ?>][bucket_name]" name="bucketlist[<?= $bucket_name ?>][bucket_name]" value="<?= $bucket_name ?>" disabled>
                    </div>
                    <div class="col-sm-6">
                        <input type="text" id="bucketlist[<?= $bucket_name ?>][region]" name="bucketlist[<?= $bucket_name ?>][region]" class="form-control form-control-sm me-1 rounded monitor" value="<?= $bucket_info['region'] ?>">
                    </div>
                </div>
                <input type="hidden" name="bucketlist[<?= $bucket_name ?>][metrics]" value="<?= $bucket_info['metrics'] ?>">
<?php
        }
?>
            </div>
<?php
    }
?>
        </div> <!-- configForm -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {

            //
            // Bind the .select-all-buckets checkbox, to click event.
            // - PHP render (step2 then Back button)
            //
            $("#select-all-buckets").change(function() {
                clickSelectAllBuckets(this);
            });

            // Click/unclick select-all-region_? checkbox.
            function clickSelectAllBuckets (obj) {
                isChecked = ($(obj).is(':checked'));

                // Buckets
                bucketContainer = $(obj).parents("div[id=bucket-container]");
                bucketContainerDiv = $(bucketContainer)[0];

                buckets = $(bucketContainerDiv).find(".bucket-list-checkbox");

                $(buckets).each(function(index, element) {
                    if (isChecked) {
                        $(element).prop('checked', true);
                    } else {
                        $(element).prop('checked', false);
                    }
                });
            }

            //
            // Handle ec2 bucket check/uncheck individual checkboxes
            // - Matches all id's starting with "bucketlist"
            //
            $(".bucket-list-checkbox").change(function() {
                clickIndividualBucket(this);
            });

            // Click/unclick .bucket-list-checkbox checkbox.
            function clickIndividualBucket (obj) {
                isChecked = ($(obj).is(':checked'));

                // Buckets
                bucketContainer = $(obj).parents("div[id=bucket-container]");
                bucketContainerDiv = $(bucketContainer)[0];

                selectAllObj = $(bucketContainerDiv).find(".select-all-buckets");
                selectAllCheck = $(selectAllObj)[0];

                if ($(".bucket-list-checkbox").length == $(".bucket-list-checkbox:checked").length) {
                    $(selectAllCheck).prop('checked', true);
                } else {
                    $(selectAllCheck).prop('checked', false);
                }
            }

            //
            // Checkbox management - staticcreds
            //
            if ($("#staticcreds").is(':checked')) {
                checkStaticCreds();
            }

            $("#staticcreds").change(function () {
                checkStaticCreds();
            });

            function checkStaticCreds() {
                if ($('#staticcreds').is(':checked')) {
                    $('#credsfilepathdiv').removeClass('visually-hidden');
                    $('#credsfilepath').removeAttr('disabled');
                    $('#credsfilepath').attr('required');
                    $('#accesskeyid').attr('disabled', true);
                    $('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
                    $('#accesskeyid').removeClass('is-invalid');
                    $('#accesskeyid').removeClass('invalid');
                    $('#accesskey').prop('disabled', true);
                    $('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
                    $('#accesskey').removeClass('is-invalid');
                    $('#accesskey').removeClass('invalid');
                } else {
                    $('#credsfilepathdiv').addClass('visually-hidden');
                    $('#credsfilepath').prop('disabled', true);
                    $('#accesskeyid').removeAttr('disabled');
                    $('#accesskey').removeAttr('disabled');
                }
            }

            //
            // Checkbox management - staticconfig
            //
            if ($("#staticconfig").is(':checked')) {
                checkStaticConfig();
            }

            $("#staticconfig").change(function () {
                checkStaticConfig();
            });

            function checkStaticConfig() {
                if ($('#staticconfig').is(':checked')) {
                    $('#configfilepathdiv').removeClass('visually-hidden');
                    $('#configfilepath').removeAttr('disabled');
                    $('#configfilepath').attr('required');
                } else {
                    $('#configfilepathdiv').addClass('visually-hidden');
                    $('#configfilepath').removeAttr('required');
                }
            }

            //
            // Handle changes to accesskeyid
            //
            $('#accesskeyid').on("input propertychange paste", function() {
                if ($(this).val()) {
                    $('#accesskeyid').removeClass('invalid');
                    $('#accesskeyid').removeClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
                } else {
                    $('#accesskeyid').addClass('invalid');
                    $('#accesskeyid').addClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').removeClass('visually-hidden');
                }
            });

            //
            // Handle changes to accesskey
            //
            $('#accesskey').on("input propertychange paste", function() {
                if ($(this).val()) {
                    $('#accesskey').removeClass('invalid');
                    $('#accesskey').removeClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
                } else {
                    $('#accesskey').addClass('invalid');
                    $('#accesskey').addClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').removeClass('visually-hidden');
                }
            });

            //
            // Handle "Get Available Buckets" button - AJAX
            //
            $("#get-buckets").on("click", function() {
                // Make sure the bucket-container is empty and hidden.
                $("#bucket-container").empty();
                $("#bucket-container").addClass('visually-hidden');

                // Check that we have all requisite data
                var errors = 0;

                var accesskeyid = $("#accesskeyid").val();
                var accesskey = $("#accesskey").val();
                var staticcreds = $("#staticcreds").prop("checked");

                // Make sure we have the required data
                if (!accesskeyid && !staticcreds) {
                    $('#accesskeyid').addClass('invalid');
                    $('#accesskeyid').addClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').removeClass('visually-hidden');
                    errors += 1;
                } else {
                    $('#accesskeyid').removeClass('invalid');
                    $('#accesskeyid').removeClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
                }

                if (!accesskey && !staticcreds) {
                    $('#accesskey').addClass('invalid');
                    $('#accesskey').addClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').removeClass('visually-hidden');
                    errors += 1;
                } else {
                    $('#accesskey').removeClass('invalid');
                    $('#accesskey').removeClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
                }

                if (errors > 0) {
                    document.getElementsByClassName('container')[0].scrollIntoView({ behavior: "smooth" });
                    return false;
                }

                $("#bucket-notice-div").addClass('visually-hidden');
                $("#no-buckets").addClass('visually-hidden');
                $("#info-placeholder").empty();

                // Display the loading animation whenever the button is clicked
                whiteout();
                $('.xi-modal').show();
                $('.xi-modal').position({ my: "center", at: "center", of: window });
                show_throbber();

                var accesskeyid = $("#accesskeyid").val();
                var accesskey = $("#accesskey").val();

                // Base64 encode the strings so we can pass them as a query string
                accesskeyid = btoa(accesskeyid);
                accesskey = btoa(accesskey);

                // Build the AJAX url
                var formvalues = "mode=getbuckets";

                if ($("#staticcreds").is(":checked")) {
                    var staticcreds = $("#staticcreds").val();
                    var credsfilepath = $("#credsfilepath").val();

                    formvalues += "&staticcreds=" + staticcreds;
                    formvalues += "&credsfilepath=" + credsfilepath;
                }

                formvalues += "&accesskeyid=" + accesskeyid;
                formvalues += "&accesskey=" + accesskey;

                full_url = base_url + "includes/configwizards/amazon_s3/s3.ajax.php?" + formvalues;

                //
                // AJAX
                //
                $.ajax({
                    url: full_url,
                    dataType: "json",
                    success: function(data) {
                        $("#bucket-notice-div").addClass('visually-hidden');
                        $('.xi-modal').hide();
                        clear_whiteout();
                        hide_throbber();

                        if (!data || !data.success) {
                            $('.xi-modal').hide();
                            clear_whiteout();
                            hide_throbber();

                            $("#bucket-notice-div").removeClass('visually-hidden');
                            $("#bucket-notice").addClass('alert-warning');
                            $("#info-placeholder").html(data.error);

                            return false;
                        }

                        var header = "".concat(
'                <div class="row g-1 mb-1">',
'                    <div class="col-sm-auto me-2 mt-1">',
'                        <input type="checkbox" id="select-all-buckets" class="form-check-input select-all-buckets" checked>',
'                    </div>',
'                    <div class="col-sm-5">',
'                        <label class="form-label ps-2"><?= _('Bucket Name') ?></label>',
'                    </div>',
'                    <div class="col-sm-6">',
'                        <label class="form-label ps-2"><?= _('Bucket Region') ?></label>',
'                    </div>',
'                </div>'
                        );

                        $("#bucket-container").append(header);

                        var counter = 0;

                        // Remove "success"
                        delete data["success"];

                        $.each(data, function(index, value) {

                            var row = "".concat(
'                <div class="row mb-2 g-1">',
'                    <div class="col-sm-auto me-2 mt-2">',
'                        <input type="checkbox" id="bucketlist['+index+'][checkbox]" name="bucketlist['+index+'][checkbox]" class="form-check-input bucket-list-checkbox" checked>',
'                    </div>',
'                    <div class="col-sm-5">',
'                        <input type="text" class="form-control form-control-sm me-1 rounded" id="bucketlist['+index+'][bucket_name]" name="bucketlist['+index+'][bucket_name]" value="'+index+'" disabled>',
'                    </div>',
'                    <div class="col-sm-6">',
'                        <input type="text" id="bucketlist['+index+'][region]" name="bucketlist['+index+'][region]" class="form-control form-control-sm me-1 rounded monitor" value="'+value+'">',
'                    </div>',
'                </div>'
                                    );

                            $("#bucket-container").append(row);

                            counter++;
                        });

                        $("#bucket-container").removeClass('visually-hidden');

                        // Bind actions to checkboxes with .select-all-buckets and .bucket-list-checkboxes.
                        $("[id^='bucket-container']").on('click', ".select-all-buckets", function() { clickSelectAllBuckets(this); });
                        $("[id^='bucket-container']").on('click', ".bucket-list-checkbox", function() { clickIndividualBucket(this); });

                        document.getElementById('bucket-container').scrollIntoView({ behavior: "smooth" });
                    },
                    error: function(xmlhttprequest, textstatus, message) {
                        $('.xi-modal').hide();
                        clear_whiteout();
                        hide_throbber();

                        if (textstatus === "parsererror") {
                            $("#bucket-notice-div").removeClass('visually-hidden');
                            $("#bucket-notice").addClass('alert-danger');
                            $("#info-placeholder").html("<?= _('Error: There were no buckets found. Verify your AWS credentials and try again.') ?>");
                        }
                    }
                }); // AJAX
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
