<?php
//
// Bandwidth Usage Report Component
// Copyright (c) 2010-2024 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

$bandwidthreport_component_name = "bandwidthreport";
bandwidthreport_component_init();


////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////


function bandwidthreport_component_init()
{
    global $bandwidthreport_component_name;
    $versionok = bandwidthreport_component_checkversion();

    $desc = _("Requires host authorization to view report. ");
    if (!$versionok) {
        $desc = "<br><b>" . _("Error: This component requires Nagios XI 2024R1.1 or later.") . "</b>";
    }

    $args = array(
        COMPONENT_NAME => $bandwidthreport_component_name,
        COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION => _("Provides a bandwith usage report for network switches and routers that are being monitored.") . $desc,
        COMPONENT_TITLE => "Bandwidth Usage Report",
        COMPONENT_VERSION => "2.1.1"
    );

    register_component($bandwidthreport_component_name, $args);

    if ($versionok) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'bandwidthreport_component_addmenu');
    }
}


///////////////////////////////////////////////////////////////////////////////////////////
// VERSION CHECK FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////


function bandwidthreport_component_checkversion()
{
    if (!function_exists('get_product_release')) {
        return false;
    }
    if (get_product_release() < 60100) {
        return false;
    }
    return true;
}


///////////////////////////////////////////////////////////////////////////////////////////
// MENU FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////


function bandwidthreport_component_addmenu($arg = null)
{
    global $bandwidthreport_component_name;

    // Retrieve the URL for this component
    $urlbase = get_component_url_base($bandwidthreport_component_name);

    // Figure out where I'm going on the menu
    $mi = find_menu_item(MENU_REPORTS, "menu-reports-nagiosxi-eventlog", "id");
    if ($mi == null) {
        return;
    }

    $order = grab_array_var($mi, "order", "");
    if (empty($order)) {
        return;
    }

    $neworder = $order + 0.05;

    // Add this to the report menu
    add_menu_item(MENU_REPORTS, array(
        "type" => "link",
        "title" => _("Bandwidth Usage"),
        "id" => "menu-reports-bandwidthreport",
        "order" => $neworder,
        "opts" => array(
            "href" => $urlbase . "/index.php",
        )
    ));
}