<?php
//
// Hypermap
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');
include_once(dirname(__FILE__) . '/ajax.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();
check_authentication(false);


route_request();


function route_request()
{
    global $request;

    $mode = grab_request_var("mode");
    switch ($mode) {
        case "hidehelp":
            set_user_meta(0, 'hypermap_hide_help', 1);
            echo json_encode(array('success' => 1));
            exit;
            break;
        case "getdata":
            hypermap_get_data();
            break;
        default:
            display_hypermap();
            break;
    }
}


function display_hypermap()
{
    $type = grab_request_var("type", "");
    $refresh = grab_request_var("refresh", 60);

    // Makes sure user has appropriate license level
    licensed_feature_check();

    do_page_start(array("page_title" => _("Hypermap")), true);
?>

<script type="text/javascript">
$(document).ready(function() {
    var height = $(window).height();
    $('.hypermap-container').css('height', height+'px');
    $('.hypermap-left-container').css('height', height+'px');
    $('.hypermap-center-container').css('height', height+'px');
    $('.hypermap-infovis').css('height', height+'px');

    var width = $(window).width() - 250;
    $('.hypermap-container').css('width', width+'px');
    $('.hypermap-center-container').css('width', width+'px');
    $('.hypermap-infovis').css('width', width+'px');
    $('.hypermap-right-container').css('width', '100px');
});
</script>

<h1><?php echo _("Hypermap"); ?></h1>

<?php
    $dargs = array(
        DASHLET_ARGS => array(
            "type" => $type,
            "refresh" => $refresh
        )
    );
    display_dashlet("hypermap", "", $dargs, DASHLET_MODE_OUTBOARD);

    do_page_end(true);
}
