    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="appid" value="<?= encode_form_val($appid) ?>">
    <input type="hidden" name="tenant" value="<?= encode_form_val($tenant) ?>">
    <input type="hidden" name="secret" value="<?= encode_form_val($secret) ?>">
    <input type="hidden" name="modelist_serial" value="<?= base64_encode(json_encode($modelist)) ?>" />
    <input type="hidden" name="usersList" value="<?= htmlspecialchars(json_encode($usersList), ENT_QUOTES, "UTF-8") ?>" />
    <input type="hidden" name="groupsList" value="<?= htmlspecialchars(json_encode($groupsList), ENT_QUOTES, "UTF-8") ?>" />
    <input type="hidden" name="productsList" value="<?= htmlspecialchars(json_encode($productsList), ENT_QUOTES, "UTF-8") ?>" />
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    # Microsoft now conceals user, group and site name data, by default, so check to see if we need to warn the user.
    if ($isDataConcealed) {
?>
    <div class="alert alert-info w-50">
        <h2><b><?= _('NOTIFICATION') ?>:<b> <?= _('Concealed user, group and site names detected') ?></h2>
        <p>
            <?= _('On September 1, 2021, Microsoft made privacy changes to all Microsoft 365 Subscriptions.  As a result, your user, group, and site information, in your organizations data usage reports, is concealed/anonymized') ?>.
        </p>
        <p>
            <?= _('In order to monitor individual users, groups and sites in your Microsoft 365 subscription, you will need to override the setting in the') ?> <a target="blank" href="https://admin.microsoft.com"><?= _('Microsoft 365 admin center') ?></a>.
            <br>
            <?= _('See') ?> <a target="blank" href="https://docs.microsoft.com/en-us/office365/troubleshoot/miscellaneous/reports-show-anonymous-user-name"><?= _('Microsoft 365 reports show anonymous user names instead of actual user names</a>, for step by step instructions') ?>.
        </p>
        <?= _('Generic metrics are available, without any changes') ?>.
    </div>
<?php
    }
?>
    <link href="<?= $select2_css_url ?>" rel="stylesheet"/>
    <link href="<?= $select2_bootstrap_css_url ?>" rel="stylesheet"/>
<?php
    if (!empty($additional_theme_css_url)) {
?>
    <link href="<?= $additional_theme_css_url ?>" rel="stylesheet"/>
<?php
    }
?>
    <!--script src="<?= $select2_js_url ?>"></script-->
    <script src="<?= $ms365_base_url ?>js/select2.full.min.js"></script>

    <style>
        .select2-container, .selection, .select2-selection, .select2-selection__rendered {
            z-index: 800;
        }
    </style>

    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Microsoft 365') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('Short name for the tenant this service connects through (default is a combination of tenant name and type)')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val(!empty($hostname) ? $hostname : $organization[0]['displayName'].'-'.$organization[0]['tenantType']) ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _("Enter a name for this Host/Node") ?>" >
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="appid" class="form-label"><?= _('Application (Client) ID') ?> <?= xi6_info_tooltip(_('Application (client) ID (GUID) created when this plugin was registered in Azure AD').'.') ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="appid" id="appid" value="<?= encode_form_val($appid) ?>" class="form-control form-control-sm monitor rounded-end" disabled>
                    <i id="appid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="tenant" class="form-label"><?= _('Directory (tenant) ID') ?> <?= xi6_info_tooltip(_('Azure Directory (tenant) ID (GUID), of your organization or domain').'.') ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="tenant" id="tenant" value="<?= encode_form_val($tenant) ?>" class="form-control form-control-sm monitor rounded-end" disabled>
                    <i id="tenant_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
<?php
    #echo("services ".var_export($services, true)."<br>");
    foreach ((array) $modelist as $modeName => $pluginMode) {
        $serviceCount = 0;

        if (isset($services['process'][$modeName]) == false) {
            $services['process'][$modeName]['0']['monitor'] = 'off';
            #$services['process'][$modeName]['0']['unit'] = '';
            #$services['process'][$modeName]['0']['modifier'] = '';
            $services['process'][$modeName]['0']['warning'] = $pluginMode['warn'];
            $services['process'][$modeName]['0']['critical'] = $pluginMode['crit'];
        }
?>
        <!--                            -->
        <!-- <?= $modeName ?> Metrics    -->
        <!--                            -->
<?php
        # Multiple service setups.
        # Nothing to do

        # Single service setups.
        if ($pluginMode['multiple'] != true) {
            $checked = (array_key_exists('monitor', $services['process'][$modeName]['0']) &&
                        $services['process'][$modeName]['0']['monitor'] == 'on') ? 'checked' : '';
?>      <div class="row mb-2 mt-4" id="process-<?= $modeName ?>-list">
            <div class="col-sm-8">
                <div class="col-sm-9 mt-0 pt-0 ps-0">
                    <label for="services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]"
                           class="form-check-label bold select-cf-option"><?= $pluginMode['name'] ?> <?= (!empty($pluginMode['help']) ? xi6_info_tooltip(str_replace('|', '', $pluginMode['help'])) : '') ?></label>

                </div>
            </div>
        </div>
<?php
        }

        # Multiple service setups.
        if ($pluginMode['multiple'] == true) {
?>
        <div class="row mb-2 mt-4" id="process-<?= $modeName ?>-list">
            <div class="col-sm-8">
                <div class="col-sm-9 mt-0 pt-0 ps-0">
                    <label for="services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]"
                           class="form-check-label bold select-cf-option"><?= $pluginMode['name'] ?> <?= (!empty($pluginMode['help']) ? xi6_info_tooltip(str_replace('|', '', $pluginMode['help'])) : '') ?></label>
                    <div class="input-group position-relative col-sm-8 pe-2 pb-2">
                        <select class="form-select
                                       services-process-<?= $modeName ?>-<?= $pluginMode['filter'] ?>"
                                id="services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]"
                                name="services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]"
                                <?= (($isDataConcealed && $pluginMode['filter'] == 'user') ? ' disabled=disabled>' : '>') ?>>
                            <option></option>
<?php
            $list = $pluginMode['filter']."List";
            $dataList = array();

            if (array_key_exists($list, $services['process'][$modeName])) {
                $dataList = explode(',', $services['process'][$modeName][$list]);
            }

            # Would be nice to consolidate this, a bit...
            switch ($pluginMode['filter']) {

                case "user":
                    foreach ((array) $usersList as $key => $user) {
                        # Skip chosen options
                        if (in_array($user['userPrincipalName'], $dataList))    continue;
?>
                            <option value="<?= $user['userPrincipalName'] ?>"><?= _($user['userPrincipalName']) ?> - <?= _($user['displayName']) ?></option>
<?php
                    }

                    break;

                case "group":
                    foreach ((array) $groupsList as $group) {
                        # Skip chosen options
                        if (in_array($group['id'], $dataList))    continue;
?>
                            <option value="<?= $group['id'] ?>"><?= _($group['displayName']) ?> - <?= _($group['id']) ?></option>
<?php
                    }

                    break;

                case "product":
                    foreach ((array) $productsList as $product) {
                        # No products (like dev.onmicrosoft.com)
                        if (array_key_exists('rowCount', $productsList) && $productsList['rowCount'] == 0)    continue;

                        # Skip chosen options
                        if (in_array($product['Product Type'], $dataList))    continue;
?>
                            <option value="<?= $product['Product Type'] ?>"><?= _($product['Product Type']) ?></option>
<?php
                    }

                    break;
            }   # End $plugin['filter'] switch
?>
                        </select>

                        <div class="invalid-feedback">
                            Please select the default units of measure.
                        </div>
                        <i id="default_mem_units_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>

                        <button type="button" class="btn btn-sm btn-primary" id="add-new-<?= $modeName ?>-service" name="add-new-<?= $modeName ?>-service" disabled>Add</button>
                    </div>
<?php
            if ($isDataConcealed && $pluginMode['filter'] == 'user') {
?>
                    <script type="text/javascript">
                        $(function() {
                            $(".credtooltip").popover({ html: true });
                        });
                    </script>
<?php
            }
?>
                </div>
            </div>
        </div>
<?php
            # Single service setups.
        } else {
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="col-sm-auto<?= (!is_neptune() ? ' mt-1' : '' )?>">
                        <input type="checkbox" class="form-check-input" id="services[process][<?= $modeName ?>][0][monitor]" name="services[process][<?= $modeName ?>][0][monitor]" <?= $checked ?>>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="services[process][<?= $modeName ?>][0][warning]" name="services[disk_warning][<?= $modeName ?>][0][warning]" value="<?= encode_form_val($pluginMode['warn']) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="services[disk_critical][<?= $modeName ?>][0][critical]" name="services[disk_critical][<?= $modeName ?>][0][critical]" value="<?= encode_form_val($pluginMode['crit']) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                </fieldset>
            </div>
        </div> 
<?php
        }
?>
    <div class="xi-modal hide">
        <div class="xi-modal-spinner">
            <div class="sk-spinner sk-spinner-rotating-plane"></div>
        </div>
    </div>

<?php
            # Multiple service setups.
        if ($pluginMode['multiple'] == true) {
?>
    <input type="hidden" name="services[process][<?= $modeName ?>][filter]" value="<?= encode_form_val($pluginMode['filter']) ?>"/>
    <input type="hidden" name="services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>List]"
           value="<?= ((array_key_exists($pluginMode['filter'].'List', $services['process'][$modeName])) ? $services['process'][$modeName][$pluginMode['filter'].'List'] : "") ?>"/>
<?php
        }
?>
    <div id="process-<?= $modeName ?>-services">
<?php
            # Multiple service setups.
            if ($pluginMode['multiple'] == true && array_key_exists($pluginMode['filter']."List", $services['process'][$modeName])) {

                # Handle data from the services array (Back button)
                foreach ((array) $services['process'][$modeName] as $i => $metrics) {
                    if (!is_numeric($i)) continue;

                    $checked = (array_key_exists('monitor', $services['process'][$modeName][$i]) && $services['process'][$modeName][$i]['monitor'] == 'on') ? 'checked' : '';
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="col-sm-6 mt-0">
                        <div class="input-group input-group-sm">
                            <input type="checkbox" id="services[process][<?= $modeName ?>][<?= $i ?>][monitor]" class="form-check-input mt-2 me-2" name="services[process][<?= $modeName ?>][<?= $i ?>][monitor]" checked>
                            <span class="input-group-text rounded-start">
                                <i class="material-symbols-outlined md-18 md-400 tt-bind" title="<?= $pluginMode['filterLabel'] ?>"><?= $pluginMode['icon'] ?></i>
                            </span>
                            <input type="text" id="services[process][<?= $modeName ?>][<?= $i ?>][displayName]" name="services[process][<?= $modeName ?>][<?= $i ?>][displayName]" value="<?= encode_form_val($metrics['displayName']) ?>" class="form-control form-control-sm">
                            <input type="hidden" name="services[process][<?= $modeName ?>][<?= $i ?>][<?= $pluginMode['filter'] ?>]" id="services[process][<?= $modeName ?>][<?= $i ?>][<?= $pluginMode['filter'] ?>]" value="<?= encode_form_val($metrics[$pluginMode['filter']]) ?>">
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="services[process][<?= $modeName ?>][<?= $i ?>][warning]" name="services[disk_warning][<?= $modeName ?>][<?= $i ?>][warning]" value="<?= encode_form_val($metrics['warning']) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="services[disk_critical][<?= $modeName ?>][<?= $i ?>][critical]" name="services[disk_critical][<?= $modeName ?>][<?= $i ?>][critical]" value="<?= encode_form_val($metrics['critcal']) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
            $serviceCount = $i;
        }
    }
?>
        </div>
<?php
    # Multiple service setups.
    if ($pluginMode['multiple'] == true) {
?>
    <script type="text/javascript">
        var <?= $modeName ?>_num = (<?= $serviceCount ?>) ? <?= $serviceCount ?> + 1 : 1;
        var <?= $modeName ?>List = [];

        <?= $modeName ?>List.unshift($("input[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>List]']").val());

        $(document).ready(function() {

            $(".xi-modal-spinner").show();
            $(".btn-select-template").click(function() {
                whiteout();
                $(".xi-modal").show();
                $(".xi-modal").position({ my: "center", at: "center", of: element });
            });

            // Setup select2 searchable widget.
            $(".services-process-<?= $modeName ?>-<?= $pluginMode['filter'] ?>").select2({
                theme: "bootstrap-5",
                containerCssClass: "select2--small",
                dropdownCssClass: "select2--small",
                placeholder: '<?= _('Select a') ?> <?= $pluginMode['filterLabel'] ?>',
                allowClear: false,
                minimumResultsForSearch: 8, // No search, unless at least 8 entries.
            });

            // Set focus on input field/search box.
            $(document).on('select2:open', () => {
                document.querySelector(".select2-container--open .select2-search__field").focus();
            });

            // Activate button, once select is changed.
            $("select[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]']").on("change", function() {
                $("#add-new-<?= $modeName ?>-service").prop("disabled", false);
            });

            $("#add-new-<?= $modeName ?>-service").click(function() {
                row = "".concat(
    '   <div class="row">',
    '       <div class="col-sm-8">',
    '           <fieldset class="row g-2 mb-1 wz-fieldset">',
    '               <div class="col-sm-6 mt-0">',
    '                   <div class="input-group input-group-sm">',
    '                       <input type="checkbox" id="services[process][<?= $modeName ?>]['+<?= $modeName ?>_num+'][monitor]" class="form-check-input mt-2 me-2" name="services[process][<?= $modeName ?>]['+<?= $modeName ?>_num+'][monitor]" checked>',
    '                       <span class="input-group-text rounded-start">',
    '                           <i class="material-symbols-outlined md-18 md-400 tt-bind" title="<?= $pluginMode['filterLabel'] ?>"><?= $pluginMode['icon'] ?></i>',
    '                       </span>',
    '                       <input type="text" id="services[process][<?= $modeName ?>]['+<?= $modeName ?>_num+'][displayName]" name="services[process][<?= $modeName ?>]['+<?= $modeName ?>_num+'][displayName]" value="SET WITH JAVASCRIPT" class="form-control form-control-sm">',
    '                   </div>',
    '               </div>',
    '               <div class="col-sm-3 mt-0">',
    '                   <div class="input-group input-group-sm">',
    '                       <span class="input-group-text">',
    '                           <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>',
    '                       </span>',
    '                       <input type="text" id="services[process][<?= $modeName ?>]['+<?= $modeName ?>_num+'][warning]" name="services[disk_warning][<?= $modeName ?>]['+<?= $modeName ?>_num+'][warning]" value="<?= encode_form_val($pluginMode['warn']) ?>" class="form-control form-control-sm">',
    '                   </div>',
    '               </div>',
    '               <div class="col-sm-3 mt-0">',
    '                   <div class="input-group input-group-sm">',
    '                       <span class="input-group-text">',
    '                           <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>',
    '                       </span>',
    '                       <input type="text" id="services[disk_critical][<?= $modeName ?>]['+<?= $modeName ?>_num+'][critical]" name="services[disk_critical][<?= $modeName ?>]['+<?= $modeName ?>_num+'][critical]" value="<?= encode_form_val($pluginMode['crit']) ?>" class="form-control form-control-sm">',
    '                   </div>',
    '               </div>',
    '           </fieldset>',
    '       </div>',
    '   </div>');

                var <?= $pluginMode['filter'] ?> = $("select[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]']").val();
                var displayName = $("select[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]'] option:selected").text();

                $("#process-<?= $modeName ?>-services").append(row);

                $("input[name='services[process][<?= $modeName ?>]["+<?= $modeName ?>_num+"][displayName]']").val(displayName);
                $("input[name='services[process][<?= $modeName ?>]["+<?= $modeName ?>_num+"][<?= $pluginMode['filter'] ?>]']").val(<?= $pluginMode['filter'] ?>);
                $("select[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>]'] option:selected").remove();

                <?= $modeName ?>List.push(<?= $pluginMode['filter'] ?>);
                $("input[name='services[process][<?= $modeName ?>][<?= $pluginMode['filter'] ?>List]']").val(<?= $modeName ?>List.toString());

                <?= $modeName ?>_num++;

                // Disable the button, again.
                $("#add-new-<?= $modeName ?>-service").prop("disabled", true);
            });
        });
    </script>
<?php
        }
    }
?>