<?php
$hostname = grab_array_var($inargs, "hostname", "");
$address = grab_array_var($inargs, "ip_address", "");
$ssl = grab_array_var($inargs, "ssl", "on");
$hostaddress = $address;

$services_serial = grab_array_var($inargs, "services_serial", "");
$serviceargs_serial = grab_array_var($inargs, "serviceargs_serial", "");

$services = json_decode(base64_decode($services_serial), true);
$serviceargs = json_decode(base64_decode($serviceargs_serial), true);

// Save data for later use in re-entrance
$meta_arr = array();
$meta_arr["hostname"] = $hostname;
$meta_arr["ip_address"] = $address;
$meta_arr["services"] = $services;
$meta_arr["serviceargs"] = $serviceargs;
save_configwizard_object_meta($wizard_name, $hostname, "", $meta_arr);

$objs = array();

if (!host_exists($hostname)) {
    $objs[] = array(
        "type" => OBJECTTYPE_HOST,
        "use" => "xiwizard_linuxserver_host",
        "host_name" => $hostname,
        "address" => $hostaddress,
        "icon_image" => "nsclient.png",
        "statusmap_image" => "nsclient.png",
        "_xiwizard" => $wizard_name,
    );
}

// Optional non-SSL args to add
$sslargs = "";
if ($ssl == "off") {
    $sslargs .= " -n";
}

// See which services we should monitor
foreach ($services as $svc => $svcstate) {

    switch ($svc) {

        case "ping":
            $objs[] = array(
                "type" => OBJECTTYPE_SERVICE,
                "host_name" => $hostname,
                "service_description" => "Ping",
                "use" => "xiwizard_linuxserver_ping_service",
                "_xiwizard" => $wizard_name,
            );
            break;

        case "commands":

            $enabledcmds = $svcstate;
            foreach ($enabledcmds as $pid => $pstate) {

                $pname = $serviceargs["commands"][$pid]["command"];
                $pargs = $serviceargs["commands"][$pid]["args"];
                $pdesc = $serviceargs["commands"][$pid]["name"];

                $checkcommand = "check_xi_nrpe_nsclient!" . $pname . "!" . $sslargs;
                if (!empty($pargs)) {
                    $checkcommand .= " -a '" . $pargs . "'";
                }
                
                if ($pdesc != "") {
                    $objs[] = array(
                        "type" => OBJECTTYPE_SERVICE,
                        "host_name" => $hostname,
                        "service_description" => $pdesc,
                        "use" => "generic-service",
                        "check_command" => $checkcommand,
                        "_xiwizard" => $wizard_name,
                    );
                }
            }
            break;

        default:
            break;
    }
}

// Return the object definitions to the wizard
$outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;
?>