<?php
//
// NagVis Integration Component
// Copyright (c) 2010-2023 - Nagios Enterprises, LLC. All rights reserved.
//


require_once(dirname(__FILE__) . '/../componenthelper.inc.php');


$nagvis_component_name = "nagvis";
nagvis_component_init();


////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////


function nagvis_component_init()
{
    global $nagvis_component_name;
    $versionok = nagvis_component_checkversion();

    $desc = "";
    if (!$versionok) {
        $desc = "<b>" . _("Error: This component requires Nagios XI 2009R1.2B or later.") . "</b>";
    }

    $installok = nagvis_component_checkinstallation();
    if (!$installok) {
        $desc .= "<b>" . _("Installation Required!") . "</b>  " .
            _("You must login to the server as the root user and run the following commands to complete the installation of this component") . ":<br>
        <i>cd /usr/local/nagiosxi/html/includes/components/" . $nagvis_component_name . "/</i><br>
        <i>chmod +x install.sh</i><br>
        <i>./install.sh</i><br>";
    }

    $args = array(
        COMPONENT_NAME => $nagvis_component_name,
        COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION => _("This component incorporates NagVis and it's maps into Nagios XI. ") . $desc,
        COMPONENT_TITLE => "NagVis Integration",
        COMPONENT_VERSION => '2.5.3'
    );

    register_component($nagvis_component_name, $args);

    if ($versionok) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'nagvis_component_addmenu');
    }
}


///////////////////////////////////////////////////////////////////////////////////////////
// MISC FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////


function nagvis_component_checkversion()
{

    if (!function_exists('get_product_release'))
        return false;
    //requires greater than 2009R1.2
    if (get_product_release() < 114)
        return false;

    return true;
}


function nagvis_component_addmenu($arg = null)
{
    global $nagvis_component_name;

    $mi = find_menu_item(MENU_HOME, "menu-home-section-maps", "id");

    $order = grab_array_var($mi, "order", "");
    if ($order == "")
        return;

    $neworder = $order + 1;
    add_menu_item(MENU_HOME, array(
        "type" => "linkspacer",
        "title" => "",
        "id" => "menu-home-nagvis-spacer",
        "order" => $neworder,
        "opts" => array()
    ));

    $neworder += 1;
    add_menu_item(MENU_HOME, array(
        "type" => "link",
        "title" => "NagVis",
        "id" => "menu-home-nagvis",
        "order" => $neworder,
        "opts" => array(
            "href" => '/nagiosxi/includes/components/nagvis/',
            "icon" => "fa-image"
        )
    ));

    $neworder += 1;
    add_menu_item(MENU_HOME, array(
        "type" => "linkspacer",
        "title" => "",
        "id" => "menu-home-nagvis-spacer2",
        "order" => $neworder,
        "opts" => array()
    ));
    
}


/**
 * Checks to see if there is a NagVis installation present
 *
 * @return  bool    True if installed
 */
function nagvis_component_checkinstallation()
{
    if (!file_exists("/usr/local/nagvis/share/index.php")) {
        return false;
    }
    return true;
}


/**
 * Add NagVis maps to the menus (not used yet, leftover from early dev)
 */
function nagvis_component_add_maps($address)
{
    $path = '/usr/local/nagvis/etc/maps/';

    if (isset($address)) {
        $map_url = 'http://' . $address . '/nagvis/frontend/nagvis-js/index.php?mod=Map&act=view&show=';

        $content = scandir($path);
        if ($content) {
            foreach ($content as $fileinfo) {
                $mi = find_menu_item(MENU_HOME, "menu-home-section-maps", "id");
                if ($mi == null)
                    return;

                $order = grab_array_var($mi, "order", "");
                if ($order == "")
                    return;

                $neworder = $order + 0.1;

                if (($fileinfo[0] != ".") && ($fileinfo != 'autobackup.status') && ($fileinfo[0] != "_")) {
                    $file = basename($fileinfo, '.cfg');
                    $title = ucfirst($file);
                    add_menu_item(MENU_HOME, array(
                        "type" => "link",
                        "title" => $title,
                        "id" => "menu-home-" . $file,
                        "order" => $neworder,
                        "opts" => array(
                            "href" => $map_url . $file
                        )
                    ));
                }
            }
        }
    }
}
