<?php
//
// Latest Alerts Dashlet
// Copyright (c) 2010-2019 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../../dashlets/dashlethelper.inc.php');

function latestalerts_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{
    $output = "";
    $imgbase = get_base_url() . "includes/components/latestalerts/images/";

    switch ($mode) {

        case DASHLET_MODE_GETCONFIGHTML:
            break;

        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:

            $output = "";
            $id = "latestalerts_" . random_string(6);
            $ajaxargs = $args;
            $n = 0;

            $jargs = "{";
            foreach ($ajaxargs as $var => $val) {
                if ($n > 0)
                    $jargs .= ", ";
                $jargs .= "\"$var\" : \"$val\"";
                $n++;
            }
            $jargs .= "}";

            $output .= '
			<div class="latestalerts_dashlet dashlet-auto-overflow" id="' . $id . '">
						
			<div class="infotable_title">'._("Latest Alerts").'</div>
			' . get_throbber_html() . '
						
			</div><!--ahost_status_summary_dashlet-->

			<script type="text/javascript">
			$(document).ready(function(){
			
				get_' . $id . '_content();
					
				$("#' . $id . '").everyTime(90*1000, "timer-' . $id . '", function(i) {
					get_' . $id . '_content();
				});
				
				function get_' . $id . '_content(){
					$("#' . $id . '").each(function(){
						var optsarr = {
							"func": "get_latestalerts_dashlet_html",
							"args": ' . $jargs . '
							}
						var opts=JSON.stringify(optsarr);
						get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
						});
					}
			});
			</script>
			';

            break;

        case DASHLET_MODE_PREVIEW:
            
            if(!is_neptune()) {
                $output = "<p><img src='" . $imgbase . "preview.png'></p>";
            } else if (get_theme() == 'neptunelight') {
                $output = "<img src='" . $imgbase . "latest_alerts_neptune_light_preview.png'>";
            } else {
                $output = "<img src='" . $imgbase . "neptune_preview.png'>";
            }

            break;
    }

    return $output;
}