<?php
/**
 * MagpieRSS Parser - PHP 8+ safe, namespace-safe, reliable data capture
 */

class MagpieRSS {
    var $parser;
    var $current_tag = '';
    var $current_item = array();
    var $items = array();
    var $channel = array();
    var $textinput = array();
    var $image = array();
    var $data = '';
    var $encoding = '';
    var $ERROR = '';

    function __construct($source, $encoding = 'UTF-8') {
        $this->encoding = strtoupper($encoding ?: 'UTF-8');
        $this->parser = xml_parser_create($this->encoding);

        if (!$this->parser) {
            $this->ERROR = "Failed to create XML parser with encoding {$this->encoding}";
            return;
        }

        // Uppercase tags internally — we'll normalize ourselves later
        xml_parser_set_option($this->parser, XML_OPTION_CASE_FOLDING, 1);
        xml_parser_set_option($this->parser, XML_OPTION_SKIP_WHITE, 1);

        xml_set_object($this->parser, $this);
        xml_set_element_handler($this->parser, 'startElement', 'endElement');
        xml_set_character_data_handler($this->parser, 'characterData');

        // Remove UTF-8 BOM if present
        if (substr($source, 0, 3) === "\xEF\xBB\xBF") {
            $source = substr($source, 3);
        }

        if (!xml_parse($this->parser, $source, true)) {
            $this->ERROR = sprintf(
                "XML error: %s at line %d",
                xml_error_string(xml_get_error_code($this->parser)),
                xml_get_current_line_number($this->parser)
            );
            xml_parser_free($this->parser);
            return;
        }

        xml_parser_free($this->parser);
    }

    function startElement($parser, $tag, $attributes) {
        $this->current_tag = $tag;
        $this->data = ''; // reset data buffer for this tag

        if ($tag === 'ITEM' || $tag === 'ENTRY') {
            $this->current_item = array(
                'title' => '',
                'link' => '',
                'description' => ''
            );
        }
    }

    function endElement($parser, $tag) {
        // Strip namespace prefixes like "media:title" → "title"
        $tag_normalized = strtolower(preg_replace('/^.*:/', '', $tag));
        $value = trim($this->data);

        if ($value !== '') {
            if (!empty($this->current_item) || $tag === 'ITEM' || $tag === 'ENTRY') {
                // Store into current item
                $this->current_item[$tag_normalized] = $value;
            } else {
                // Store into channel-level metadata
                $this->channel[$tag_normalized] = $value;
            }
        }

        if ($tag === 'ITEM' || $tag === 'ENTRY') {
            $this->items[] = $this->current_item;
            $this->current_item = array();
        }

        $this->data = '';
        $this->current_tag = '';
    }

    function characterData($parser, $data) {
        // Append raw character data — may be called multiple times for one tag
        $this->data .= $data;
    }
}
