    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">

        <h2><?= _('Server Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="address" class="form-label"><?= _('Server Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="address" id="address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Server Address") ?>" disabled="on">
                    <i id="address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The host name you would like to have associated with this server.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Integers') ?></h2>
        <p><?= _('Fill in these fields to create services that checks the value of field containing an integer.') ?></p>

        <div id="integers-list" class="adddeleterow">
             <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold"><?= _('Service Description') ?> <?= xi6_info_tooltip(_('Give a name for the new service. This will identify the purpose of the check, such as the specific string value or key being monitored.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('URL') ?> <?= xi6_info_tooltip(_('Enter the URL of the endpoint or resource to be monitored. Ensure it includes the protocol (e.g., http:// or https://) and the full path to the resource.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold"><?= _('Key') ?> <?= xi6_info_tooltip(_('Since the XML is converted into an array, the key can be much like a PHP variable. Examples: list[5][host_status], object[health][status_code], temperature')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold text-center"><?= _('Thresholds') ?> <?= xi6_info_tooltip(_('If a match type is numeric, you must set a warning and critical value<br>Use the following syntax to define value ranges for the thresholds:<br>10 -> alert triggered when outside range of {0 .. 10}<br> 10: -> alert triggered when outside range of {10 .. inf}<br> ~10 -> alert triggered when outside range of {-inf .. 10}<br>10:20 -> alert triggered when outside range of {10 .. 20}<br> @10:20 -> alert triggered when inside range of {10 .. 20}<br>If a match is a string, it must match the string exactly or it will be critical.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('Additional Header') ?>  <?= xi6_info_tooltip(_('Specify any custom HTTP headers to be sent with the request. Use this to pass authentication details or other required metadata.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($services["integer_check"]); $x++) {
?>
         <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="col-sm-2 mt-0 d-flex align-items-center flex-column">
                        <input type="text" name="services[integer_check][<?= $x ?>][desc]" id="integer_check_desc<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["desc"]) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="integer_check_desc_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <input type="text" name="services[integer_check][<?= $x ?>][url]" id="integer_check_url<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["url"]) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="integer_check_url_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-2 mt-0">
                        <input type="text" name="services[integer_check][<?= $x ?>][key]" id="integer_check_key<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["key"]) ?>" class="form-control form-control-sm rounded monitor" placeholder="list[5][host_status], object[health][status_code], temperature">
                        <i id="integer_check_key_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-2 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="services[integer_check][<?= $x ?>][warning]" id="integer_check_warning<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["warning"]) ?>" class="form-control form-control-sm rounded-end monitor">
                            <i id="integer_check_warning_<?= $x ?>_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="services[integer_check][<?= $x ?>][critical]" id="integer_check_critical<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["critical"]) ?>" class="form-control form-control-sm rounded-end monitor">
                            <i id="integer_check_critical_<?= $x ?>_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0 string<?= (!empty($string_hide) ? $string_hide : '') ?>">
                        <input type="text" name="services[integer_check][<?= $x ?>][header]" id="integer_check_header<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["header"]) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="integer_check_header_<?= $x ?>_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
            }
?>
        </div> <!-- integers-list adddeleterow -->

        <h2 class="mt-4"><?= _('Strings') ?></h2>
        <p><?= _('Fill in these fields to create a service that checks the value of field containing a string.') ?></p>

        <div id="strings-list" class="adddeleterow">
             <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold"><?= _('Service Description') ?> <?= xi6_info_tooltip(_('Give a name for the new service. This will identify the purpose of the check, such as the specific string value or key being monitored.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('URL') ?> <?= xi6_info_tooltip(_('Enter the URL of the endpoint or resource to be monitored. Ensure it includes the protocol (e.g., http:// or https://) and the full path to the resource.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm">
                            <label class="form-check-label bold"><?= _('Key') ?> <?= xi6_info_tooltip(_('Since the XML is converted into an array, the key can be much like a PHP variable. Examples: list[5][host_status], object[health][status_code], temperature')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($services["string_check"]); $x++) {
?>
         <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="col-sm-2 mt-0 d-flex align-items-center flex-column">
                        <input type="text" name="services[string_check][<?= $x ?>][desc]" id="string_check_desc<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["desc"]) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="string_check_desc_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <input type="text" name="services[string_check][<?= $x ?>][url]" id="string_check_url<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["url"]) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="string_check_url_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="d-inline-flex w-100 pb-1">
                            <input type="text" name="services[string_check][<?= $x ?>][key]" id="string_check_key<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["key"]) ?>" class="form-control form-control-sm rounded-end monitor" placeholder="list[5][host_status], object[health][status_code], temperature">
                            <i id="string_check_key_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="d-inline-flex w-100 pb-1">
                            <div class="input-group input-group-sm w-100">
                                <span class="input-group-text">
                                    <label class="form-check-label bold text-center"><?= _('String') ?></label>
                                </span>
                                <input type="text" name="services[string_check][<?= $x ?>][string]" id="string_check_string<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["string"]) ?>" class="form-control form-control-sm rounded-end monitor">
                                <i id="string_check_string_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="d-inline-flex pb-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <label class="form-check-label bold text-center"><?= _('Match Found') ?></label>
                                </span>
                                <select name="services[string_check][<?= $x ?>][result_code_if_match]" id="string_check_result_code_if_match[<?= $x ?>]" class="form-control form-control-sm form-select form-select-sm rounded-end monitor">
                                    <option value="0" <?= is_selected(0, $services["string_check"][$x]["result_code_if_match"]) ?>>OK</option>
                                    <option value="1" <?= is_selected(1, $services["string_check"][$x]["result_code_if_match"]) ?>>WARNING</option>
                                    <option value="2" <?= is_selected(2, $services["string_check"][$x]["result_code_if_match"]) ?>>CRITICAL</option>
                                    <option value="3" <?= is_selected(3, $services["string_check"][$x]["result_code_if_match"]) ?>>UNKNOWN</option>
                                </select>
                                <i id="string_check_result_code_if_match_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="d-inline-flex pb-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <label class="form-check-label bold text-center"><?= _('No Match Found') ?></label>
                                </span>
                                <select name="services[string_check][<?= $x ?>][result_code_if_no_match]" id="string_check_result_code_if_no_match[<?= $x ?>]" class="form-control form-control-sm form-select form-select-sm rounded-end monitor">
                                    <option value="0" <?= is_selected(0, $services["string_check"][$x]["result_code_if_no_match"]) ?>>OK</option>
                                    <option value="1" <?= is_selected(1, $services["string_check"][$x]["result_code_if_no_match"]) ?>>WARNING</option>
                                    <option value="2" <?= is_selected(2, $services["string_check"][$x]["result_code_if_no_match"]) ?>>CRITICAL</option>
                                    <option value="3" <?= is_selected(3, $services["string_check"][$x]["result_code_if_no_match"]) ?>>UNKNOWN</option>
                                </select>
                                <i id="string_check_result_code_if_no_match_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="d-inline-flex w-100">
                            <div class="input-group input-group-sm w-100">
                                <span class="input-group-text">
                                    <label class="form-check-label bold"><?= _('Additional Header') ?></label>
                                </span>
                                <input type="text" name="services[string_check][<?= $x ?>][header]" id="string_check_header<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["header"]) ?>" class="form-control form-control-sm rounded-end monitor">
                                <i id="string_check_header_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }
?>
        </div> <!-- strings-list adddeleterow -->

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
