    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="url" value="<?= encode_form_val($url) ?>">
    <input type="hidden" name="apikey" value="<?= encode_form_val($apikey) ?>">
    <input type="hidden" name="old_auth" value="<?= intval($old_auth) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="ticket" value="<?= encode_form_val($ticket) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Nagios XI Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The host name you would like to have associated with this Nagios XI server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Hostname") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="url" class="form-label">URL </label>
                <div class="input-group position-relative">
                    <input type="text" name="url" id="url" value="<?= encode_form_val($url) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter URL") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the URL") ?>
                    </div>
                    <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Nagios XI Server Metrics') ?></h2>
        <p><?= _('Specify the metrics you would like to monitor on the remote Nagios server') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-12 mt-0 pt-1">
                        <input type="checkbox" id="p" class="form-check-input" name="services[ping]"  <?= is_checked(grab_array_var($services, "ping"), "on") ?> >
                        <label for="p" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Checks the server with an ICMP ping. Useful for monitoring network availability of the Nagios server")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-12 mt-0 pt-1">
                        <input type="checkbox" id="wui" class="form-check-input" name="services[webui]"  <?= is_checked(grab_array_var($services, "webui"), "on") ?> >
                        <label for="wui" class="form-check-label bold"><?= _('Nagios XI Web Interface') ?> <?= xi6_info_tooltip(_("Checks the availability of the remote Nagios XI server&apos;s web interface")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-12 mt-0 pt-1">
                        <input type="checkbox" id="md" class="form-check-input" name="services[daemons]"  <?= is_checked(grab_array_var($services, "daemons"), "on") ?> >
                        <label for="md" class="form-check-label bold"><?= _('Monitoring Daemons') ?> <?= xi6_info_tooltip(_("Monitors the XI server to ensure the monitoring engine and supporting daemons are running")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-12 mt-0 pt-1">
                        <input type="checkbox" id="mj" class="form-check-input" name="services[jobs]"  <?= is_checked(grab_array_var($services, "jobs"), "on") ?> >
                        <label for="mj" class="form-check-label bold"><?= _('Monitoring Jobs') ?> <?= xi6_info_tooltip(_("Monitors the XI server to ensure the core jobs are running")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="l" class="form-check-input" name="services[load]"  <?= is_checked(grab_array_var($services, "load"), "on") ?> >
                        <label for="l" class="form-check-label bold"><?= _('Load') ?> <?= xi6_info_tooltip(_("Monitors the load on the server (1/5/15 minute values)")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[load_warning]" name="serviceargs[load_warning]" value="<?= encode_form_val(grab_array_var($serviceargs, "load_warning")) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_load_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[load_critical]" name="serviceargs[load_critical]" value="<?= encode_form_val(grab_array_var($serviceargs, "load_critical")) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_load_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="iow" class="form-check-input" name="services[iowait]"  <?= is_checked(grab_array_var($services, "iowait"), "on") ?> >
                        <label for="iow" class="form-check-label bold"><?= _('I/O Wait') ?> <?= xi6_info_tooltip(_("Monitors the server iowait CPU statistics (a measure of disk read/write wait time)")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[iowait_warning]" name="serviceargs[iowait_warning]" value="<?= encode_form_val(grab_array_var($serviceargs, "iowait_warning")) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_iowait_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[iowait_critical]" name="serviceargs[iowait_critical]" value="<?= encode_form_val(grab_array_var($serviceargs, "iowait_warning")) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_iowait_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
