    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= intval($port) ?>">
    <input type="hidden" name="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>">
    <input type="hidden" name="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="snmpopts_serial" value="<?= base64_encode(json_encode($snmpopts)) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2><?= _('Linux Machine Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name to associate with this Linux machine.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row-mb-2">
            <div class="col-sm-6">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check mt-0 pt-1">
                        <input type="checkbox" id="legacy_perfdata" class="form-check-input" name="legacy_perfdata"  <?= is_checked($legacy_perfdata, "1") ?> >
                        <label for="legacy_perfdata" class="form-check-label bold"><?= _("Legacy Performance Data Order"); ?> <?= xi6_info_tooltip(_('Check this box if you\'re re-running this wizard for a host configured before upgrading to Nagios XI 2024R1.1.5.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    // Error if any of the snmpwalks failed
    if ($walksuccess == 0) {
?>
        <div class="alert alert-danger mt-4 w-75">
            <p>
                <span style="font-weight: bold;" class="text-regular"><?= _('The wizard detected this server does not have snmpwalk permission on the target host') ?></span>
                <br>
                <?= _('(This may be caused by a timing issue and may resolve by reload this page)') ?>
            </p>
            <?= _('If this server does not have snmpwalk permission on the target host, it will prevent auto population of processes and prevent them from running successfully, but you can continue with the wizard manually.') ?>
            <br>
            <?= _('To troubleshoot this ensure that these OIDs are available on the target host:') ?>
            <br>
            "HOST-RESOURCES-MIB::hrSWRunName"<?= _(' and ') ?>"HOST-RESOURCES-MIB::hrFSMountPoint"
        </div>
<?php
    }
?>
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the Linux machine') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[ping]" class="form-check-input" name="services[ping]"  <?= is_checked($services['ping'], "1") ?> >
                        <label for="services[ping]" class="form-check-label bold"><?= _("Ping"); ?> <?= xi6_info_tooltip(_('Ping')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[cpu]" class="form-check-input" name="services[cpu]"  <?= is_checked($services['cpu'], "1") ?> >
                        <label for="services[cpu]" class="form-check-label bold"><?= _('CPU') ?> <?= xi6_info_tooltip(_('Monitors the CPU (processor usage) on the machine.')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[cpu_warning]" name="serviceargs[cpu_warning]" value="<?= encode_form_val($serviceargs['cpu_warning']) ?>" class="form-control form-control-sm monitor">
		                    <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_cpu_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[cpu_critical]" name="serviceargs[cpu_critical]" value="<?= encode_form_val($serviceargs['cpu_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_cpu_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[memory]" class="form-check-input" name="services[memory]"  <?= is_checked($services['memory'], "1") ?> >
                        <label for="services[memory]" class="form-check-label bold"><?= _('Physical Memory Usage') ?> <?= xi6_info_tooltip(_('Monitors the physical (real) memory usage on the machine. To run with memory buffers, unselect the checkbox.')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[memory_warning]" name="serviceargs[memory_warning]" value="<?= encode_form_val($serviceargs['memory_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_memory_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[memory_critical]" name="serviceargs[memory_critical]" value="<?= encode_form_val($serviceargs['memory_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_memory_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[pagefile]" class="form-check-input" name="services[pagefile]"  <?= is_checked($services['pagefile'], "1") ?> >
                        <label for="services[pagefile]" class="form-check-label bold"><?= _('Swap Usage') ?> <?= xi6_info_tooltip(_('Monitors the swap usage on the machine.')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[pagefile_warning]" name="serviceargs[pagefile_warning]" value="<?= encode_form_val($serviceargs['pagefile_warning']) ?>" class="form-control form-control-sm monitor">
		                    <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_pagefile_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[pagefile_critical]" name="serviceargs[pagefile_critical]" value="<?= encode_form_val($serviceargs['pagefile_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text rounded-end">%</span>
                            <i id="serviceargs_pagefile_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    // Add border block, if data is available.
    if (!empty($disk)) {
?>
        <div class="col-sm border-block">
<?php
    } else {
?>
        <div class="col-sm-6 border-block">
<?php
    }
?>
            <div class="row">
                <div class="col-sm-6">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm mt-0 pt-1">
                            <input type="checkbox" id="du" class="form-check-input" name="services[disk]" <?= is_checked($services['disk'], "1") ?>>
                            <label for="du" class="form-check-label bold"><?= _('Disk Usage') ?> <?= xi6_info_tooltip(_("Monitors disk usage on the machine.")) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    // Process if disk data is available
    if (!empty($disk)) {
?>
            <div class="ms-4 w-50 alert alert-primary"><?= sprintf(_('The SNMP wizard detected %d disks and mounts on %s'), $disk_count, $address); ?></div>
<?php
    }
?>
            <div id="diskListDiv" class="diskList">
                <div class="adddeleterow position-relative">
                    <div class="row">
                        <div class="col-sm<?= (!empty($disk) ? '-6 pe-0' : '') ?>">
                            <fieldset class="row g-2 mb-1 pb-0">
                                <div class="form-check col-sm-4 mt-0">
                                    <div class="input-group input-group-sm">
                                        <label class="form-check-label bold"><?= _('Drive') ?></label>
                                    </div>
                                </div>
                                <div class="col-sm-4 form-label bold mt-0">
                                    <div class="input-group input-group-sm">
                                        <label class="form-check-label bold"><?= _('Warning') ?></label>
                                    </div>
                                </div>
                                <div class="col-sm-4 form-label bold mt-0">
                                    <div class="input-group input-group-sm">
                                        <label class="form-check-label bold"><?= _('Critical') ?></label>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
<?php
    for ($x = 0; $x < count($serviceargs["disk"]); $x++) {
        $checkedstr = "";

        if ($x == 0) {
            $checkedstr = "checked";
        }
?>
                    <div class="row">
                        <div class="col-sm<?= (!empty($disk) ? '-6 pe-0' : '') ?>">
                            <fieldset class="row g-2 mb-1 wz-fieldset">
                                <div class="form-check col-sm-4 mt-0">
                                    <div class="input-group input-group-sm">
                                        <input type="text" name="serviceargs[disk][<?= $x ?>]" id="serviceargs[disk][<?= $x ?>]" value="<?= encode_form_val($serviceargs["disk"][$x]) ?>" class="form-control form-control-sm rounded-end">
                                        <i id="serviceargs_disk_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="col-sm-4 mt-0">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">
                                            <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                        </span>
                                        <input type="text" id="serviceargs[disk_warning][<?= $x ?>]" name="serviceargs[disk_warning][<?= $x ?>]" value="<?= encode_form_val($serviceargs['disk_warning'][$x]) ?>" class="form-control form-control-sm monitor">
                                        <span class="input-group-text rounded-end">%</span>
                                        <i id="serviceargs_disk_warning_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                                <div class="col-sm-4 mt-0">
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">
                                            <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                        </span>
                                        <input type="text" id="serviceargs[disk_critical][<?= $x ?>]" name="serviceargs[disk_critical][<?= $x ?>]" value="<?= encode_form_val($serviceargs['disk_critical'][$x]) ?>" class="form-control form-control-sm monitor">
                                        <span class="input-group-text rounded-end">%</span>
                                        <i id="serviceargs_disk_critical_<?= $x ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="col-sm-6 position-absolute top-0 start-50 ps-0">
<?php
        // only display select box if we have services to display
        if (!empty($disk) && $x < 1) {
?>
                            <fieldset class="row g-2 pb-0">
                                <div class="mt-0">
                                    <div class="input-group input-group-sm mb-1">
                                        <label for="diskList" class="form-label bold"><?= _("Scanned Disk List &nbsp; (double click to add)") ?></label>
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset class="row g-2 mb-1 pb-0">
                                <div class="mt-0">
                                    <select multiple="multiple" size="7" id="diskList" class="form-control form-control-sm form-select form-select-sm mb-2"></select>
                                </div>
                            </fieldset>
<?php
        }
?>
                        </div>
                    </div> <!-- row -->
<?php
    }
?>
                </div> <!-- adddeleterow -->
            </div> <!-- diskListDiv diskList -->

        </div> <!-- border-block -->

        <h2 class="mt-4"><?= _('Processes') ?></h2>
        <p class="mb-2"><?= _('Specify any processes that should be monitored to ensure they\'re running') ?>.

        <br><strong>Note:</strong> <?= _('Process names are case-sensitive. Click on Tips for more information about creating a process service') ?>
        <br><br>
        <input type="hidden" value="<?= intval($ptips) ?>" id="ptips" name="ptips">
        <a id="process-tip-btn" style="padding-left: 10px;" class="tt-bind" title="<?= _('Toggle Process Service Tips') ?>"><?= _('Tips') ?>
<?php
    if (!$ptips) {
?>
            <i class="fa fa-chevron-up"></i></a>
<?php
        $tip_display = "display: none;";
    } else {
?>
            <i class="fa fa-chevron-down"></i></a>
<?php
        $tip_display = "";
    }

    $wc_example = encode_form_val('-w \'[minWarn],[maxWarn]\' -c \'[minCrit],[maxCrit]\'');
    $wc_format = encode_form_val('[minCrit] <= [minWarn] < [maxWarn] <= [maxCrit]');
    $w_mix_example = encode_form_val('-w \'[minWarn]\' -c \'[minCrit],[maxCrit]\'');
    $w_mix_format = encode_form_val('[minCrit] <= [minWarn] < [maxCrit]');
    $c_mix_example = encode_form_val('-w \'[minWarn],[maxWarn]\' -c \'[minCrit]\'');
    $c_mix_format = encode_form_val('[minCrit] <= [minWarn] < [maxWarn]');
?>
        <div id="process-tips" style="<?= $tip_display ?> margin-left: 20px; border: 1px solid #ddd; max-width: 800px; padding: 5px;"><?= _('The <i>Warning</i> and <i>Critical</i> fields can contain two numbers separated by a comma that represent thresholds for the number of processes that should be running') ?>
            <br><br> <?= _('A field value of <i>5,10</i> would generate a <i>Warning</i> or <i>Critical</i> alert if there were less than or equal to 5 or more than 10 processes found') ?>
            <br><br> <?= _('If you choose to provide no <i>Warning</i> or <i>Critical</i> value the service will return an OK state if the number of processes is > 0 and critical if none are found') ?>
            <br><br> <?= _('You may provide a <i>Warning</i> threshold without a <i>Critical</i> threshold, but if you provide a <i>Critical</i> threshold you <i>must</i> provide a <i>Warning</i> threshold') ?>
            <br><br> <?= _('When providing single warning and critical values <i>Warning</i> must be >= <i>Critical</i>') ?>
            <br><br> <?= _('When providing <i>thresholds</i> in the following formats, these rules apply:') ?><br><br>
            <div>
                <div style="float: left; margin-right: 20px;">
                    <?= $wc_example ?><br><br>
                    <?= $w_mix_example ?><br><br>
                    <?= $c_mix_example ?>
                </div>
                <div style="margin-left:10px;">
                    <b><?= $wc_format ?></b><br><br>
                    <b><?= $w_mix_format ?></b><br><br>
                    <b><?= $c_mix_format ?></b>
                </div>
            </div>
        </div>
    </p>
<?php
    // show message if process data available
    if (!empty($process)) {
?>
        <div class="ms-4 w-50 alert alert-primary"><?= sprintf(_('The SNMP wizard detected %d processes on %s'), $process_count, $address); ?></div>
<?php
    }
?>
        <div id="processListDiv" class="processList">
            <div class="adddeleterow position-relative">
                <div class="row">
                    <div class="col-sm-6 pe-0">
                        <fieldset class="row g-2 mb-0">
                            <div class="d-flex align-items-end form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <label class="form-check-label bold"><?= _('Linux Process') ?></label>
                                </div>
                            </div>
                            <div class="d-flex align-items-end col-sm-4">
                                <label class="form-check-label bold"><?= _('Display Name') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-2 text-center">
                                <label class="form-check-label bold"><?= _('Warning Count') ?></label>
                            </div>
                            <div class="d-flex align-items-end col-sm-2">
                                <label class="form-check-label bold text-center"><?= _('Critical Count') ?></label>
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
    for ($x = 0; $x < count($serviceargs['processstate']); $x++) {
        $processstring = encode_form_val($serviceargs['processstate'][$x]['process']);
        $processname = encode_form_val($serviceargs['processstate'][$x]['name']);
        $processwarn = encode_form_val($serviceargs['processstate'][$x]['warn']);
        $processcrit = encode_form_val($serviceargs['processstate'][$x]['crit']);

        $is_checked = isset($services["processstate"][$x]) ? is_checked($services["processstate"][$x]) : '';
?>
                <div class="row">
                    <div class="col-sm-6 pe-0">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-4 mt-0">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" id="services[processstate][<?= $x ?>]" class="form-check-input mt-2 me-2" name="services[processstate][<?= $x ?>]" <?= $is_checked ?>>
<?php
        if (!empty($process)) { // snmpwalk has data- create process select list
?>
                                    <input type="text" name="serviceargs[processstate][<?= $x ?>][process]" id="serviceargs[processstate][<?= $x ?>][process]" value="<?= $processstring ?>" class="processList form-control form-control-sm rounded monitor">
<?php
        } else { // snmpwalk did not return data
?>
                                    <input type="text" name="serviceargs[processstate][<?= $x ?>][process]" id="serviceargs[processstate][<?= $x ?>][process]" value="<?= $processstring ?>" class="form-control form-control-sm rounded monitor">
<?php
        }
?>
                                    <i id="serviceargs_processstate_<?= $x ?>_process_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-4 mt-0">
                                <input type="text" name="serviceargs[processstate][<?= $x ?>][name]" id="serviceargs[processstate][<?= $x ?>][name]" value="<?= $processname ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_processstate_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                                    </span>
                                    <input type="text" name="serviceargs[processstate][<?= $x ?>][warn]" id="serviceargs[processstate][<?= $x ?>][warn]" value="<?= $processwarn ?>" class="form-control form-control-sm rounded-end">
                                    <i id="serviceargs_processstate_<?= $x ?>_warn_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                                    </span>
                                    <input type="text" name="serviceargs[processstate][<?= $x ?>][crit]" id="serviceargs[processstate][<?= $x ?>][crit]" value="<?= $processcrit ?>" class="form-control form-control-sm rounded-end">
                                    <i id="serviceargs_processstate_<?= $x ?>_crit_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                    <div class="col-sm-6 position-absolute top-0 start-50 ps-0">
<?php
        // only display select box if we have processes to display
        if (!empty($process) && $x < 1) {
?>
                        <div class="row">
                            <div class="col-sm pe-0">
                                <fieldset class="row g-2 mb-0">
                                    <div class="d-flex align-items-end col-sm mt-2">
                                        <div class="input-group input-group-sm">
                                            <label for="processList" class="form-check-label bold"><?= _("Scanned Process List") ?></label>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm pe-0">
                                <fieldset class="row g-2 mb-1">
                                    <div class="col-sm mt-0">
                                        <select multiple="multiple" size="7" id="processList" class="form-control form-control-sm form-select form-select-sm"></select>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm pe-0">
                                <fieldset class="row g-2 mb-1">
                                    <div class="col-sm mt-0">
                                        <a id="addProc" class="btn btn-link">Add Selected</a> | <a name="selectAll" id="selectAllProc" class="btn btn-link">Select All</a>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
<?php
        }
?>
                    </div> <!-- col-sm-6 processList -->
                </div> <!-- row -->
<?php
    }
?>
            </div> <!-- adddeleterow processList -->
        </div> <!-- processListDiv -->

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function () {
            wizard_populate();

            var proccount = 0;

            // smart process selecter
            $("#addProc").click(function() {
                var element = "";
                var element = $("#processList option:selected");
                var selected = element.length;
                var value = element.text();

                row_count = get_empty_field_count("process");

                if (selected > row_count) {
                    row_count = get_empty_field_count("process");

                    // count how many rows we need to trigger
                    var create_inputs = selected - row_count;

                    for (i = 0; i < create_inputs; i++) {
                        //$(this).parent().prev().find("a.wizard-add-row").trigger("click");
                        $(".processList").find("a.wizard-add-row").trigger("click");
                    }
                }

                if (selected > 1) {
                    $.each(element, function() {
                        value = $(this).html();
                        $(this).remove();

                        // find empty input
                        target = $("[name^='serviceargs[processstate][" + proccount + "][process]']").filter(function() { return $(this).val() == ""; });
                        target.val(value);

                        name = target[0]["name"];
                        $("[name=" + "'" + name + "'" + "]").parent('div').parent('div').next("div").children("input").val(value);

                        proccount++;
                    });

                    check_box_with_value();
                } else {
                    element.remove();

                    target = $("[name^='serviceargs[processstate][" + proccount + "][process]']").filter(function() { return $(this).val() == ""; });
                    target = target[0];
                    target = target["name"];

                    $("[name=" + "'" + target + "'" + "]").val(value);
                    $("[name=" + "'" + target + "'" + "]").parent('div').parent('div').next("div").children("input").val(value);

                    proccount++;
                    check_box_with_value();
                }
            });

            // allow single double-click selector as well
            $("#processList").on("dblclick", function() {
                var element = "";
                var element = $("#processList option:selected");
                var selected = element.length;
                var value = element.text();
                element.remove();

                row_count = get_empty_field_count("process");

                // add row if needed
                if (row_count < 1) {
                    //$("#processList").parent().prev().find("a.wizard-add-row").trigger("click");
                    $(".processList").find("a.wizard-add-row").trigger("click");
                }

                // find empty input
                var target = $("[name^='serviceargs[processstate]']").filter(":even").filter(":even").filter(function() { return $(this).val() == ""; });
                target = target[0];
                target = target["name"];

                $("[name=" + "'" + target + "'" + "]").val(value);
                $("[name=" + "'" + target + "'" + "]").parent('div').parent('div').next("div").children("input").val(value);

                proccount++;
                check_box_with_value();
            });


            

            $(".diskListOption").on("dblclick", function() {
                console.log($(this).html());

                var value = $(this).val();
                var diskName = $(this).html();
                $(this).remove();

                row_count = get_empty_field_count("disk");
                if (row_count < 1) {
                    $(".diskList").find("a.wizard-add-row").trigger("click");
                }

                var diskDriveRows = $("[name^='serviceargs[disk]']").closest(".wz-fieldset");
                let newRowAdded = false;
                diskDriveRows.each(function() {
                    if (newRowAdded) return;

                    var diskNameInput = $(this).find($("[name^='serviceargs[disk]']"));
                    if (diskNameInput.val() != "") return;

                    diskNameInput.val(diskName);
                    $(this).find($("[name^='serviceargs[disk_warning]']")).val("80");
                    $(this).find($("[name^='serviceargs[disk_critical]']")).val("95");

                    newRowAdded = true;
                });
            });
          
            // $("#diskList").on("dblclick", function() {
            //     console.log("dl double clicked");

            //     var element = "";
            //     var element = $("#diskList option:selected");
            //     var selected = element.length;
            //     var value = element.text();
            //     console.log(value);
            //     element.remove();

            //     row_count = get_empty_field_count("disk");

            //     if (row_count < 1) {
            //         //$("#diskList").parent().prev().find("a.wizard-add-row").trigger("click");
            //         $(".diskList").find("a.wizard-add-row").trigger("click");
            //     }

            //     // find empty input
            //     var target = $("[name^='serviceargs[disk]']").filter(function() { return $(this).val() == ""; });
            //     target = target[0];
            //     target = target["name"];

            //     $("[name=" + "'" + target + "'" + "]").val(value);
            //     $("[name=" + "'" + target + "'" + "]").closest("td").children("input").val(value);
            
            //     var warning_target = $("[name^='serviceargs[disk_warning]']").filter(function() { return $(this).val() == ""; });
            //     if (warning_target.length != 0) {
            //         warning_target = warning_target[0];
            //         warning_target = warning_target["name"];
            //         $("[name=" + "'" + warning_target + "'" + "]").val("80"); 
            //     }
                
            //     var critical_target = $("[name^='serviceargs[disk_critical]']").filter(function() { return $(this).val() == ""; });
            //     if (critical_target.length  != 0) {
            //         critical_target = critical_target[0];
            //         critical_target = critical_target["name"];
            //         $("[name=" + "'" + critical_target + "'" + "]").val("95");  
            //     }
            // });












            $("#process-tip-btn").click(function() {
                if ($("#process-tips").is(":visible")) {
                    $("#process-tips").hide();
                    $("#ptips").val(0);
                    $("#process-tip-btn").html("<?= _("Tips") ?> <i class=\"fa fa-chevron-up\"></i>");
                } else {
                    $("#process-tips").show();
                    $("#ptips").val(1);
                    $("#process-tip-btn").html("<?= _("Tips") ?> <i class=\"fa fa-chevron-down\"></i>");
                }
            });
        });

        // Select all button
        $("[name=selectAll]").click(function() {
            $(this).closest(".position-absolute").find("select option").prop('selected', true);
        });

        function wizard_populate() {
            // populate scanned data
            var proclist = [<?= $process ?> ];
            proclist.sort(function (a, b) {
                return a.toLowerCase().localeCompare(b.toLowerCase());
            });

            var disklist = [<?= $disk ?>];
            disklist.sort(function (a, b) {
                return a.toLowerCase().localeCompare(b.toLowerCase());
            });

            var process_select = $("#processList");
            $.each(proclist, function(key, value) {
                process_select.append($("<option></option>").attr("value", key).text(value));
            });

            var disk_select = $("#diskList");
            $.each(disklist, function(key, value) {
                disk_select.append($("<option class='diskListOption'></option>").attr("value", key).text(value));
            });
        }

        function get_empty_field_count(type) {
            var input = "";
            target = "";

            // find empty input fields based on type
            if (type == "process") {
                target = $("[name^='serviceargs[processstate]']").filter(":even").filter(":even").filter(function() { return $(this).val() == ""; });
                var row_count = target.length;
            } else if (type == "disk") {
                input = "disk";

                target = $("[name^='serviceargs[disk]']").filter(function() { return $(this).val() == ""; });
                var row_count = target.length;
            }

            return row_count;
        }

        // make sure checkboxes are checked
        function check_box_with_value() {
            var processtargets = $("input[name^='serviceargs[processstate]']").filter(":even").filter(":even").filter(function() { return $(this).val() !== ""; });

            $.each(processtargets, function() {
                $(this).parent().find("input").attr("checked", true);
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
