    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="services_serial" value="<?= $services_serial ?>" />
    <input type="hidden" name="job" value="<?= encode_form_val($job) ?>">
    <input type="hidden" name="show" value="<?= encode_form_val($show) ?>">
    <input type="hidden" name="addresstype" value="<?= encode_form_val($addresstype) ?>">
    <input type="hidden" name="defaultservices" value="<?= encode_form_val($defaultservices) ?>">

<style type="text/css">
    .min-width-8em { min-width: 8em; }
    .min-width-20em { min-width: 20em; }
</style>

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2><?= _('Scan Results') ?></h2>
        <p><?= _('The hosts and services below were discovered during the auto-discovery scan. Select the hosts and services you would like to monitor') ?>.</p>
<?php
        $jobid = $job;
        $output_file = get_component_dir_base("autodiscovery")."/jobs/".$jobid.".xml";

        $total_hosts = 0;
        $new_hosts = 0;
        $xml = @simplexml_load_file($output_file);

        if ($xml) {
            foreach ($xml->device as $d) {
                $status = strval($d->status);
                //if ($status!="new")
                //continue;

                $address = strval($d->address);
                //$fqdns=strval($d->fqdns);
                $fqdns = @gethostbyaddr($address);

                $os = "";
                $type = "";

                $services[$address] = array(
                    "address" => $address,
                    "fqdns" => $fqdns,
                    "os" => $os,
                    "type" => $type,
                    "status" => $status,
                    "selected" => 0,
                    "ports" => array(),

                    "addressisdns" => 0,
                    "hostname" => $fqdns,
                );

                if ($addresstype == "ip") {
                    $services[$address]["hostaddress"] = $address;

                } else {
                    $dnsname = @gethostbyaddr($address);
                    if ($dnsname != $address)
                        $services[$address]["addressisdns"] = 1;
                    $services[$address]["hostaddress"] = $dnsname;
                    $services[$address]["hostname"] = $dnsname;
                }

                // get ports
                foreach ($d->ports->port as $p) {

                    $protocol = strval($p->protocol);
                    $port = strval($p->port);
                    $state = strval($p->state);

                    if ($state != "open") {
                        continue;
                    }

                    $service = getservbyport($port, strtolower($protocol));
                    $servicename = autodiscovery_configwizard_get_friendly_service_name($service, $port, $protocol);

                    // should the service be selected/shown?
                    $is_selected = 0;
                    $display_service = 1;

                    if ($defaultservices == "all") {
                        $is_selected = 1;

                    } else if ($defaultservices == "common") {
                        if (autodiscovery_configwizard_is_common_service($service, $port, $protocol) == true)
                            $is_selected = 1;
                    }

                    //echo "SELECTED: $is_selected<BR>";

                    if ($display_service == 1) {
                        $protocol = strtoupper($protocol);

                        $services[$address]["ports"][$protocol."".$port] = array(
                            "protocol" => $protocol,
                            "port" => $port,
                            "service" => $service,
                            "servicename" => $servicename,
                            "selected" => $is_selected
                        );
                    }
                }

                // Get operating system (first one in list)
                $services[$address]["os"] = strval($d->operatingsystems->osinfo->osname);
                $services[$address]["osaccuracy"] = intval($d->operatingsystems->osinfo->osaccuracy);

                // Get device type
                $services[$address]["type"] = get_autodiscovery_type($services[$address]["os"]);
            }
        } else {
?>
        <div class="alert alert-danger w-75">
            <div class="align-items-center d-flex pb-3">
                <img src="<?= theme_image("critical_small.png") ?>">
                <span class="fw-bold ps-2 pe-2"><?= _('No results were found in the selected auto-discovery scan') ?>.</span>
            </div>
        </div>
<?php
        }
?>
        <div class="table-responsive table-responsive-sm">
            <table class="table table-sm table-bordered table-bordered-neptune">
                <thead>
                    <tr class="fa-12">
                        <td class="align-middle" rowspan="2">
                            <input type="checkbox" id="cb_selectallhosts" name="selectallhosts" class="form-check-input">
                        </td>
                        <th scope="col" class="align-middle auto-disc-table-head" rowspan="2">
                            <?= _('Address') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head" rowspan="2">
                            <?= _('Type') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head" rowspan="2">
                            <?= _('OS') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head" rowspan="2">
                            <?= _('Status') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head text-nowrap" rowspan="2">
                            <?= _('Host Name') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head" colspan="5">
                            <?= _('Services') ?>
                        </th>
                    </tr>
                    <tr class="fa-12">
                        <td scope="col" class="align-middle">
                            <input type="checkbox" id="cb_selectallservices" name="selectallservices" class="form-check-input">
                        </td>
                        <th scope="col" class="align-middle min-width-20em auto-disc-table-head">
                            <?= _('Service Name') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head">
                            <?= _('Service') ?>
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head">
                            Port
                        </th>
                        <th scope="col" class="align-middle auto-disc-table-head">
                            <?= _('Protocol') ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
    foreach ($services as $address => $arr) {

        $status = "";

        if ($arr["status"] == "new") {
            $status = "New";
        } else {
            // skip old hosts
            if ($show == "new")
                continue;
            $status = "Old";
        }
?>
                    <tr class="fa-12">
                        <td class="align-middle">
                            <input type="checkbox" name="services[<?= encode_form_val($address) ?>][selected]" class="form-check-input ad_host_checkbox" <?= is_checked($services[$address]["selected"]) ?>>
                        </td>
                        <td class="align-middle">
                            <?= $services[$address]["hostaddress"] ?>
                            <?php if ($services[$address]["addressisdns"] == 1) { ?>
                                <br>
                                ( <?= $services[$address]["address"] ?> )
                            <?php } ?>
                        </td>
                        <td class="align-middle"><?= $arr["type"] ?></td>
                        <td class="align-middle"><?= $arr["os"] ?></td>
                        <td class="align-middle"><?= $status ?></td>
                        <td class="align-middle" colspan="6">
                            <input type="text" name="services[<?= encode_form_val($address) ?>][hostname]" value="<?= encode_form_val($arr["hostname"]) ?>" class="form-control form-control-sm">
                        </td>
                    </tr>
<?php
        foreach ($arr["ports"] as $pid => $parr) {
            $protocol = $parr["protocol"];
            $port = $parr["port"];
            $service = $parr["service"];
            $servicename = $parr["servicename"];
?>
                    <tr class="fa-12">
                        <td colspan="6"></td>

                        <input type="hidden" name="services[<?= encode_form_val($address) ?>][ports][<?= encode_form_val($protocol) ?><?= encode_form_val($port) ?>][service]" value="<?= encode_form_val($service) ?>">
                        <input type="hidden" name="services[<?= encode_form_val($address) ?>][ports][<?= encode_form_val($protocol) ?><?= encode_form_val($port) ?>][port]" value="<?= encode_form_val($port) ?>">
                        <input type="hidden" name="services[<?= encode_form_val($address) ?>][ports][<?= encode_form_val($protocol) ?><?= encode_form_val($port) ?>][protocol]" value="<?= encode_form_val($parr["protocol"]) ?>">

                        <td class="align-middle">
                            <input type="checkbox" name="services[<?= encode_form_val($address) ?>][ports][<?= encode_form_val($protocol) ?><?= encode_form_val($port) ?>][selected]" class="form-check-input ad_service_checkbox" <?= is_checked($services[$address]["ports"][$protocol."".$port]["selected"], 1) ?>>
                        </td>
                        <td class="align-middle">
                            <input type="text" name="services[<?= encode_form_val($address) ?>][ports][<?= encode_form_val($protocol) ?><?= encode_form_val($port) ?>][servicename]" class="form-control form-control-sm" value="<?= encode_form_val($servicename) ?>">
                        </td>
                        <td class="align-middle"><?= encode_form_val($service) ?></td>
                        <td class="align-middle"><?= encode_form_val($port) ?></td>
                        <td class="align-middle"><?= encode_form_val($protocol) ?></td>
                    </tr>
<?php
        }

        if (count($arr["ports"]) == 0) {
?>
                    <tr><td colspan="6"></td><td colspan="5"><?= _('No services were detected on this host') ?>.</td></tr>
<?php
        }
    }
?>
                </tbody>
            </table>
        </div> <!-- table-responsive -->

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {

            $("#cb_selectallhosts").blur();

            $("#cb_selectallhosts").click(function() {
                $(".ad_host_checkbox").prop("checked", $(this).is(":checked"));
            });

            $("#cb_selectallservices").click(function() {
                $(".ad_service_checkbox").prop("checked", $(this).is(":checked"));
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
