
import java.lang.IllegalArgumentException;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.JMXConnectorFactory;
import javax.management.openmbean.CompositeDataSupport;

import java.net.MalformedURLException;
import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.management.MBeanException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;
import javax.management.ReflectionException;

import java.util.Map;
import java.util.TreeMap;
import java.util.Date;
import java.util.Set;

public class JVMCheck {
	private NagiosThresholds[] checkThresholds;
	private MBeanServerConnection connection;
	private JMXConnector closeMe;

	public JVMCheck(String url, String username, String password) {
		Map<String, String[]> credentials = new TreeMap<String, String[]>();
		if (username != null && password != null) {
			credentials.put(JMXConnector.CREDENTIALS, new String[] {username, password});
		}
		connect(url, credentials);
	}

	public void connect(String urlString, Map<String, String[]> credentials) {
		JMXServiceURL urlJMX;
		try {
			urlJMX = new JMXServiceURL(urlString);
		}
		catch (MalformedURLException e) {
			throw new IllegalArgumentException("Service URL is malformed: " + e.getMessage());
		}
		if (urlJMX != null) {
			try {
				closeMe = JMXConnectorFactory.connect(urlJMX, credentials);
				connection = closeMe.getMBeanServerConnection();
			}
			catch (IOException e) {
				throw new IllegalArgumentException("Failed to connect: " + e.getMessage());
			}
		}
	}

	public void close() {
		if (closeMe != null) {
			try {
				closeMe.close();
			}
			catch (IOException e) {
				throw new IllegalArgumentException("Failed to close connection: " + e.getMessage());
			}
		}
	}

	// Returns true if a query would 'work'.
	public boolean queryNames(String potentialObjectName) {
		try {
			ObjectName asObjectName = new ObjectName(potentialObjectName);
			Set<ObjectName> existingObjectNames = connection.queryNames(asObjectName, null);
			return !(existingObjectNames.isEmpty());
		}
		catch (MalformedObjectNameException | IOException e) {
			System.out.println(e.getMessage());
			// This shouldn't ever happen in prod, since the literals are defined in populateCheckParameters.
			return false;
		}
	}

	public String getFirstObjectName(String potentialObjectNamePattern) {
		try {
			ObjectName asObjectName = new ObjectName(potentialObjectNamePattern);
			Set<ObjectName> existingObjectNames = connection.queryNames(asObjectName, null);
			return existingObjectNames.iterator().next().toString();
		}
		catch (MalformedObjectNameException | IOException e) {
			// This shouldn't ever happen in prod, since the literals are defined in populateCheckParameters.
			return potentialObjectNamePattern;
		}
	}

	public Object[] getValues(CheckParameters[] checks) {
		Object[] values = new Object[checks.length];
		for (int i = 0; i < checks.length; i++) {

			Object[] intermediates = new Object[checks[i].getSize()];
			for (int j = 0; j < intermediates.length; j++) {
				if (checks[i].isTimestamp(j)) {
					intermediates[j] = new Date().getTime()/60000.0; // UNIX epoch to minutes.
				}
				else if (checks[i].isMethod(j)) {
					try {
						intermediates[j] = connection.invoke(checks[i].getObjectName(j), checks[i].getMethAttrName(j), null, null);
					}
					catch (InstanceNotFoundException | MBeanException | ReflectionException | IOException e) {
						throw new IllegalArgumentException("Failed to get data for '" + checks[i].getObjectName(j) + "' with method '" + checks[i].getMethAttrName(j) + "':" + e.getMessage());
					}
				}
				else {
					try {
						intermediates[j] = connection.getAttribute(checks[i].getObjectName(j), checks[i].getMethAttrName(j));
					}
					catch (InstanceNotFoundException | MBeanException | ReflectionException | IOException | AttributeNotFoundException e) {
						throw new IllegalArgumentException("Failed to get data for '" + checks[i].getObjectName(j) + "' with attribute '" + checks[i].getMethAttrName(j) + "':" + e.getMessage());
					}
				}

				if (intermediates[j] instanceof CompositeDataSupport) {
					CompositeDataSupport temp = (CompositeDataSupport) intermediates[j];
					if (temp.containsKey(checks[i].getKey(j))) {
						intermediates[j] = temp.get(checks[i].getKey(j));
					}
					else {
						throw new IllegalArgumentException("Failed to use key " + checks[i].getKey(j) + ". On CompositeDataSupport: " + intermediates[j].toString());
					}
				}
			}

			values[i] = checks[i].getCheckValue(intermediates);

		}

		return values;
	}
}