#!/bin/bash

# This is essentially a configure script. 
# It reads the absolute path of the java executable and uses it to set the commandlines in java_as.cfg.
BASEDIR=$(dirname $(readlink -f $0))
ORIGINAL=$PWD
cd $BASEDIR

JAVA=$(which java 2>/dev/null)
if [[ -z $JAVA ]]; then
    # Have a default that relies on the path (some package could get installed
    # later that provides /usr/bin/java, for example)
    JAVA='java'
fi
sed -i 's,\(.*\)@JAVA@\(.*\),\1'"$JAVA"'\2,' $BASEDIR/templates/java_as.cfg

touch installed.java-as-configwizard
cd $ORIGINAL
