<?php
//
// Copyright (c) 2025 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/includes/common.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();

$theme = get_theme();
$neptune_palette = get_neptune_palette();
$base_url = get_base_url();

?>

<html>
    <head>
        <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/css/base.css?<?= get_build_id() ?>' />
        <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/css/themes/modern.bs5.css?<?= get_build_id() ?>' />
<?php
        if (is_dark_theme()) {
?>
        <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/css/themes/modern-dark.css?<?= get_build_id() ?>' />
<?php
            }
        else if ($theme == "colorblind") {
?>
       <link rel='stylesheet' type='text/css' href='<?= $base_url ?>includes/css/themes/colorblind.bs5.css?<?= get_build_id() ?>' />
<?php
        } else if (is_neptune()) {
?>
        <link rel='stylesheet' type='text/css' href='<?= $neptune_palette ?>?<?= get_build_id() ?>' />
        <link rel='stylesheet' type='text/css' href='<?= $base_url; ?>includes/css/themes/neptune.bs5.css?<?= get_build_id(); ?>' />
<?php
        } ?> 
    </head>

    <body>
        <h1>Gateway Timeout</h1>
            <p>The gateway did not receive a timely response from the upstream server or application.</p>
    </body>

</html>