<?php

namespace api\v2\account;
use api\v2\Base;

use function api\v2\import_common;
import_common();

/**
 * Gets the language
 */
class language extends Base {
    /**
     * Auth function for get request method on api/v2/account/language
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_get() {
        return true;
    }

    public function get() {
        $user_id = $_SESSION["user_id"];
        $language = get_user_meta($user_id, "language", "");

        if($language == "") {
            if (!empty($_SESSION['language'])) {
                $language = $_SESSION["language"];
            } else {
                // Try user-specific and global default language from DB
                $udblang = get_user_meta(0, "default_language");
                if (!empty($udblang)) {
                    $language = $udblang;
                } else {
                    $dblang = get_option("default_language");
                    $language = $dblang;
                }
            }
        }

        // Normalize old language values to avoid 404s
        if ($language == 'en' || $language == 'en_EN' || $language == '') {
            $language = 'en_US';
        }

        return [
            "language" => $language,
        ];
    }
}