<?php
namespace api\v2\admin\snmpwalk;
use api\v2\Base;

use function api\v2\import_common;
import_common();

class jobs extends Base {

    public function authorized_for_get() {
        return true;
    }

    // gets the contents of a single snmpwalk.log file with a name matching the specified hostname and unix date
    public function get() {
        $hostname = grab_request_var('hostname', null);
        $date = grab_request_var('date', null);

        if (!is_null($hostname) && !is_null($date)) {
            $job_file_dir = get_tmp_dir();
            $job_pattern = $job_file_dir . '/snmpwalk_' . $hostname . '_' . $date . '.log';
            //SNMP Walk output seems to sometimes have characters outside the standard charset, so encode to ensure this doesn't break the front end
            echo json_encode([
                'content_base64' => base64_encode(file_get_contents($job_pattern))
            ]);
            exit;
        } else {
            http_response_code(500);
            echo json_encode(['error' => 'Hostname and Date are required values']);
        }
    }

}