<?php

namespace api\v2\dashboards;
use api\v2\Base;
use Exception;

use function api\v2\import_common;
import_common();

/**
 * Handles cloning of dashboards.
 */
class copy extends Base {

    /**
     * Auth function for post request method on api/v2/account/dashboards/copy
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_post() {
        return true;
    }

    /**
     * Clones a dashboard based on the provided ID.
     * @return array Result of the cloning process.
     */
    public function post() {
        $id = grab_request_var("id", -1);
        $title = grab_request_var("title", "("._("Cloned").")");

        if(clone_dashboard_id(0, $id, $title)) {
            return ["message" => _("Dashboard successfully cloned.")];
        };
        throw new Exception(_("Could not clone dashboard"), 500);
    }
}